/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.file;

import com.sonicsw.ma.gui.JWorkspacePanel;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.action.CopyPluginAction;
import com.sonicsw.ma.gui.action.CutPluginAction;
import com.sonicsw.ma.gui.action.DeletePluginAction;
import com.sonicsw.ma.gui.action.PastePluginAction;
import com.sonicsw.ma.gui.action.PropSheetAction;
import com.sonicsw.ma.gui.action.RefreshPluginAction;
import com.sonicsw.ma.gui.action.RenamePluginAction;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.ma.plugin.IFilePlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.PluginAttributes;
import com.sonicsw.mx.config.IConfigBeanFile;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigServer;
import java.io.File;
import java.util.Map;
import javax.swing.JComponent;

public abstract class AbstractFilePlugin
extends AbstractGUIPlugin
implements IFilePlugin {
    public AbstractFilePlugin(IPluginContext context, String id, Map data) {
        super(context, id);
        this.setAttributes();
        this.getAttributes().put(data);
    }

    private void setAttributes() {
        this.setAttributes(new PluginAttributes());
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    protected JComponent[] getPropertiesMenuItems() {
        return new JComponent[]{new JBasicMenuItem(new PropSheetAction(this))};
    }

    @Override
    protected JComponent[] getEditMenuItems() {
        return new JComponent[]{new JBasicMenuItem(new CutPluginAction(this)), new JBasicMenuItem(new CopyPluginAction(this)), new JBasicMenuItem(new PastePluginAction(this))};
    }

    @Override
    protected JComponent[] getSystemMenuItems() {
        return new JComponent[]{new JBasicMenuItem(new DeletePluginAction(this)), new JBasicMenuItem(new RenamePluginAction(this))};
    }

    @Override
    protected JComponent[] getViewMenuItems() {
        return new JComponent[]{new JBasicMenuItem(new RefreshPluginAction(this))};
    }

    public IConfigBeanFile getFileByPath(String strPath) {
        try {
            IConfigServer server = this.getPluginContext().getConfigContext().getConfigServer();
            IConfigElement element = server.loadConfigElement(strPath);
            if (element instanceof IConfigBeanFile) {
                return (IConfigBeanFile)element;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        return null;
    }

    public static String buildFilePath(String path, String file) {
        StringBuffer buffer = new StringBuffer(path);
        if (buffer.charAt(buffer.length() - 1) != '/') {
            buffer.append('/');
        }
        buffer.append(file);
        return buffer.toString();
    }

    public String formatSize(Long size) {
        long s;
        long l = s = size == null ? 0L : size;
        if ((s /= 1024L) == 0L) {
            s = 1L;
        }
        return new StringBuffer().append(s).append(" KB").toString();
    }

    @Override
    public void renamePlugin(IConfigServer configServer, String newPath) throws Exception {
        if (this.getPluginPath().trim().equals(newPath.trim())) {
            throw new Exception("Can't rename - new path is same as old path");
        }
        configServer.rename(this.getPluginPath(), newPath);
    }

    public boolean isDragSupported(int dropAction) {
        return false;
    }

    public boolean isDropSupported(int dropAction) {
        return false;
    }

    public void drop(IConfigPlugin dropPlugin, int dropAction) {
        Helper.logDebugMessage("Drop '" + dropPlugin + "' into '" + this + "' (" + dropAction + ") - not handled");
    }

    @Override
    public boolean hasContent() {
        return false;
    }

    @Override
    public abstract void exportFile(File var1) throws Exception;

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    protected JWorkspacePanel getWorkspacePanel() {
        return this.getPluginContext().getWorkspace().getWorkspacePanel("Configure");
    }
}

