/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.file;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.config.ConfigFolderPlugin;
import com.sonicsw.ma.gui.file.AbstractFilePlugin;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.ExtendedImageIcon;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import modelobjects.framework.EditRule;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.swing.JTextFieldAdapter;

public class CreateFileAction
extends BasicPluginAction {
    public CreateFileAction(IPlugin plugin) {
        super(plugin, "file.new.file");
        this.putSmallIcon();
    }

    private void putSmallIcon() {
        this.putValue("SmallIcon", new ExtendedImageIcon((Icon)this.getValue("SmallIcon"), ResourceManager.getIcon(this.getClass(), "newoverlay")));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                block6: {
                    CreateFileDialog dialog = new CreateFileDialog(MgmtConsole.getMgmtConsole());
                    dialog.setVisible(true);
                    if (dialog.getCloseCommand() == 0) {
                        String name = ((CreateFileDialog.Model)dialog.getModel()).getName();
                        if (name != null && !name.trim().equals("")) {
                            try {
                                String strPathName = AbstractFilePlugin.buildFilePath(CreateFileAction.this.getPlugin().getPluginPath(), name);
                                if (!((AbstractGUIPlugin)CreateFileAction.this.getPlugin()).pathExists(strPathName)) {
                                    ((ConfigFolderPlugin)CreateFileAction.this.getPlugin()).importFile(null, strPathName);
                                    break block6;
                                }
                                MgmtConsole.getMgmtConsole().notifyMessage(4, "A file with the name you specified already exists", true);
                            }
                            catch (Exception e) {
                                MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to create file", e, true);
                            }
                        } else {
                            MgmtConsole.getMgmtConsole().notifyMessage(4, "No file name specified", true);
                        }
                    }
                }
            }
        });
        t.start();
    }

    @Override
    public boolean isEnabled() {
        return this.getPlugin().getPluginContext().getConnectionInfo().isConnected();
    }

    class CreateFileDialog
    extends JPropSheetDialog {
        private JTextField m_name;
        private Model m_model;

        public CreateFileDialog(JMAFrame parent) {
            super(parent, "create.file", Model.class);
            this.setResizable();
            this.m_model = new Model();
        }

        private void setResizable() {
            this.setResizable(false);
        }

        @Override
        public void maInitialize() {
            super.maInitialize();
            try {
                super.editInstance(null, this.m_model, false);
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Unable to initialize dialog.", e, true);
            }
        }

        @Override
        public void initUI() throws Exception {
            JPartitionPanel panel = new JPartitionPanel("");
            this.m_name = new JTextField(30);
            panel.addRow("File name", (JComponent)this.m_name);
            super.getContentPane().add(JPartitionPanel.wrap(panel));
        }

        @Override
        public void initForm() throws Exception {
            new JTextFieldAdapter(ModelAspectId.forName("name"), this.m_name, EditRule.ALWAYS, null, this.getMediator());
        }

        public class Model {
            private String m_name = null;

            public String getName() {
                return this.m_name;
            }

            public void setName(String name) {
                this.m_name = name;
            }
        }
    }
}

