/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.file;

import com.sonicsw.ma.gui.file.FileAssociation;
import com.sonicsw.ma.gui.file.FileElementModel;
import com.sonicsw.ma.gui.util.ResourceManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.Icon;

public class FileAssociationManager {
    private Map m_mapAssociations = new HashMap();

    private FileAssociationManager() {
        this.init();
    }

    public static FileAssociationManager getInstance() {
        return FileAssociationManagerHolder.INSTANCE;
    }

    public static FileAssociation getAssociation(String strFilename) {
        String strFileExt = FileElementModel.getFileExtension(strFilename);
        FileAssociation assoc = (FileAssociation)FileAssociationManager.getInstance().m_mapAssociations.get(strFileExt);
        if (assoc == null) {
            assoc = new FileAssociation(strFileExt, strFileExt + " File", ResourceManager.getTypeIcon("MF_FILE"));
        }
        return assoc;
    }

    private void init() {
        String[] list = this.getResourceAssociationNames();
        for (int i = 0; i < list.length; ++i) {
            String root = "file.assoc." + list[i];
            String strExt = ResourceManager.getString(this.getClass(), root + ".ext");
            String strDesc = ResourceManager.getString(this.getClass(), root + ".description");
            String strIcon = ResourceManager.getString(this.getClass(), root + ".icon");
            if (strExt == null) continue;
            Icon icon = null;
            icon = strIcon != null && !strIcon.equals("") ? ResourceManager.getIcon(this.getClass(), strIcon) : ResourceManager.getTypeIcon("MF_FILE");
            this.m_mapAssociations.put(strExt.toUpperCase(), new FileAssociation(strExt.toUpperCase(), strDesc, icon));
        }
    }

    private String[] getResourceAssociationNames() {
        String str = ResourceManager.getString(this.getClass(), "file.assoc.type.list");
        StringTokenizer st = new StringTokenizer(str, ",");
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken().trim());
        }
        return list.toArray(new String[0]);
    }

    private static class FileAssociationManagerHolder {
        private static final FileAssociationManager INSTANCE = new FileAssociationManager();

        private FileAssociationManagerHolder() {
        }
    }
}

