/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.file;

import com.sonicsw.ma.gui.file.FilePluginModel;
import com.sonicsw.ma.gui.propsheets.JPropSheetTabbedDialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.ResourceManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import modelobjects.framework.EditRule;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.ViewValueConverter;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.swing.JCheckBoxAdapter;
import modelobjects.framework.swing.JTextFieldAdapter;

public class FileElementDialog
extends JPropSheetTabbedDialog {
    private JTextField m_path = new JTextField();
    private JTextField m_type = new JTextField();
    private JTextField m_creationTime = new JTextField();
    private JTextField m_lastModifiedTime = new JTextField();
    private JTextField m_size = new JTextField();
    private JTextField m_createdBy = new JTextField();
    private JCheckBox m_system = new JCheckBox();

    public FileElementDialog(JMAFrame parent, String strFilename) {
        super(parent, "file-element", FilePluginModel.class);
        this.setProperties(strFilename);
    }

    private void setProperties(String strFilename) {
        this.setTitle(strFilename + " " + ResourceManager.getString(this.getClass(), "dialog.file-element.title"));
    }

    @Override
    public void initUI() throws Exception {
        String generalTab = ResourceManager.getString(this.getClass(), "dialog.file-element.tab.general.label");
        this.addTabPanel(generalTab, JPartitionPanel.wrap(this.createGeneralPanel()));
    }

    @Override
    public void initForm() throws Exception {
        new JTextFieldAdapter(ModelAspectId.forName("path"), this.m_path, EditRule.NEVER, null, this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("type"), this.m_type, EditRule.NEVER, null, this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("creationTime"), this.m_creationTime, EditRule.NEVER, null, this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("lastModifiedTime"), this.m_lastModifiedTime, EditRule.NEVER, null, this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("size"), this.m_size, EditRule.NEVER, new SizeViewValueConverter(), this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("createdBy"), this.m_createdBy, EditRule.NEVER, null, this.getMediator());
        new JCheckBoxAdapter(ModelAspectId.forName("system"), this.m_system, EditRule.NEVER, null, this.getMediator());
    }

    private JPanel createGeneralPanel() {
        JPartitionPanel panel = new JPartitionPanel(false, "p,r", "");
        panel.addRow(ResourceManager.getString(this.getClass(), "dialog.file-element.path.label"), (JComponent)this.m_path);
        panel.addRow(ResourceManager.getString(this.getClass(), "dialog.file-element.type.label"), (JComponent)this.m_type);
        panel.addRow(ResourceManager.getString(this.getClass(), "dialog.file-element.creationTime.label"), (JComponent)this.m_creationTime);
        panel.addRow(ResourceManager.getString(this.getClass(), "dialog.file-element.lastModifiedTime.label"), (JComponent)this.m_lastModifiedTime);
        panel.addRow(ResourceManager.getString(this.getClass(), "dialog.file-element.size.label"), (JComponent)this.m_size);
        panel.addRow(ResourceManager.getString(this.getClass(), "dialog.file-element.createdBy.label"), (JComponent)this.m_createdBy);
        panel.addRow(ResourceManager.getString(this.getClass(), "dialog.file-element.system.label"), (JComponent)this.m_system);
        return panel;
    }

    class SizeViewValueConverter
    implements ViewValueConverter {
        SizeViewValueConverter() {
        }

        @Override
        public Object viewValueToModel(Object viewValue) throws ViewValueConversionException {
            Object modelValue = null;
            try {
                if (viewValue != null) {
                    viewValue = Long.valueOf(viewValue.toString());
                }
            }
            catch (Exception e) {
                throw new ViewValueConversionException("Value is not a long!", e, ModelAspectId.forName("size"));
            }
            return modelValue;
        }

        @Override
        public Object modelValueToView(Object modelValue) throws ViewValueConversionException {
            if (modelValue != null) {
                if ((Long)modelValue == 0L) {
                    return "1";
                }
                return modelValue.toString();
            }
            return null;
        }

        @Override
        public String[] getViewStringValues() {
            return null;
        }

        @Override
        public boolean isViewValueToModelSupported() {
            return true;
        }

        @Override
        public Class getModelClass() {
            return Long.class;
        }

        @Override
        public Class getViewClass() {
            return String.class;
        }
    }
}

