/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.file;

import com.sonicsw.ma.gui.file.FileAssociationManager;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBeanFile;
import javax.swing.Icon;

public class FileElementModel {
    private IConfigBeanFile m_bean;

    public FileElementModel(IConfigBeanFile bean) {
        this.m_bean = bean;
    }

    public void refresh() throws ConfigServiceException {
        this.m_bean.refresh();
    }

    public String getName() {
        String name = this.m_bean.getName();
        return name.substring(name.lastIndexOf("/") + 1);
    }

    public String getPath() {
        if (this.m_bean == null) {
            return null;
        }
        String strResult = this.m_bean.getName();
        int index = strResult.lastIndexOf("/");
        if (index != -1) {
            strResult = strResult.substring(0, index + 1);
        }
        return strResult;
    }

    public Long getSize() {
        return this.m_bean != null ? new Long(this.m_bean.getFileSize()) : null;
    }

    public String getLastModifiedTime() {
        if (this.m_bean == null) {
            return null;
        }
        return Helper.getDateTimeString(new Long(this.m_bean.getLastModifiedTime()));
    }

    public String getCreationTime() {
        if (this.m_bean == null) {
            return null;
        }
        return Helper.getDateTimeString(new Long(this.m_bean.getCreationTime()));
    }

    public String getCreatedBy() {
        return this.m_bean != null ? this.m_bean.getCreateBy() : null;
    }

    public String getType() {
        return this.m_bean != null ? FileAssociationManager.getAssociation(this.m_bean.getName()).getDescription() : "Unknown";
    }

    public Icon getTypeIcon() {
        return this.m_bean != null ? FileAssociationManager.getAssociation(this.m_bean.getName()).getIcon() : null;
    }

    public static String getFileExtension(String strFilename) {
        String fileExt = new String("");
        int index = strFilename.lastIndexOf(46);
        if (index != -1) {
            fileExt = strFilename.substring(index + 1).toUpperCase();
        }
        return fileExt.trim();
    }
}

