/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.file;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.action.ExportPluginAction;
import com.sonicsw.ma.gui.file.AbstractFilePlugin;
import com.sonicsw.ma.gui.file.FileElementDialog;
import com.sonicsw.ma.gui.file.FileElementModel;
import com.sonicsw.ma.gui.file.FilePluginModel;
import com.sonicsw.ma.gui.file.OpenFileAction;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBeanFile;
import com.sonicsw.mx.config.IConfigServer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;

public class FileElementPlugin
extends AbstractFilePlugin {
    public static final String PLUGIN_TYPE = "MF_FILE";
    public static final String CONFIG_VERSION = "100";
    public static final Object[][] ATTRIBUTES = new Object[][]{{"TYPE", "MF_FILE"}, {"DISPLAY_TYPE", "File"}, {"CONFIG_VERSION", "100"}};
    private FilePluginModel m_model = null;

    public FileElementPlugin(IPluginContext context, String id, Map data) {
        super(context, id, data);
        this.getAttributes().put(ATTRIBUTES);
        this.setDisplayable(false);
    }

    @Override
    public void refresh() {
        try {
            FileElementModel model = (FileElementModel)this.getModel();
            model.refresh();
        }
        catch (ConfigServiceException e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to refresh model: " + this._getPluginPath(), e, false);
        }
        super.refresh();
    }

    @Override
    public void dispose() {
        this.m_model = null;
    }

    @Override
    public boolean expand() {
        return false;
    }

    public Icon getIcon() {
        return ((FileElementModel)this.getModel()).getTypeIcon();
    }

    @Override
    public JPropSheetDialog getPropSheetDialog() {
        return new FileElementDialog(MgmtConsole.getMgmtConsole(), this.getPluginFilename());
    }

    @Override
    public List getToolTipList() {
        List list = super.getToolTipList();
        FileElementModel model = (FileElementModel)this.getModel();
        list.add(this.formatToolTipText("Size", this.formatSize(model.getSize())));
        list.add(this.formatToolTipText("Date Modified", model.getLastModifiedTime()));
        return list;
    }

    public String getPluginFilename() {
        String strResult = this.getPluginPath();
        int index = strResult.lastIndexOf("/");
        if (index != -1) {
            strResult = strResult.substring(index + 1);
        }
        return strResult;
    }

    public String getPluginFilePath() {
        String strResult = this.getPluginPath();
        int index = strResult.lastIndexOf("/");
        if (index != -1) {
            strResult = strResult.substring(0, index + 1);
        }
        return strResult;
    }

    @Override
    protected JComponent[] getPluginMenuItems() {
        return new JComponent[]{new JBasicMenuItem(new OpenFileAction(this))};
    }

    @Override
    protected JComponent[] getSystemMenuItems() {
        ArrayList<JComponent> list = new ArrayList<JComponent>(Arrays.asList(super.getSystemMenuItems()));
        list.add(new JBasicMenuItem(new ExportPluginAction(this)));
        return list.toArray(new JComponent[list.size()]);
    }

    @Override
    public Object getModel() {
        if (this.m_model == null) {
            this.m_model = new FilePluginModel(this);
        }
        return this.m_model;
    }

    @Override
    public boolean hasContent() {
        boolean res = false;
        try {
            IConfigBeanFile bean = this.getFileByPath(this.getPluginPath());
            if (bean != null && bean.getContents() != null) {
                res = true;
            }
        }
        catch (ConfigServiceException e) {
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportFile(File file) throws Exception {
        block10: {
            OutputStream os = null;
            InputStream is = null;
            JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());
            try {
                int length;
                IConfigBeanFile bean = this.getFileByPath(this.getPluginPath());
                if (bean == null) {
                    throw new Exception("Failed to load file");
                }
                String name = this.getPluginName();
                try {
                    is = bean.getContents();
                }
                catch (ConfigServiceException e) {
                    MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                }
                if (is == null) break block10;
                os = new FileOutputStream(file);
                byte[] buffer = new byte[1000];
                while ((length = is.read(buffer)) != -1) {
                    ((FileOutputStream)os).write(buffer, 0, length);
                }
            }
            finally {
                if (os != null) {
                    os.flush();
                    ((FileOutputStream)os).close();
                }
                if (is != null) {
                    is.close();
                }
                wc.release();
            }
        }
    }

    @Override
    public void deletePlugin(IConfigServer configServer) throws Exception {
        configServer.removeConfigElement(this.getPluginPath());
    }
}

