/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.file;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.PreferenceManager;
import com.sonicsw.ma.gui.config.ConfigFolderPlugin;
import com.sonicsw.ma.gui.file.AbstractFilePlugin;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.plugin.IPlugin;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ImportFileAction
extends BasicPluginAction {
    public ImportFileAction(IPlugin plugin) {
        super(plugin, "file.import");
    }

    @Override
    public boolean isEnabled() {
        return this.getPlugin().getPluginContext().getConnectionInfo().isConnected();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                PreferenceManager pm = PreferenceManager.getInstance();
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle("Select Import File");
                fc.setMultiSelectionEnabled(true);
                fc.setCurrentDirectory(new File(pm.getString("preferences.export", "basePath", "")));
                fc.setApproveButtonText("Import");
                if (fc.showOpenDialog(MgmtConsole.getMgmtConsole()) == 0) {
                    File[] files = fc.getSelectedFiles();
                    for (int i = 0; i < files.length; ++i) {
                        String fullPath = files[i].getPath();
                        int index = fullPath.lastIndexOf(File.separator);
                        String path = fullPath.substring(0, index + 1);
                        String name = fullPath.substring(index + 1);
                        String strPathName = AbstractFilePlugin.buildFilePath(ImportFileAction.this.getPlugin().getPluginPath(), name);
                        if (i == 0) {
                            pm.setString("preferences.export", "basePath", path, true);
                        }
                        if (!this.validateFile(fullPath)) continue;
                        ((ConfigFolderPlugin)ImportFileAction.this.getPlugin()).addFile(new File(fullPath), name, false);
                    }
                }
            }

            private boolean validateFile(String fullPath) {
                boolean result = false;
                if (fullPath != null && (fullPath.endsWith(".xsl") || fullPath.endsWith(".xml")) && Boolean.getBoolean("sonicsw.import.validate.xml.xsl")) {
                    try {
                        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                        Document doc = dBuilder.parse(fullPath);
                        result = true;
                    }
                    catch (IOException | ParserConfigurationException | SAXException e) {
                        int doImport = JOptionPane.showConfirmDialog(MgmtConsole.getMgmtConsole(), "Validation failed for file " + fullPath, "Do you still want to import", 0);
                        if (doImport == 0) {
                            result = true;
                        }
                    }
                } else {
                    result = true;
                }
                return result;
            }
        });
        t.start();
    }
}

