/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.file;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.file.DefaultIconProvider;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.security.ManagementPermissionDeniedException;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.util.SonicFSException;
import com.sonicsw.mx.config.util.SonicFSFile;
import com.sonicsw.mx.config.util.SonicFSFileSystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.CellEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JSonicFileChooser
extends JPanel {
    private static final boolean DEBUG = false;
    private static int PREF_WIDTH = 500;
    private static int PREF_HEIGHT = 326;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    protected static final String[] FORMAT_NEW = new String[]{"New {0}{1,choice,1#|1< {1,number,integer}}"};
    protected static final SonicFileFilter ALL_FILTER = new AllFileFilter();
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    public static final int CUSTOM_DIALOG = 2;
    public static final int OPTION_CANCEL = 1;
    public static final int OPTION_APPROVE = 0;
    public static final int OPTION_ERROR = -1;
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    private String m_dialogTitle = null;
    private String m_approveButtonText = null;
    private JDialog m_dialog = null;
    private int m_dialogType = 0;
    private int m_returnValue = -1;
    private int m_fileSelectionMode = 0;
    private Vector<SonicFileFilter> m_filters = new Vector(5);
    private boolean m_includeAllFilter = true;
    private SonicFileFilter m_fileFilter = null;
    private SonicFSFile m_currentDirectory = null;
    private SonicFSFile m_selectedFile = null;
    private SonicFSFile[] m_selectedFiles;
    private SonicFSFile m_baseDir = null;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private SonicFSFileSystem m_fs = null;
    private JComboBox m_cbDirectory;
    private JFileList m_lShow;
    private JFileTextField m_tSelected;
    private JComboBox m_cbFilter;
    private JToolBar m_toolbar;
    static final int space = 10;

    public static void main(String[] arg) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        ConfigServerUtility csu = new ConfigServerUtility();
        try {
            csu.connect("Domain1", "localhost", "Administrator", "Administrator", false);
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        JSonicFileChooser chooser = new JSonicFileChooser(csu.getDirectoryService(), "test");
        chooser.setMultiSelectionEnabled(true);
        chooser.setIncludeAllFilter(false);
        chooser.setBaseDirectory("/System");
        chooser.addChoosableFileFilter(new SonicFileFilter(){

            @Override
            public boolean accept(SonicFSFile f) {
                return f.getFullName().toLowerCase().endsWith(".zip");
            }

            @Override
            public String getDescription() {
                return "Zip Files";
            }
        });
        chooser.addChoosableFileFilter(new SonicFileFilter(){

            @Override
            public boolean accept(SonicFSFile f) {
                return f.getFullName().toLowerCase().endsWith(".jar");
            }

            @Override
            public String getDescription() {
                return "JAR Files";
            }
        });
        chooser.setCurrentDirectory("sonicfs:///Containers");
        if (chooser.showOpenDialog(null) == 0) {
            SonicFSFile[] sel = chooser.getSelectedFiles();
            for (int i = 0; i < sel.length; ++i) {
                JSonicFileChooser.debugPrintln("Selected = '" + sel[i].toURL() + "'");
            }
        }
        System.exit(0);
    }

    private static void debugPrintln(String text) {
    }

    public JSonicFileChooser(IDirectoryFileSystemService ds, String user) {
        this(new TrivialCachedSonicFileSystem(ds, user), null);
    }

    public JSonicFileChooser(SonicFSFileSystem fs) {
        this(fs, null);
    }

    public JSonicFileChooser(SonicFSFileSystem fs, SonicFSFile currentDirectory) {
        super(new GridBagLayout());
        this.prepareJSonicFileChooser(fs, currentDirectory);
    }

    private void prepareJSonicFileChooser(SonicFSFileSystem fs, SonicFSFile currentDirectory) {
        this.m_fs = fs;
        this.m_currentDirectory = currentDirectory;
        if (currentDirectory == null) {
            this.m_currentDirectory = this.m_fs.getRootFile();
        }
        this.directoryComboBoxModel = new DirectoryComboBoxModel();
        this.m_toolbar = this.createToolBar();
        this.m_lShow = new JFileList(new SonicShowModel());
        this.m_lShow.setCellRenderer(new FileRenderer());
        this.m_lShow.setLayoutOrientation(1);
        this.m_lShow.setVisibleRowCount(-1);
        this.m_lShow.setSelectionMode(0);
        this.m_lShow.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() != 2 || evt.isPopupTrigger()) {
                    return;
                }
                int index = JSonicFileChooser.this.m_lShow.locationToIndex(evt.getPoint());
                if (index >= 0) {
                    SonicFSFile file = (SonicFSFile)JSonicFileChooser.this.m_lShow.getModel().getElementAt(index);
                    if (file.isDirectory()) {
                        JSonicFileChooser.this.directoryComboBoxModel.build(file);
                    } else {
                        JSonicFileChooser.this.approveSelection();
                    }
                }
            }
        });
        this.m_lShow.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                try {
                    if (evt.getValueIsAdjusting()) {
                        return;
                    }
                    int mode = JSonicFileChooser.this.getFileSelectionMode();
                    if (JSonicFileChooser.this.isMultiSelectionEnabled()) {
                        Object[] res = JSonicFileChooser.this.m_lShow.getSelectedValues();
                        HashSet<SonicFSFile> selSet = new HashSet<SonicFSFile>();
                        for (int i = 0; i < res.length; ++i) {
                            SonicFSFile aFile = (SonicFSFile)res[i];
                            if ((!JSonicFileChooser.this.isDirectorySelectionEnabled() || !aFile.isDirectory()) && (!JSonicFileChooser.this.isFileSelectionEnabled() || !aFile.isFile()) || selSet.contains(aFile)) continue;
                            selSet.add(aFile);
                        }
                        JSonicFileChooser.access$302(JSonicFileChooser.this, selSet.toArray(new SonicFSFile[0]));
                        JSonicFileChooser.this.m_tSelected.setFiles(JSonicFileChooser.this.m_selectedFiles.length == 0 ? null : JSonicFileChooser.this.m_selectedFiles);
                    } else {
                        SonicFSFile res = (SonicFSFile)JSonicFileChooser.this.m_lShow.getSelectedValue();
                        if (res == null) {
                            return;
                        }
                        if (JSonicFileChooser.this.isDirectorySelectionEnabled() && res.isDirectory() || JSonicFileChooser.this.isFileSelectionEnabled() && res.isFile()) {
                            JSonicFileChooser.this.m_selectedFile = res;
                            JSonicFileChooser.this.m_tSelected.setFile(JSonicFileChooser.this.m_selectedFile);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                }
            }
        });
        this.m_cbDirectory = new JComboBox(this.directoryComboBoxModel);
        this.m_cbDirectory.setRenderer(new DirectoryComboBoxRenderer());
        this.m_cbDirectory.setAlignmentX(0.0f);
        this.m_cbDirectory.setAlignmentY(0.0f);
        this.m_cbDirectory.setMaximumRowCount(8);
        this.m_cbDirectory.setSelectedItem(this.m_currentDirectory);
        this.m_cbDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                boolean bUp;
                SonicFSFile selDir = (SonicFSFile)((JComboBox)evt.getSource()).getSelectedItem();
                JSonicFileChooser.debugPrintln("Directory ComboBox Action");
                if (JSonicFileChooser.this.getCurrentDirectory().equals((Object)selDir)) {
                    return;
                }
                JSonicFileChooser.this.m_currentDirectory = selDir;
                ((SonicShowModel)JSonicFileChooser.this.m_lShow.getModel()).build(selDir);
                JSonicFileChooser.this.directoryComboBoxModel.build(selDir);
                JButton upBtn = JSonicFileChooser.this.getButtonWithCommand(JSonicFileChooser.this.m_toolbar, "Up");
                boolean bl = bUp = !selDir.equals((Object)JSonicFileChooser.this.getTopLevelDirectory());
                if (upBtn != null) {
                    upBtn.setEnabled(bUp);
                }
            }
        });
        this.m_tSelected = new JFileTextField();
        this.m_cbFilter = new JComboBox<Object>((Object[])this.getChoosableFileFilters());
        this.m_cbFilter.setMaximumRowCount(6);
        this.m_cbFilter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    JSonicFileChooser.this._setSonicFileFilter((SonicFileFilter)JSonicFileChooser.this.m_cbFilter.getSelectedItem());
                    if (JSonicFileChooser.this.m_dialog != null && JSonicFileChooser.this.m_dialog.isVisible()) {
                        ((SonicShowModel)JSonicFileChooser.this.m_lShow.getModel()).build(JSonicFileChooser.this.getCurrentDirectory());
                    }
                }
            }
        });
        GBConstraints gbc = new GBConstraints();
        gbc.set(0, 0, 1, 1, 2, 1.0, 0.0);
        gbc.insets = new Insets(5, 0, 0, 0);
        gbc.anchor = 17;
        this.add((Component)this.createTopPanel(), gbc);
        gbc.set(0, 1, 1, 1, 1, 1.0, 1.0);
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)new JScrollPane(this.m_lShow), gbc);
        gbc.set(0, 2, 1, 1, 2, 1.0, 0.0);
        gbc.insets = new Insets(5, 0, 0, 0);
        gbc.anchor = 17;
        this.add((Component)this.createBottomPanel(), gbc);
        this.resetChoosableFileFilters();
        this.setCurrentDirectory(currentDirectory);
        this.setPreferredSize(PREF_SIZE);
    }

    protected SonicFSFile getTopLevelDirectory() {
        SonicFSFile dir = this.getBaseDirectory();
        if (dir == null) {
            dir = this.m_fs.getRootFile();
        }
        return dir;
    }

    public void setBaseDirectory(SonicFSFile baseDir) {
        this.m_baseDir = baseDir.isDirectory() ? baseDir : baseDir.getParentFile();
        this.directoryComboBoxModel.build(this.getTopLevelDirectory());
    }

    public void setBaseDirectory(String baseDir) {
        SonicFSFile dir = null;
        try {
            dir = this.m_fs.getDetails(baseDir);
        }
        catch (SonicFSException e) {
            e.printStackTrace();
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            return;
        }
        this.setBaseDirectory(dir);
    }

    public SonicFSFile getBaseDirectory() {
        return this.m_baseDir;
    }

    public SonicFSFile getCurrentDirectory() {
        return this.m_currentDirectory;
    }

    private JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar(0);
        toolbar.setBorderPainted(false);
        toolbar.setFloatable(false);
        toolbar.setRollover(true);
        toolbar.add(new UpFolderAction());
        toolbar.add(new NewFolderAction());
        toolbar.add(new DetailsViewAction());
        this.getButtonWithCommand(toolbar, "Details").setEnabled(false);
        return toolbar;
    }

    private JPanel createTopPanel() {
        JPanel pDir = new JPanel(new GridBagLayout());
        GBConstraints gbc = new GBConstraints();
        gbc.set(0, 0, 1, 1, 0, 0.0, 0.0);
        gbc.insets = new Insets(0, 5, 0, 5);
        gbc.anchor = 17;
        pDir.add((Component)new JLabel("Look in:"), gbc);
        gbc.set(1, 0, 1, 1, 2, 1.0, 0.0);
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 17;
        pDir.add((Component)this.m_cbDirectory, gbc);
        gbc.set(2, 0, 1, 1, 0);
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 5, 0, 5);
        pDir.add((Component)this.m_toolbar, gbc);
        return pDir;
    }

    private JPanel createBottomPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GBConstraints gbc = new GBConstraints();
        gbc.set(0, 2, 2, 1, 2, 1.0, 0.0);
        gbc.insets = new Insets(0, 5, 0, 5);
        gbc.anchor = 17;
        panel.add((Component)this.createSelPanel(), gbc);
        gbc.set(2, 2, 1, 1, 0);
        gbc.insets = new Insets(0, 5, 5, 5);
        gbc.anchor = 13;
        panel.add((Component)this.createButtonPanel(), gbc);
        return panel;
    }

    private JPanel createSelPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GBConstraints gbc = new GBConstraints();
        gbc.set(0, 0, 1, 1, 0);
        gbc.insets = new Insets(0, 0, 0, 5);
        panel.add((Component)new JLabel("File name:"), gbc);
        gbc.set(1, 0, 1, 1, 2, 1.0, 0.0);
        gbc.insets = new Insets(0, 0, 5, 0);
        panel.add((Component)this.m_tSelected, gbc);
        gbc.set(0, 1, 1, 1, 0);
        gbc.insets = new Insets(0, 0, 0, 5);
        panel.add((Component)new JLabel("File of types:"), gbc);
        gbc.set(1, 1, 1, 1, 2, 1.0, 0.0);
        gbc.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.m_cbFilter, gbc);
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GBConstraints gbc = new GBConstraints();
        gbc.set(0, 0, 1, 1, 2, 1.0, 0.0);
        gbc.insets = new Insets(0, 0, 5, 0);
        panel.add((Component)new JButton(new OkAction(this.getDialogType())), gbc);
        gbc.set(0, 1, 1, 1, 2, 1.0, 0.0);
        gbc.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)new JButton(new CancelAction()), gbc);
        return panel;
    }

    private JButton getButtonWithCommand(JComponent c, String command) {
        JButton btn = null;
        if (c instanceof JButton && ((JButton)c).getActionCommand().equals(command)) {
            btn = (JButton)c;
        } else {
            for (int i = 0; i < c.getComponentCount() && (btn = this.getButtonWithCommand((JComponent)c.getComponent(i), command)) == null; ++i) {
            }
        }
        return btn;
    }

    String getFSName(SonicFSFile file) {
        try {
            if (file.equals((Object)this.m_fs.getRootFile())) {
                return this.m_fs.getDirectoryService().getDomain();
            }
        }
        catch (ManagementPermissionDeniedException e) {
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        return file.getName();
    }

    Icon getFSIcon(SonicFSFile file, boolean isSelected) {
        if (file.isFile()) {
            Icon fileIcon = this.getFileIcon();
            return fileIcon;
        }
        DefaultIconProvider instance = DefaultIconProvider.getInstance();
        if (isSelected) {
            Icon openIcon = UIManager.getIcon("Tree.openIcon");
            if (openIcon == null) {
                openIcon = instance.getIcon("FolderOpen");
            }
            return openIcon;
        }
        Icon closedIcon = UIManager.getIcon("Tree.closedIcon");
        if (closedIcon == null) {
            closedIcon = instance.getIcon("FolderClosed");
        }
        return closedIcon;
    }

    public Icon getFileIcon() {
        try {
            URL imgUrl = this.getClass().getClassLoader().getResource("com/sonicsw/ma/gui/image/type/MF_FILE.gif");
            return new ImageIcon(imgUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            return null;
        }
    }

    public void setIncludeAllFilter(boolean state) {
        this.m_includeAllFilter = state;
        if (state) {
            if (!this.m_filters.contains(ALL_FILTER)) {
                this.m_filters.add(ALL_FILTER);
                this.m_cbFilter.insertItemAt(ALL_FILTER, 0);
            }
        } else if (this.m_filters.contains(ALL_FILTER)) {
            this.m_filters.remove(ALL_FILTER);
            this.m_cbFilter.removeItem(ALL_FILTER);
        }
    }

    public boolean isIncludeAllFilter() {
        return this.m_includeAllFilter;
    }

    public SonicFileFilter[] getChoosableFileFilters() {
        return this.m_filters.toArray(new SonicFileFilter[this.m_filters.size()]);
    }

    public void addChoosableFileFilter(SonicFileFilter filter) {
        if (filter != null && !this.m_filters.contains(filter)) {
            this.m_filters.addElement(filter);
            this.m_cbFilter.addItem(filter);
        }
    }

    public boolean removeChoosableFileFilter(SonicFileFilter filter) {
        this.m_cbFilter.removeItem(filter);
        return this.m_filters.removeElement(filter);
    }

    public void resetChoosableFileFilters() {
        this.setSonicFileFilter(null);
        this.m_filters.removeAllElements();
        if (this.isIncludeAllFilter()) {
            this.m_filters.add(ALL_FILTER);
        }
        this.m_cbFilter.setModel(new DefaultComboBoxModel<SonicFileFilter>(this.getChoosableFileFilters()));
    }

    private void _setSonicFileFilter(SonicFileFilter filter) {
        this.m_fileFilter = filter;
        if (filter != null) {
            if (this.isMultiSelectionEnabled() && this.m_selectedFiles != null && this.m_selectedFiles.length > 0) {
                Vector<SonicFSFile> fList = new Vector<SonicFSFile>();
                boolean failed = false;
                for (int i = 0; i < this.m_selectedFiles.length; ++i) {
                    if (filter.accept(this.m_selectedFiles[i])) {
                        fList.add(this.m_selectedFiles[i]);
                        continue;
                    }
                    failed = true;
                }
                if (failed) {
                    this.setSelectedFiles(fList.isEmpty() ? null : fList.toArray(new SonicFSFile[fList.size()]));
                }
            } else if (this.m_selectedFile != null && !filter.accept(this.m_selectedFile)) {
                this.setSelectedFile(null);
            }
        }
    }

    public void setSonicFileFilter(SonicFileFilter filter) {
        this._setSonicFileFilter(filter);
        if (filter != null) {
            this.m_cbFilter.setSelectedItem(filter);
        }
    }

    public SonicFileFilter getSonicFileFilter() {
        return this.m_fileFilter;
    }

    public void setFileSelectionMode(int mode) {
        if (this.m_fileSelectionMode == mode) {
            return;
        }
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new IllegalArgumentException("Incorrect Mode for Dialog: " + mode);
        }
        int oldValue = this.m_fileSelectionMode;
        this.m_fileSelectionMode = mode;
    }

    public int getFileSelectionMode() {
        return this.m_fileSelectionMode;
    }

    public boolean isFileSelectionEnabled() {
        return this.m_fileSelectionMode == 0 || this.m_fileSelectionMode == 2;
    }

    public boolean isDirectorySelectionEnabled() {
        return this.m_fileSelectionMode == 1 || this.m_fileSelectionMode == 2;
    }

    public int showOpenDialog(Component parent) throws HeadlessException {
        this.setDialogType(0);
        return this.showDialog(parent, null);
    }

    public int showSaveDialog(Component parent) throws HeadlessException {
        this.setDialogType(1);
        return this.showDialog(parent, null);
    }

    public int getDialogType() {
        return this.m_dialogType;
    }

    public void setDialogType(int dialogType) {
        if (this.m_dialogType == dialogType) {
            return;
        }
        if (dialogType != 0 && dialogType != 1 && dialogType != 2) {
            throw new IllegalArgumentException("Incorrect Dialog Type: " + dialogType);
        }
        int oldValue = this.m_dialogType;
        this.m_dialogType = dialogType;
        if (dialogType == 0 || dialogType == 1) {
            this.setApproveButtonText(null);
        }
    }

    public void setDialogTitle(String dialogTitle) {
        String oldValue = this.m_dialogTitle;
        this.m_dialogTitle = dialogTitle;
        if (this.m_dialog != null) {
            this.m_dialog.setTitle(dialogTitle);
        }
    }

    public String getDialogTitle() {
        return this.m_dialogTitle;
    }

    public void setApproveButtonText(String approveButtonText) {
        if (this.m_approveButtonText == approveButtonText) {
            return;
        }
        String oldValue = this.m_approveButtonText;
        this.m_approveButtonText = approveButtonText;
    }

    public String getApproveButtonText() {
        return this.m_approveButtonText;
    }

    public void setMultiSelectionEnabled(boolean b) {
        this.m_lShow.getSelectionModel().setSelectionMode(b ? 2 : 0);
    }

    public boolean isMultiSelectionEnabled() {
        return this.m_lShow.getSelectionModel().getSelectionMode() != 0;
    }

    public void approveSelection() {
        this.m_returnValue = 0;
        if (this.m_dialog != null) {
            this.m_dialog.setVisible(false);
        }
    }

    public void cancelSelection() {
        this.m_returnValue = 1;
        if (this.m_dialog != null) {
            this.m_dialog.setVisible(false);
        }
    }

    public SonicFSFile getSelectedFile() {
        return this.m_selectedFile;
    }

    public void setSelectedFile(SonicFSFile file) {
        SonicFSFile oldValue = this.m_selectedFile;
        this.m_selectedFile = file;
        if (this.m_selectedFile != null) {
            if (file.isAbsolute() && !this.getCurrentDirectory().isParent(this.m_selectedFile)) {
                this.setCurrentDirectory(this.m_selectedFile.getParentFile());
            }
            if (!this.isMultiSelectionEnabled() || this.m_selectedFiles == null || this.m_selectedFiles.length > 1) {
                this.ensureFileIsVisible(this.m_selectedFile);
            }
        }
    }

    public SonicFSFile[] getSelectedFiles() {
        return this.m_selectedFiles != null ? (SonicFSFile[])this.m_selectedFiles.clone() : new SonicFSFile[]{};
    }

    public void setSelectedFiles(SonicFSFile[] selectedFiles) {
        SonicFSFile[] oldValue = this.m_selectedFiles;
        if (selectedFiles != null && selectedFiles.length == 0) {
            selectedFiles = null;
        }
        this.m_selectedFiles = selectedFiles;
        this.setSelectedFile(selectedFiles != null ? selectedFiles[0] : null);
    }

    private void ensureFileIsVisible(SonicFSFile file) {
        SonicShowModel model = (SonicShowModel)this.m_lShow.getModel();
        int i = model.indexOf(file);
        if (i >= 0) {
            this.m_lShow.ensureIndexIsVisible(i);
        }
    }

    public void setCurrentDirectory(SonicFSFile dir) {
        SonicFSFile newDir;
        if (dir == null) {
            newDir = this.getTopLevelDirectory();
        } else {
            SonicFSFile sonicFSFile = newDir = dir.isDirectory() ? dir : dir.getParentFile();
        }
        if (!newDir.getFullName().startsWith(this.getTopLevelDirectory().getFullName())) {
            newDir = this.getTopLevelDirectory();
        }
        this.m_currentDirectory = newDir;
    }

    public void setCurrentDirectory(String dir) {
        SonicFSFile newDir = null;
        try {
            String tmp = "sonicfs://";
            if (dir.startsWith(tmp)) {
                dir = dir.substring(tmp.length());
            }
            newDir = this.m_fs.getDetails(dir);
        }
        catch (SonicFSException e) {
            e.printStackTrace();
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            return;
        }
        this.setCurrentDirectory(newDir);
    }

    private void buildModels() {
        SonicFSFile currentDir = this.getCurrentDirectory();
        this.directoryComboBoxModel.build(currentDir);
        ((SonicShowModel)this.m_lShow.getModel()).build(currentDir);
    }

    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        if (approveButtonText != null) {
            this.setApproveButtonText(approveButtonText);
            this.setDialogType(2);
        }
        this.buildModels();
        this.m_dialog = this.createDialog(parent);
        this.m_dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                JSonicFileChooser.this.m_returnValue = 1;
            }
        });
        this.m_dialog.show();
        this.m_dialog.dispose();
        this.m_dialog = null;
        return this.m_returnValue;
    }

    protected JDialog createDialog(Component parent) throws HeadlessException {
        boolean supportsWindowDecorations;
        Frame frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        String title = this.getDialogTitle();
        JDialog dialog = new JDialog(frame, title, true);
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this, "Center");
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            dialog.getRootPane().setWindowDecorationStyle(6);
        }
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        return dialog;
    }

    static /* synthetic */ SonicFSFile[] access$302(JSonicFileChooser x0, SonicFSFile[] x1) {
        x0.m_selectedFiles = x1;
        return x1;
    }

    private static class TrivialCachedSonicFileSystem
    extends SonicFSFileSystem {
        private static final long CACHE_TTL = 50L;
        private String lastPath;
        private SonicFSFile[] lastPathDetails;
        private long lastAccessTime;

        public TrivialCachedSonicFileSystem(IDirectoryFileSystemService dfs, String user) {
            super(dfs, user);
        }

        public SonicFSFile[] listDetails(String path) throws SonicFSException {
            long now = System.currentTimeMillis();
            if (path.equals(this.lastPath) && now - this.lastAccessTime < 50L) {
                return this.lastPathDetails;
            }
            this.lastPathDetails = super.listDetails(path);
            this.lastPath = path;
            this.lastAccessTime = System.currentTimeMillis();
            return this.lastPathDetails;
        }

        public SonicFSFile createDirectory(String path) throws SonicFSException {
            this.clearCache();
            return super.createDirectory(path);
        }

        public SonicFSFile rename(SonicFSFile oldFile, String newName) throws SonicFSException {
            this.clearCache();
            return super.rename(oldFile, newName);
        }

        private void clearCache() {
            this.lastPath = null;
            this.lastAccessTime = 0L;
            this.lastPathDetails = null;
        }
    }

    class JFileList
    extends JList
    implements CellEditorListener,
    MouseMotionListener {
        protected transient ListCellEditor m_cellEditor;
        protected transient Component m_editorComp;
        protected transient int m_editingRow;
        private boolean m_surrendersFocusOnKeystroke;
        private PropertyChangeListener m_editorRemover;
        protected transient Timer m_timer;
        protected transient int m_delayRow;
        protected transient Point m_currPos;
        protected transient boolean m_selectionChanged;

        public JFileList(ListModel model) {
            super(model);
            this.m_editingRow = -1;
            this.m_surrendersFocusOnKeystroke = false;
            this.m_editorRemover = null;
            this.m_delayRow = -1;
            this.m_currPos = null;
            this.m_selectionChanged = true;
            this.prepareJFileList(model);
        }

        private void prepareJFileList(ListModel model) {
            this.m_timer = new Timer(750, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JSonicFileChooser.debugPrintln("Timer stop : sel changed = " + JFileList.this.m_selectionChanged);
                    JFileList.this.removeMouseMotionListener(JFileList.this);
                    JFileList.this.m_timer.stop();
                    if (JFileList.this.m_selectionChanged) {
                        JFileList.this.m_selectionChanged = false;
                    } else {
                        JFileList.this.editCellAt(JFileList.this.m_delayRow);
                    }
                    JFileList.this.m_currPos = null;
                    JFileList.this.m_delayRow = -1;
                }
            });
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent evt) {
                    if (evt.getValueIsAdjusting()) {
                        return;
                    }
                    JFileList.this.m_selectionChanged = JFileList.this.m_editingRow < 0 || evt.getFirstIndex() != JFileList.this.m_editingRow || evt.getLastIndex() != JFileList.this.m_editingRow;
                }
            });
            HashSet<KeyStroke> forwardFocusKeys = new HashSet<KeyStroke>();
            forwardFocusKeys.add(KeyStroke.getKeyStroke(9, 2));
            HashSet<KeyStroke> backwardFocusKeys = new HashSet<KeyStroke>();
            backwardFocusKeys.add(KeyStroke.getKeyStroke(9, 3));
            this.setFocusTraversalKeys(0, forwardFocusKeys);
            this.setFocusTraversalKeys(1, backwardFocusKeys);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (JFileList.this.isEditing()) {
                        JFileList.this.editingCanceled(null);
                    } else {
                        if (evt.getClickCount() != 1) {
                            return;
                        }
                        int index = JFileList.this.locationToIndex(evt.getPoint());
                        Rectangle cellBounds = JFileList.this.getCellBounds(index, index);
                        if (index >= 0 && cellBounds.contains(evt.getPoint())) {
                            JFileList.this.m_delayRow = index;
                            JFileList.this.m_currPos = evt.getPoint();
                            JSonicFileChooser.debugPrintln("Timer start");
                            JFileList.this.addMouseMotionListener(JFileList.this);
                            JFileList.this.m_timer.start();
                        }
                    }
                }
            });
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            this.mouseMoved(evt);
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            this.m_currPos = evt.getPoint();
        }

        @Override
        public void removeNotify() {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.m_editorRemover);
            this.m_editorRemover = null;
            super.removeNotify();
        }

        public void setSurrendersFocusOnKeystroke(boolean surrendersFocusOnKeystroke) {
            this.m_surrendersFocusOnKeystroke = surrendersFocusOnKeystroke;
        }

        public boolean getSurrendersFocusOnKeystroke() {
            return this.m_surrendersFocusOnKeystroke;
        }

        public boolean editCellAt(int row) {
            return this.editCellAt(row, null);
        }

        public boolean editCellAt(int row, EventObject e) {
            FileCellEditor editor;
            JSonicFileChooser.debugPrintln("editCellAt " + row);
            if (this.m_cellEditor != null && !this.m_cellEditor.stopCellEditing()) {
                return false;
            }
            if (row < 0 || row >= this.getModel().getSize()) {
                return false;
            }
            if (!this.isCellEditable(row)) {
                return false;
            }
            if (this.m_editorRemover == null) {
                KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                this.m_editorRemover = new CellEditorRemover(fm);
                fm.addPropertyChangeListener("permanentFocusOwner", this.m_editorRemover);
            }
            if ((editor = new FileCellEditor()) != null && editor.isCellEditable(e)) {
                this.m_editorComp = this.prepareEditor(editor, row);
                if (this.m_editorComp == null) {
                    this.removeEditor();
                    return false;
                }
                this.getSelectionModel().removeIndexInterval(row, row);
                this.m_editorComp.setBounds(this.getCellRect(row));
                this.add(this.m_editorComp);
                this.m_editorComp.validate();
                this.setCellEditor(editor);
                this.setEditingRow(row);
                ((JTextField)this.m_editorComp).selectAll();
                editor.addCellEditorListener(this);
                return true;
            }
            return false;
        }

        private Rectangle getCellRect(int row) {
            Rectangle r = this.getCellBounds(row, row);
            FileRenderer cr = (FileRenderer)this.getCellRenderer();
            Rectangle tmp = cr.getTextRectangle();
            r.x += tmp.x;
            r.width -= tmp.x;
            return r;
        }

        public void removeEditor() {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.m_editorRemover);
            this.m_editorRemover = null;
            ListCellEditor editor = this.getCellEditor();
            if (editor != null) {
                JSonicFileChooser.debugPrintln("removeEditor");
                editor.removeCellEditorListener(this);
                if (this.m_editorComp != null) {
                    this.remove(this.m_editorComp);
                }
                Rectangle cellRect = this.getCellRect(this.m_editingRow);
                this.setCellEditor(null);
                this.setEditingRow(-1);
                this.m_editorComp = null;
                this.repaint(cellRect);
            }
        }

        public ListCellEditor getCellEditor() {
            return this.m_cellEditor;
        }

        public void setCellEditor(ListCellEditor anEditor) {
            ListCellEditor oldEditor = this.m_cellEditor;
            this.m_cellEditor = anEditor;
            this.firePropertyChange("cellEditor", oldEditor, anEditor);
        }

        public boolean isCellEditable(int row) {
            SonicFSFile file = (SonicFSFile)this.getModel().getElementAt(row);
            if (file == null) {
                return false;
            }
            return !file.getFullName().startsWith("/System");
        }

        public void setEditingRow(int aRow) {
            this.m_editingRow = aRow;
        }

        public boolean isEditing() {
            return this.m_cellEditor != null;
        }

        public Component prepareEditor(ListCellEditor editor, int row) {
            JComponent jComp;
            boolean isSelected;
            Object value = this.getModel().getElementAt(row);
            Component comp = editor.getListCellEditorComponent(this, value, isSelected = this.isSelectedIndex(row), row);
            if (comp instanceof JComponent && (jComp = (JComponent)comp).getNextFocusableComponent() == null) {
                jComp.setNextFocusableComponent(this);
            }
            return comp;
        }

        public void setValueAt(Object value, int row) {
            DefaultListModel model = (DefaultListModel)this.getModel();
            model.set(row, value);
        }

        private void updateSubComponentUI(Object componentShell) {
            if (componentShell == null) {
                return;
            }
            Component component = null;
            if (componentShell instanceof Component) {
                component = (Component)componentShell;
            }
            if (componentShell instanceof DefaultCellEditor) {
                component = ((DefaultCellEditor)componentShell).getComponent();
            }
            if (component != null && component instanceof JComponent) {
                ((JComponent)component).updateUI();
            }
        }

        @Override
        public void editingStopped(ChangeEvent evt) {
            JSonicFileChooser.debugPrintln("editingStopped");
            ListCellEditor editor = this.getCellEditor();
            if (editor != null) {
                JSonicFileChooser.debugPrintln("editingStopped - ok");
                Object value = editor.getCellEditorValue();
                this.setValueAt(value, this.m_editingRow);
                if (!this.m_selectionChanged) {
                    this.getSelectionModel().setSelectionInterval(this.m_editingRow, this.m_editingRow);
                }
                this.removeEditor();
            }
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
            if (!this.m_selectionChanged) {
                this.getSelectionModel().setSelectionInterval(this.m_editingRow, this.m_editingRow);
            }
            this.removeEditor();
        }

        class CellEditorRemover
        implements PropertyChangeListener {
            KeyboardFocusManager focusManager;

            public CellEditorRemover(KeyboardFocusManager fm) {
                this.focusManager = fm;
            }

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                if (!JFileList.this.isEditing() || JFileList.this.getClientProperty("terminateEditOnFocusLost") != Boolean.TRUE) {
                    return;
                }
                for (Component c = this.focusManager.getPermanentFocusOwner(); c != null; c = c.getParent()) {
                    if (c == JFileList.this) {
                        return;
                    }
                    if (!(c instanceof Window)) continue;
                    if (c != SwingUtilities.getRoot(JFileList.this) || JFileList.this.getCellEditor().stopCellEditing()) break;
                    JFileList.this.getCellEditor().cancelCellEditing();
                    break;
                }
            }
        }
    }

    class JFileTextField
    extends JTextField {
        private SonicFSFile[] m_file = null;

        public void setFiles(SonicFSFile[] file) {
            this.m_file = file;
            StringBuffer sb = new StringBuffer();
            if (file != null) {
                for (int i = 0; i < file.length; ++i) {
                    if (i != 0) {
                        sb.append("; ");
                    }
                    sb.append(file[i].getName());
                }
            }
            this.setText(sb.toString());
        }

        public void setFile(SonicFSFile file) {
            SonicFSFile[] sonicFSFileArray;
            if (file == null) {
                sonicFSFileArray = null;
            } else {
                SonicFSFile[] sonicFSFileArray2 = new SonicFSFile[1];
                sonicFSFileArray = sonicFSFileArray2;
                sonicFSFileArray2[0] = file;
            }
            this.setFiles(sonicFSFileArray);
        }

        public SonicFSFile[] getFiles() {
            return this.m_file;
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JSonicFileChooser.this.cancelSelection();
        }
    }

    class OkAction
    extends AbstractAction {
        public OkAction(int dialogType) {
            super("OK");
            this.putActionProperties(dialogType);
        }

        private void putActionProperties(int dialogType) {
            if (dialogType == 0) {
                this.putValue("Name", "Open");
            } else if (dialogType == 1) {
                this.putValue("Name", "Save");
            } else if (dialogType == 2) {
                this.putValue("Name", JSonicFileChooser.this.getApproveButtonText());
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JSonicFileChooser.this.approveSelection();
        }
    }

    static class AllFileFilter
    extends SonicFileFilter {
        AllFileFilter() {
        }

        @Override
        public boolean accept(SonicFSFile f) {
            return true;
        }

        @Override
        public String getDescription() {
            return "All Files";
        }
    }

    public static abstract class SonicFileFilter {
        public abstract boolean accept(SonicFSFile var1);

        public abstract String getDescription();

        public String toString() {
            return this.getDescription();
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        boolean sel = false;

        protected FileRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            this.sel = isSelected;
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
                this.setText("");
            } else if (value instanceof SonicFSFile) {
                SonicFSFile file = (SonicFSFile)value;
                this.setIcon(JSonicFileChooser.this.getFSIcon(file, isSelected));
                this.setText(JSonicFileChooser.this.getFSName(file));
            } else {
                this.setIcon(null);
                this.setText(value == null ? "" : value.toString());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            return this;
        }

        private Rectangle getTextRectangle() {
            Icon icon;
            String text = this.getText();
            Icon icon2 = icon = this.isEnabled() ? this.getIcon() : this.getDisabledIcon();
            if (icon == null && text == null) {
                return null;
            }
            Rectangle paintIconR = new Rectangle();
            Rectangle paintTextR = new Rectangle();
            Rectangle paintViewR = new Rectangle();
            Insets paintViewInsets = new Insets(0, 0, 0, 0);
            paintViewInsets = this.getInsets(paintViewInsets);
            paintViewR.x = paintViewInsets.left;
            paintViewR.y = paintViewInsets.top;
            paintViewR.width = this.getWidth() - (paintViewInsets.left + paintViewInsets.right);
            paintViewR.height = this.getHeight() - (paintViewInsets.top + paintViewInsets.bottom);
            Graphics g = this.getGraphics();
            if (g == null) {
                return null;
            }
            String clippedText = SwingUtilities.layoutCompoundLabel(this, g.getFontMetrics(), text, icon, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), paintViewR, paintIconR, paintTextR, this.getIconTextGap());
            return paintTextR;
        }
    }

    protected class SonicShowModel
    extends DefaultListModel {
        public void build(SonicFSFile parent) {
            this.clear();
            try {
                SonicFSFile[] child = JSonicFileChooser.this.m_fs.listDetails(parent.getFullName());
                for (int i = 0; i < child.length; ++i) {
                    if (!child[i].isDirectory() && JSonicFileChooser.this.getSonicFileFilter() != null && !JSonicFileChooser.this.getSonicFileFilter().accept(child[i])) continue;
                    this.addElement(child[i]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            }
        }

        public int nearestIndexOf(SonicFSFile value) {
            for (int i = 0; i < this.getSize(); ++i) {
                SonicFSFile element = (SonicFSFile)this.getElementAt(i);
                int res = SonicFSFileSystem.COMPARATOR.compare(value, element);
                if (res == 0) {
                    return -1;
                }
                if (res >= 0) continue;
                return i;
            }
            return this.getSize();
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector<SonicFSFile> directories = new Vector();
        int[] depths = null;
        SonicFSFile selectedDirectory = null;

        public DirectoryComboBoxModel() {
            SonicFSFile dir = JSonicFileChooser.this.getCurrentDirectory();
        }

        private void build(SonicFSFile directory) {
            if (directory == null) {
                return;
            }
            this.directories.clear();
            SonicFSFile root = JSonicFileChooser.this.getTopLevelDirectory();
            SonicFSFile[] baseFolders = null;
            this.directories.add(root);
            try {
                baseFolders = JSonicFileChooser.this.m_fs.listDetails(root.getFullName());
            }
            catch (SonicFSException e) {
                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            }
            if (baseFolders != null) {
                this.directories.addAll(Arrays.asList(baseFolders));
            }
            try {
                SonicFSFile f = directory;
                Vector<SonicFSFile> path = new Vector<SonicFSFile>(10);
                do {
                    path.addElement(f);
                } while ((f = f.getParentFile()) != null);
                int pathCount = path.size();
                for (int i = 0; i < pathCount; ++i) {
                    f = (SonicFSFile)path.get(i);
                    if (!this.directories.contains(f)) continue;
                    int topIndex = this.directories.indexOf(f);
                    for (int j = i - 1; j >= 0; --j) {
                        this.directories.insertElementAt((SonicFSFile)path.get(j), topIndex + i - j);
                    }
                    break;
                }
                this.calculateDepths();
                this.setSelectedItem(directory);
            }
            catch (Exception e) {
                this.calculateDepths();
                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            }
        }

        public void removeAllELements() {
            if (!this.directories.isEmpty()) {
                int firstIndex = 0;
                int lastIndex = this.directories.size() - 1;
                this.directories.removeAllElements();
                this.fireIntervalRemoved(this, firstIndex, lastIndex);
            }
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            for (int i = 0; i < this.depths.length; ++i) {
                SonicFSFile dir = this.directories.get(i);
                this.depths[i] = 0;
                if (dir.getParent() == null) continue;
                do {
                    dir = dir.getParentFile();
                    int n = i;
                    this.depths[n] = this.depths[n] + 1;
                } while (dir.getParent() != null);
            }
        }

        public int getDepth(int i) {
            return this.depths != null && i >= 0 && i < this.depths.length ? this.depths[i] : 0;
        }

        @Override
        public void setSelectedItem(Object selectedDirectory) {
            this.selectedDirectory = (SonicFSFile)selectedDirectory;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        @Override
        public int getSize() {
            return this.directories.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.directories.elementAt(index);
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        IndentIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c.getComponentOrientation().isLeftToRight()) {
                this.icon.paintIcon(c, g, x + this.depth * 10, y);
            } else {
                this.icon.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        IndentIcon ii;

        DirectoryComboBoxRenderer() {
            this.ii = new IndentIcon();
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon;
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                this.setText("");
                return this;
            }
            SonicFSFile directory = (SonicFSFile)value;
            this.setText(JSonicFileChooser.this.getFSName(directory));
            this.ii.icon = icon = JSonicFileChooser.this.getFSIcon(directory, isSelected);
            this.ii.depth = JSonicFileChooser.this.directoryComboBoxModel.getDepth(index);
            this.setIcon(this.ii);
            return this;
        }
    }

    class ListViewAction
    extends AbstractAction {
        public ListViewAction() {
            super("List", UIManager.getIcon("FileChooser.listViewIcon"));
            this.putActionProperties();
        }

        private void putActionProperties() {
            this.putValue("ActionCommandKey", "List");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
        }
    }

    class DetailsViewAction
    extends AbstractAction {
        public DetailsViewAction() {
            super("Details", UIManager.getIcon("FileChooser.detailsViewIcon"));
            this.putActionProperties();
        }

        private void putActionProperties() {
            this.putValue("ActionCommandKey", "Details");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
        }
    }

    class HomeFolderAction
    extends AbstractAction {
        public HomeFolderAction() {
            super("Home", UIManager.getIcon("FileChooser.homeFolderIcon"));
            this.putActionProperties();
        }

        private void putActionProperties() {
            this.putValue("ActionCommandKey", "Home");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
        }
    }

    class UpFolderAction
    extends AbstractAction {
        public UpFolderAction() {
            super("Up", UIManager.getIcon("FileChooser.upFolderIcon"));
            this.putActionProperties();
        }

        private void putActionProperties() {
            this.putValue("ActionCommandKey", "Up");
            this.putValue("ShortDescription", "Up One Level");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            SonicFSFile parent = JSonicFileChooser.this.getCurrentDirectory().getParentFile();
            if (parent != null && parent.getFullName().startsWith(JSonicFileChooser.this.getTopLevelDirectory().getFullName())) {
                JSonicFileChooser.this.directoryComboBoxModel.build(parent);
            }
        }
    }

    class FileCellEditor
    extends DefaultCellEditor
    implements ListCellEditor {
        private SonicFSFile m_oldFile;
        private SonicFSFile m_newFile;

        public FileCellEditor() {
            super(new JTextField());
        }

        @Override
        public Component getListCellEditorComponent(JList list, Object value, boolean isSelected, int row) {
            JTextField c = (JTextField)this.editorComponent;
            this.m_oldFile = (SonicFSFile)value;
            this.m_newFile = null;
            c.setText(((SonicFSFile)value).getName());
            return c;
        }

        @Override
        public Object getCellEditorValue() {
            return this.m_newFile;
        }

        @Override
        public boolean stopCellEditing() {
            boolean res = false;
            JSonicFileChooser.debugPrintln("stopCellEditing");
            try {
                if (this.m_oldFile != null) {
                    String newName = ((JTextField)this.editorComponent).getText();
                    if (!newName.equals(this.m_oldFile.getName())) {
                        JSonicFileChooser.debugPrintln("rename");
                        this.m_newFile = JSonicFileChooser.this.m_fs.rename(this.m_oldFile, newName);
                        this.m_oldFile = null;
                    } else {
                        JSonicFileChooser.debugPrintln("nothing to rename");
                        this.m_newFile = this.m_oldFile;
                        this.m_oldFile = null;
                    }
                }
                res = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            }
            if (res) {
                super.stopCellEditing();
            }
            return res;
        }
    }

    static interface ListCellEditor
    extends CellEditor {
        public Component getListCellEditorComponent(JList var1, Object var2, boolean var3, int var4);
    }

    class NewFolderAction
    extends AbstractAction {
        public NewFolderAction() {
            super("New Folder", UIManager.getIcon("FileChooser.newFolderIcon"));
            this.putActionProperties();
        }

        private void putActionProperties() {
            this.putValue("ActionCommandKey", "New Folder");
            this.putValue("ShortDescription", "Create New Folder");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                String newPath = this.getValidPath(JSonicFileChooser.this.getCurrentDirectory().getFullName(), "Folder", FORMAT_NEW);
                SonicFSFile newFolder = JSonicFileChooser.this.m_fs.createDirectory(newPath);
                int insertIndex = ((SonicShowModel)JSonicFileChooser.this.m_lShow.getModel()).nearestIndexOf(newFolder);
                ((SonicShowModel)JSonicFileChooser.this.m_lShow.getModel()).add(insertIndex, newFolder);
                JSonicFileChooser.this.m_lShow.setSelectedValue(newFolder, true);
                JSonicFileChooser.this.m_lShow.editCellAt(insertIndex);
            }
            catch (Exception e) {
                e.printStackTrace();
                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            }
        }

        private String getValidPath(String basePath, String name, String[] pattern) {
            if (!basePath.endsWith("/")) {
                basePath = basePath + "/";
            }
            int i = 0;
            while (true) {
                String p = i >= pattern.length ? pattern[pattern.length - 1] : pattern[i];
                String candidate = MessageFormat.format(p, name, new Integer(i)).trim();
                String newPath = basePath + candidate;
                if (!JSonicFileChooser.this.m_fs.exists(newPath)) {
                    return newPath;
                }
                ++i;
            }
        }
    }

    class GBConstraints
    extends GridBagConstraints {
        public GBConstraints() {
            this.insets = new Insets(5, 5, 0, 0);
            this.anchor = 17;
        }

        public void set(int gridx, int gridy, int gridwidth, int gridheight, int fill) {
            this.set(gridx, gridy, gridwidth, gridheight, fill, 0.0, 0.0);
        }

        public void set(int gridx, int gridy, int gridwidth, int gridheight, int fill, double weightx, double weighty) {
            this.gridx = gridx;
            this.gridy = gridy;
            this.gridwidth = gridwidth;
            this.gridheight = gridheight;
            this.fill = fill;
            this.weightx = weightx;
            this.weighty = weighty;
        }
    }
}

