/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.file;

import com.sonicsw.ma.gui.IAssociationEditor;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.file.FileElementModel;
import com.sonicsw.ma.gui.file.FileElementPlugin;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.plugin.EditorInfo;
import com.sonicsw.ma.plugin.FileAssociationToolInfo;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.util.FileTrackerHandler;
import com.sonicsw.mx.config.IConfigBeanFile;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.util.SonicFSFileSystem;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;

public class OpenFileAction
extends BasicPluginAction {
    public OpenFileAction(IPlugin plugin) {
        super(plugin, "file.open");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.getTargetAction() != null) {
            super.actionPerformed(event);
        } else {
            if (!(this.getPlugin() instanceof FileElementPlugin)) {
                return;
            }
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    block6: {
                        FileElementPlugin pluginFE = (FileElementPlugin)OpenFileAction.this.getPlugin();
                        String filename = pluginFE.getPluginPath();
                        try {
                            if (!pluginFE.pathExists(pluginFE.getPluginPath())) break block6;
                            IPluginContext context = pluginFE.getPluginContext();
                            final IConfigServer server = context.getConfigContext().getConfigServer();
                            final IConfigBeanFile bean = pluginFE.getFileByPath(pluginFE.getPluginPath());
                            String extn = FileElementModel.getFileExtension(pluginFE.getPluginName());
                            HashMap editors = context.getLibrary().getEditorsMap();
                            EditorInfo eInfo = (EditorInfo)editors.get(extn.toLowerCase());
                            if (eInfo != null) {
                                Object editor = null;
                                try {
                                    Class<?> cls = Class.forName(eInfo.getClassName(), false, eInfo.getClassLoader());
                                    editor = cls.newInstance();
                                }
                                catch (Throwable e) {
                                    throw new Exception("Failed to create editor with class '" + eInfo.getClassName() + "'", e);
                                }
                                if (!(editor instanceof IAssociationEditor)) {
                                    throw new Exception("'" + eInfo.getClassName() + "' is not a valid editor");
                                }
                                IAssociationEditor iEditor = editor;
                                iEditor.aeInit(new SonicFSFileSystem(context.getConnectionInfo().getDirectoryService(), context.getConnectionInfo().getUserName()), null);
                                iEditor.aeOpenFile(pluginFE.getPluginPath());
                                break block6;
                            }
                            File fileTemp = File.createTempFile("sfs", "." + extn);
                            fileTemp.deleteOnExit();
                            pluginFE.exportFile(fileTemp);
                            FileAssociationToolInfo tool = new FileAssociationToolInfo(fileTemp);
                            tool.execute(new FileTrackerHandler(fileTemp){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void fileModified() {
                                    FileInputStream stream = null;
                                    try {
                                        stream = new FileInputStream(this.getFile());
                                        bean.setContents((InputStream)stream);
                                    }
                                    catch (Exception e) {
                                        MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to update local file", e, true);
                                    }
                                    finally {
                                        if (stream != null) {
                                            try {
                                                stream.close();
                                            }
                                            catch (Exception e) {
                                                e.printStackTrace();
                                                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                                            }
                                            stream = null;
                                        }
                                    }
                                }

                                @Override
                                public void fileFinished(int exitCode) {
                                    super.fileFinished(exitCode);
                                    try {
                                        if (bean.isModified()) {
                                            int ok = MgmtConsole.getMgmtConsole().showConfirmDialog("The file has been modified. Do you want to store these changes back into the Directory Service?", "Edit Confirmation", 3, 0);
                                            if (ok == 0) {
                                                server.storeConfigElement((IConfigElement)bean);
                                            } else {
                                                bean.refresh();
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        MgmtConsole.getMgmtConsole().notifyMessage(4, "Unable to persist file changes to the DS", e, true);
                                    }
                                }
                            });
                        }
                        catch (Throwable e) {
                            MgmtConsole.getMgmtConsole().notifyMessage(4, "Unable to edit file: " + (filename != null ? filename : ""), e, true);
                        }
                    }
                }
            });
            t.start();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.canDisplay();
    }

    @Override
    public boolean canDisplay() {
        if (Helper.isWindowsPlatform()) {
            return true;
        }
        String extn = FileElementModel.getFileExtension(this.getPlugin().getPluginName());
        return this.getPlugin().getPluginContext().getLibrary().getEditorsMap().get(extn.toLowerCase()) != null;
    }
}

