/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.messagelog;

import com.sonicsw.ma.gui.messagelog.MessageRowModel;
import com.sonicsw.ma.gui.messagelog.MessageTableModel;
import com.sonicsw.ma.gui.propsheets.JPropSheetTabbedDialog;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import modelobjects.framework.EditRule;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.ViewValueConverter;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.swing.JLabelAdapter;
import modelobjects.framework.swing.JTextAreaAdapter;
import modelobjects.framework.swing.JTextFieldAdapter;

public class JMessageDialog
extends JPropSheetTabbedDialog {
    private JLabel m_type = new JLabel();
    private JTextArea m_message = new JTextArea(10, 32);
    private JTextArea m_throwable = new JTextArea(10, 32);
    private JTextField m_time = new JTextField(32);

    public JMessageDialog(JMAFrame parent) {
        super(parent, "message.log.details", MessageRowModel.class);
    }

    private JPanel createGeneralPanel() {
        JPartitionPanel panel = new JPartitionPanel(false, "p,r", "");
        this.m_message.setWrapStyleWord(true);
        this.m_message.setLineWrap(true);
        panel.addRow("Type", (JComponent)this.m_type);
        panel.addRow("Time", (JComponent)this.m_time);
        panel.addRow("Message", (JComponent)new ExtendedJScrollPane(this.m_message));
        return panel;
    }

    private JPanel createTracePanel() {
        JPartitionPanel panel = new JPartitionPanel(true, "r", null);
        panel.add(new ExtendedJScrollPane(this.m_throwable));
        return panel;
    }

    @Override
    protected void initUI() throws Exception {
        this.addTabPanel("General", JPartitionPanel.wrap(this.createGeneralPanel()));
        MessageRowModel model = (MessageRowModel)this.getModel();
        if (model != null && model.getThrowable() != null) {
            this.addTabPanel("Trace", this.createTracePanel());
        }
    }

    @Override
    protected void initForm() throws Exception {
        new JTypeLabelAdapter(ModelAspectId.forName("typeInteger"), this.m_type, null, this.getMediator());
        new JTextAreaAdapter(ModelAspectId.forName("message"), this.m_message, EditRule.NEVER, null, this.getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("time"), this.m_time, EditRule.NEVER, new DateLongToStringConverter(), this.getMediator());
        if (this.m_throwable != null) {
            new JTextAreaAdapter(ModelAspectId.forName("throwableString"), this.m_throwable, EditRule.NEVER, null, this.getMediator());
        }
    }

    @Override
    public Action[] getButtonActions() {
        return new Action[]{new CloseAction((Action)this.getDefaultCancelAction())};
    }

    public class DateLongToStringConverter
    implements ViewValueConverter {
        @Override
        public Object viewValueToModel(Object viewValue) throws ViewValueConversionException {
            return null;
        }

        @Override
        public Object modelValueToView(Object modelValue) throws ViewValueConversionException {
            if (modelValue == null) {
                return "";
            }
            if (modelValue instanceof Long) {
                return Helper.getDateTimeString((Long)modelValue);
            }
            throw new ViewValueConversionException("Failed to convert value: " + modelValue);
        }

        @Override
        public String[] getViewStringValues() {
            return null;
        }

        @Override
        public boolean isViewValueToModelSupported() {
            return true;
        }

        @Override
        public Class getModelClass() {
            return Long.class;
        }

        @Override
        public Class getViewClass() {
            return String.class;
        }
    }

    public class JTypeLabelAdapter
    extends JLabelAdapter {
        public JTypeLabelAdapter(ModelAspectId modelAspectId, JLabel viewComponent, ViewValueConverter viewValueConverter, ModelEditMediator modelEditMediator) {
            super(modelAspectId, viewComponent, viewValueConverter, modelEditMediator);
        }

        @Override
        protected void setViewAspectValue(Object viewAspectValue) throws IllegalArgumentException {
            if (viewAspectValue == null) {
                ((JLabel)this.getViewComponent()).setText(null);
                ((JLabel)this.getViewComponent()).setIcon(null);
            } else if (viewAspectValue instanceof Integer) {
                int value = (Integer)viewAspectValue;
                ((JLabel)this.getViewComponent()).setText(MessageTableModel.logTypeToString(value));
                ((JLabel)this.getViewComponent()).setIcon(MessageTableModel.logTypeToIcon(value));
            } else {
                throw new IllegalArgumentException("value must be a Integer");
            }
        }
    }

    public class CloseAction
    extends BasicGuiAction {
        public CloseAction(Action targetAction) {
            super("dialog.close", targetAction);
        }
    }
}

