/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.messagelog;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.messagelog.JMessageDialog;
import com.sonicsw.ma.gui.messagelog.MessageTableModel;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.gui.util.JMAInternalFrame;
import com.sonicsw.ma.gui.util.JRowTable;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.gui.util.PopupMenuShower;
import com.sonicsw.ma.gui.util.ResourceManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class JMessageInternalFrame
extends JMAInternalFrame
implements MouseListener {
    private JRowTable m_table;

    public JMessageInternalFrame(MessageTableModel model) {
        super("message.viewer");
        this.setFrameIcon();
        this.m_table = new JRowTable(model, this.getClass().getName());
        this.m_table.addMouseListener(this);
    }

    private void setFrameIcon() {
        this.setFrameIcon(ResourceManager.getIcon(this.getClass(), "MessageLog"));
    }

    @Override
    public void maInitialize() {
        this.getContentPane().add(new ExtendedJScrollPane(this.m_table));
        JPopupMenu popup = new JPopupMenu();
        popup.add(new JBasicMenuItem(new ClearAllAction()));
        popup.add(new JBasicMenuItem(new ClearSelectedAction()));
        popup.add(new JBasicMenuItem(new PropertiesAction()));
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                Component[] components = ((JPopupMenu)e.getSource()).getComponents();
                for (int i = 0; i < components.length; ++i) {
                    Action action;
                    if (!(components[i] instanceof AbstractButton) || (action = ((AbstractButton)components[i]).getAction()) == null) continue;
                    components[i].setEnabled(action.isEnabled());
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.m_table.addMouseListener(new PopupMenuShower(this.m_table, popup));
    }

    @Override
    public void maCleanup() {
        if (this.m_table != null) {
            this.m_table.cleanup();
        }
        this.m_table = null;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        int row;
        if (evt.getClickCount() == 2 && (row = this.m_table.rowAtPoint(evt.getPoint())) >= 0) {
            this.launchDialog(row);
        }
    }

    private void launchDialog(int row) {
        try {
            JMessageDialog dialog = new JMessageDialog(MgmtConsole.getMgmtConsole());
            dialog.editInstance(null, ((IModelTableModel)this.m_table.getModel()).getRowModel(row), false);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Error launching dialog", e, true);
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    class PropertiesAction
    extends BasicGuiAction {
        PropertiesAction() {
            super("message.viewer.properties");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int[] rows = JMessageInternalFrame.this.m_table.getSelectedRows();
            if (rows.length > 0) {
                JMessageInternalFrame.this.launchDialog(rows[0]);
            }
        }

        @Override
        public boolean isEnabled() {
            int[] rows = JMessageInternalFrame.this.m_table.getSelectedRows();
            return rows.length == 1;
        }
    }

    class ClearSelectedAction
    extends BasicGuiAction {
        ClearSelectedAction() {
            super("message.viewer.clear.selected");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            JWaitCursor wc = new JWaitCursor(JMessageInternalFrame.this);
            try {
                int[] rows = JMessageInternalFrame.this.m_table.getSelectedRows();
                for (int i = rows.length - 1; i >= 0; --i) {
                    ((IModelTableModel)JMessageInternalFrame.this.m_table.getModel()).deleteRow(rows[i]);
                }
            }
            finally {
                wc.release();
            }
        }

        @Override
        public boolean isEnabled() {
            int[] rows = JMessageInternalFrame.this.m_table.getSelectedRows();
            return rows.length > 0;
        }
    }

    class ClearAllAction
    extends BasicGuiAction {
        ClearAllAction() {
            super("message.viewer.clear.all");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            if (MgmtConsole.getMgmtConsole().showConfirmDialog("Are you sure you want to clear all messages", "Clear Messages", 3, 0) == 0) {
                JWaitCursor wc = new JWaitCursor(JMessageInternalFrame.this);
                try {
                    ((IModelTableModel)JMessageInternalFrame.this.m_table.getModel()).clear();
                }
                finally {
                    wc.release();
                }
            }
        }
    }
}

