/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.messagelog;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.messagelog.MessageTableModel;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class MessageRowModel {
    protected int m_type;
    protected String m_domain;
    protected String m_message;
    protected Throwable m_throwable;
    protected long m_time;

    MessageRowModel(int type, String domain, String message, Throwable throwable) {
        this.m_type = type;
        this.m_domain = domain;
        this.m_message = message;
        this.m_throwable = throwable;
        this.m_time = System.currentTimeMillis();
    }

    public Integer getTypeInteger() {
        return new Integer(this.m_type);
    }

    public String getDomain() {
        return this.m_domain;
    }

    public String getMessage() {
        return this.m_message;
    }

    public Throwable getThrowable() {
        return this.m_throwable;
    }

    public String getThrowableString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        if (this.m_throwable != null) {
            MgmtConsole.printExceptionInfo(this.m_throwable, pw);
        }
        return sw.toString();
    }

    public long getTime() {
        return this.m_time;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append(MessageTableModel.logTypeToString(this.m_type)).append('\t');
        if (this.m_domain != null) {
            res.append(this.m_domain);
        }
        res.append('\t');
        if (this.m_message != null) {
            res.append(this.m_message);
        }
        res.append('\t');
        res.append(this.m_time);
        return res.toString();
    }
}

