/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.messagelog;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.PreferenceManager;
import com.sonicsw.ma.gui.messagelog.MessageRowModel;
import com.sonicsw.ma.gui.table.ModelListTableModel;
import com.sonicsw.ma.gui.table.RowTableColumn;
import com.sonicsw.ma.gui.util.ColorIcon;
import com.sonicsw.ma.gui.util.ExtendedImageIcon;
import com.sonicsw.ma.gui.util.ExtendedJTable;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.ResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.io.FileWriter;
import java.io.PrintWriter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class MessageTableModel
extends ModelListTableModel {
    private static final int COL_TYPE = 0;
    private static final int COL_DOMAIN = 1;
    private static final int COL_MESSAGE = 2;
    private static final int COL_TIME = 3;
    public static final boolean DEFAULT_LOGFILE = false;
    public static final int DEFAULT_LOGSHOW = 100;
    private static final TableColumn[] COL = new TableColumn[]{new MessageTableColumn(0, "Type", 0, 10), new MessageTableColumn(1, "Message", 2, 70), new MessageTableColumn(2, "Time", 3, 20)};
    private int m_currentLogLimit = this.getLogLimit();

    public MessageTableModel() {
        super(COL);
    }

    public synchronized void addMessage(int type, String domain, String message, Throwable throwable) {
        MessageRowModel data = new MessageRowModel(type, domain, message, throwable);
        this.maintainViewSize(this.getLogLimit());
        this.insertRow(data, this.getRowCount());
        try {
            if (this.isLogToFile() && !MgmtConsole.isLogToFileReset()) {
                this.logToFile(this.getLogFilePath(), data);
            }
        }
        catch (Exception e) {
            MgmtConsole.resetLogToFile(true);
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Error while writing to the log.", e, true);
        }
    }

    private int getLogLimit() {
        PreferenceManager manager = PreferenceManager.getInstance();
        return manager.getInt("preferences.messages", "logScreenShowLast", 100);
    }

    private boolean isLogToFile() {
        PreferenceManager manager = PreferenceManager.getInstance();
        return manager.getBoolean("preferences.messages", "logFile", false);
    }

    private String getLogFilePath() {
        PreferenceManager manager = PreferenceManager.getInstance();
        return manager.getString("preferences.messages", "logFilePath", null);
    }

    private void logToFile(String logFilePath, MessageRowModel data) throws Exception {
        PrintWriter writer = null;
        writer = new PrintWriter(new FileWriter(logFilePath, true));
        writer.println(data.toString());
        writer.flush();
        if (writer != null) {
            writer.close();
        }
    }

    private void maintainViewSize(int newLogLimit) {
        if (this.m_currentLogLimit != newLogLimit) {
            this.m_currentLogLimit = newLogLimit;
        }
        while (this.getRowCount() >= this.m_currentLogLimit) {
            this.deleteRow(0);
        }
    }

    public static final String logTypeToString(int type) {
        String key = "message-log.level." + Integer.toString(type);
        String value = ResourceManager.getString(MessageTableModel.class, key);
        return value != null ? value : "-";
    }

    public static final Icon logTypeToIcon(int type) {
        ColorIcon icon = null;
        switch (type) {
            case 1: {
                icon = new ColorIcon(Color.BLUE, 14);
                break;
            }
            case 2: {
                icon = new ColorIcon(Color.GREEN, 14);
                break;
            }
            case 3: {
                icon = new ColorIcon(Color.YELLOW, 14);
                break;
            }
            case 4: {
                icon = new ColorIcon(Color.RED, 14);
            }
        }
        return icon;
    }

    static class TypeTableCellRenderer
    extends ExtendedJTable.ExtendedTableCellRenderer {
        TypeTableCellRenderer() {
            this.setHorizontalAlignment();
        }

        private void setHorizontalAlignment() {
            this.setHorizontalAlignment(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null && value instanceof MessageRowModel) {
                MessageRowModel data = (MessageRowModel)value;
                this.setText(MessageTableModel.logTypeToString(data.m_type));
                this.setIcon(this.createIcon(data));
                this.setToolTipText(this, table, this.createToolTipText(data), column);
            } else {
                this.setText(null);
                this.setIcon(null);
                this.setToolTipText(this, table, null, column);
            }
            return this;
        }

        public String createToolTipText(MessageRowModel data) {
            StringBuffer sb = new StringBuffer(MessageTableModel.logTypeToString(data.m_type));
            if (data.m_throwable != null) {
                sb.append(" - Log available");
            }
            return sb.toString();
        }

        public ImageIcon createIcon(MessageRowModel data) {
            ExtendedImageIcon icon = new ExtendedImageIcon(MessageTableModel.logTypeToIcon(data.m_type));
            if (data.m_throwable != null) {
                icon.addOverlay(ResourceManager.getIcon(this.getClass(), "messageoverlay"));
            }
            return icon;
        }
    }

    static class MessageTableColumn
    extends RowTableColumn {
        private int m_id;

        MessageTableColumn(int modelIndex, String name, int id, int width) {
            super(modelIndex, name, width);
            this.prepareMessageTableColumn(id);
        }

        private void prepareMessageTableColumn(int id) {
            this.m_id = id;
            if (this.m_id == 0) {
                this.setCellRenderer(new TypeTableCellRenderer());
            }
            if (this.m_id == 3) {
                this.setColumnClass(Long.class);
                this.setCellRenderer(Helper.getDateTimeTableCellRenderer());
            }
        }

        @Override
        public Object getColumnValue(Object rowModel) {
            if (!(rowModel instanceof MessageRowModel)) {
                return null;
            }
            MessageRowModel data = (MessageRowModel)rowModel;
            Object value = null;
            switch (this.m_id) {
                case 0: {
                    return data;
                }
                case 1: {
                    if (data.m_domain == null) break;
                    value = data.m_domain;
                    break;
                }
                case 2: {
                    if (data.m_message == null) break;
                    value = data.m_message;
                    break;
                }
                case 3: {
                    value = new Long(data.m_time);
                }
            }
            return value;
        }
    }
}

