/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.perms;

import com.sonicsw.ma.gui.perms.PermissionsList;

public abstract class AbstractPermissions {
    private Principal principal;
    private int scope;
    protected int permissions;

    public AbstractPermissions(Principal principal) {
        this.principal = principal;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public String toString() {
        return this.getPrincipal().getName();
    }

    public int getScopeBits() {
        return this.scope;
    }

    public void setScopeBits(int scope) {
        this.scope = scope;
    }

    public int getPermissionsBits() {
        return this.permissions;
    }

    public void setPermissionsBits(int perms) {
        this.permissions = perms;
    }

    public void removePermissionBit(int perm) {
        this._removePermissionBits(perm);
        this.handlePermRemoved(perm);
    }

    protected void _removePermissionBits(int perm) {
        this.permissions &= ~perm;
    }

    public void addPermissionBit(int perm) {
        this._addPermissionBits(perm);
        this.handlePermAdded(perm);
    }

    protected void _addPermissionBits(int perm) {
        this.permissions |= perm;
        this._removePermissionBits(this.notOf(perm));
    }

    protected void handlePermAdded(int perm) {
    }

    protected void handlePermRemoved(int perm) {
    }

    protected int notOf(int perms) {
        int not = 0;
        int position = 1;
        int i = 1;
        while (i <= perms) {
            if ((i & perms) > 0) {
                not = position % 2 == 1 ? (not |= i << 1) : (not |= i >> 1);
                i <<= 1;
                ++position;
            }
            i <<= 1;
            ++position;
        }
        return not;
    }

    public String toDetailedString() {
        return this.getClass().getName() + "::{Principal :" + this.toString() + ", Scope :" + this.getScopeDisplayName() + ", Perms :" + this.getPermsDisplayName() + "}";
    }

    protected String nameFrom(PermissionsList.ScopeType[] scopeTypes) {
        int scopeBits = this.getScopeBits();
        for (int i = 0; i < scopeTypes.length; ++i) {
            PermissionsList.ScopeType folderScopeType = scopeTypes[i];
            if (scopeBits != folderScopeType.getBits()) continue;
            return folderScopeType.getDisplayName();
        }
        return null;
    }

    protected abstract String getScopeDisplayName();

    protected abstract String getPermsDisplayName();

    public static class Principal {
        private String name;
        private boolean isUser;

        public Principal(String name, boolean isUser) {
            this.name = name;
            this.isUser = isUser;
        }

        public String getName() {
            return this.name;
        }

        public boolean isUser() {
            return this.isUser;
        }

        public boolean isGroup() {
            return !this.isUser;
        }
    }
}

