/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.perms;

import com.sonicsw.ma.gui.perms.AbstractPermissions;
import com.sonicsw.ma.gui.perms.PermissionsList;
import com.sonicsw.mf.common.security.IConfigurePermissionBits;
import com.sonicsw.mf.common.security.IConfigureScopeBits;

public class ConfigurePermissions
extends AbstractPermissions
implements IConfigurePermissionBits,
IConfigureScopeBits {
    public static PermissionsList.ScopeType[] folderScopeTypes = new PermissionsList.ScopeType[]{new PermissionsList.ScopeType("This folder, its subfolders and all configurations/files", 11), new PermissionsList.ScopeType("This folder and its subfolders", 3), new PermissionsList.ScopeType("This folder and its configurations/files", 9), new PermissionsList.ScopeType("This folder's configurations/files only", 8), new PermissionsList.ScopeType("This folder's subfolders and all configurations/files", 10), new PermissionsList.ScopeType("This folder's subfolders only", 2), new PermissionsList.ScopeType("This folder only", 1)};
    public static PermissionsList.ScopeType[] fileOrConfigScopeTypes = new PermissionsList.ScopeType[]{new PermissionsList.ScopeType("This configuration/file only", 4)};
    public static final int ALLOW_FULL_CONTROL = 85;
    public static final int DENY_FULL_CONTROL = 170;
    public static PermissionsList.PermissionType[] permissionTypes = new PermissionsList.PermissionType[]{new PermissionsList.PermissionType("Full control", 85, 170), new PermissionsList.PermissionType("Read", 1, 2), new PermissionsList.PermissionType("Write", 4, 8), new PermissionsList.PermissionType("Delete", 16, 32), new PermissionsList.PermissionType("Set permissions", 64, 128)};

    public ConfigurePermissions(AbstractPermissions.Principal principal) {
        super(principal);
    }

    @Override
    public void removePermissionBit(int perm) {
        if (perm == 85 || perm == 170) {
            return;
        }
        super.removePermissionBit(perm);
    }

    @Override
    protected void handlePermAdded(int perm) {
        if (perm == 4 || perm == 16) {
            this._addPermissionBits(1);
        }
        if (perm == 2) {
            this._addPermissionBits(40);
        }
    }

    @Override
    protected void handlePermRemoved(int perm) {
        if (perm == 1) {
            this._removePermissionBits(20);
        }
    }

    public static String getPermissionName(int bit) {
        PermissionsList.PermissionType[] types = permissionTypes;
        for (int i = 0; i < types.length; ++i) {
            PermissionsList.PermissionType perm = types[i];
            if (bit == perm.allowBit) {
                return perm.name;
            }
            if (bit != perm.denyBit) continue;
            return "Deny " + perm.name;
        }
        return "Unknown Permission";
    }

    @Override
    protected String getScopeDisplayName() {
        String s = this.nameFrom(folderScopeTypes);
        if (s != null) {
            return s;
        }
        s = this.nameFrom(fileOrConfigScopeTypes);
        if (s != null) {
            return s;
        }
        return "?";
    }

    @Override
    protected String getPermsDisplayName() {
        int perms = this.getPermissionsBits();
        StringBuffer buf = new StringBuffer("[ ");
        for (int i = 0; i < permissionTypes.length; ++i) {
            PermissionsList.PermissionType type = permissionTypes[i];
            if ((perms & type.allowBit) == type.allowBit) {
                buf.append(type.name + ":Allow").append(",");
            }
            if ((perms & type.denyBit) != type.denyBit) continue;
            buf.append(type.name + ":Deny").append(",");
        }
        buf.setLength(buf.length() - 1);
        buf.append(" ]");
        return buf.toString();
    }
}

