/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.perms;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.perms.AbstractPermissions;
import com.sonicsw.ma.gui.perms.ConfigurePermissions;
import com.sonicsw.ma.gui.perms.PermissionsDialog;
import com.sonicsw.ma.gui.perms.PermissionsList;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.security.IManagementPermission;
import com.sonicsw.mf.common.security.IManagementSecurityConfigurator;
import com.sonicsw.mf.common.security.InvalidManagementPermissionException;
import com.sonicsw.mf.common.security.ManagementPermissionDeniedException;
import com.sonicsw.mf.common.security.ManagementPermissionFactory;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;

public class ConfigurePermsAction
extends BasicPluginAction {
    public static final String MGMT_SECURITY_CONFIG = "mgmtsecurity.config";
    protected static ManagementPermissionFactory factory = new ManagementPermissionFactory();
    protected IPlugin plugin;
    protected String[] paths;
    protected List b4SessionPerms;

    public ConfigurePermsAction(IPlugin plugin, String path) {
        this(plugin, path, MGMT_SECURITY_CONFIG);
    }

    public ConfigurePermsAction(IPlugin plugin, String path, String displaType) {
        super(displaType);
        this.plugin = plugin;
        this.paths = new String[]{path};
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        PermissionsList permsModel = this.makePermListModel();
        if (permsModel == null) {
            return;
        }
        this.b4SessionPerms = permsModel.getPermissions();
        final PermissionsDialog perms = new PermissionsDialog(this.plugin, permsModel, MgmtConsole.getMgmtConsole(), this.getDisplayType());
        perms.setVisible(true);
        if (perms.getCloseCommand() == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConfigurePermsAction.this.applyChanges(perms.getModel());
                }
            });
        }
    }

    private PermissionsList makePermListModel() {
        IDirectoryFileSystemService ds = this.plugin.getPluginContext().getConnectionInfo().getDirectoryService();
        PermissionsList permissionsList = this.makePermsList();
        try {
            IManagementPermission[][] managementPermissions = this.getPermsFromDS(ds);
            ArrayList<AbstractPermissions> perms = new ArrayList<AbstractPermissions>();
            for (int i = 0; i < managementPermissions[0].length; ++i) {
                IManagementPermission mgmtPerm = managementPermissions[0][i];
                String principal = mgmtPerm.getPrincipal();
                AbstractPermissions.Principal princi = new AbstractPermissions.Principal(principal, mgmtPerm.getPrincipalType() == 1);
                AbstractPermissions aPerms = this.makePerms(princi);
                aPerms.setPermissionsBits(mgmtPerm.getPermissions());
                aPerms.setScopeBits(mgmtPerm.getScope());
                perms.add(aPerms);
            }
            permissionsList.setPermissions(perms);
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(3, "Retrieving Permissions information failed", e, true);
            permissionsList = null;
        }
        return permissionsList;
    }

    private void applyChanges(PermissionsList model) {
        List aftSessionPerms = model.getPermissions();
        String[][] removedPrincis = new String[][]{this.getRemovedPrincis(this.b4SessionPerms, aftSessionPerms)};
        IManagementPermission[][] ipermissions = new IManagementPermission[1][aftSessionPerms.size()];
        for (int i = 0; i < aftSessionPerms.size(); ++i) {
            AbstractPermissions perms = (AbstractPermissions)aftSessionPerms.get(i);
            String principalName = perms.getPrincipal().getName();
            short principalType = perms.getPrincipal().isUser() ? (short)1 : 2;
            ipermissions[0][i] = factory.createManagementPermission(principalName, principalType, perms.getScopeBits(), perms.getPermissionsBits());
        }
        IDirectoryFileSystemService ds = this.plugin.getPluginContext().getConnectionInfo().getDirectoryService();
        try {
            if (removedPrincis[0].length > 0) {
                this.removePermsOnDS(ds, removedPrincis);
            }
            if (ipermissions[0].length > 0) {
                this.addOrUpdatePermsOnDS(ds, ipermissions);
            }
        }
        catch (DirectoryServiceException e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to set permissions:", e, true);
        }
        catch (InvalidManagementPermissionException e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to set permissions:", e, true);
        }
        catch (ManagementPermissionDeniedException e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to set permissions:", e, true);
        }
    }

    private String[] getRemovedPrincis(List b4SessionPerms, List aftSessionPerms) {
        ArrayList<String> removed = new ArrayList<String>();
        Object[] afts = new String[aftSessionPerms.size()];
        for (int i = 0; i < aftSessionPerms.size(); ++i) {
            AbstractPermissions aft = (AbstractPermissions)aftSessionPerms.get(i);
            afts[i] = aft.getPrincipal().getName();
        }
        Arrays.sort(afts);
        for (AbstractPermissions b4 : b4SessionPerms) {
            String name = b4.getPrincipal().getName();
            if (Arrays.binarySearch(afts, name) >= 0) continue;
            removed.add(name);
        }
        return removed.toArray(new String[removed.size()]);
    }

    protected void addOrUpdatePermsOnDS(IDirectoryFileSystemService ds, IManagementPermission[][] ipermissions) throws DirectoryServiceException, InvalidManagementPermissionException {
        ((IManagementSecurityConfigurator)ds).setManagementPermissions(this.paths, this.getType(), ipermissions);
    }

    protected void removePermsOnDS(IDirectoryFileSystemService ds, String[][] principals) throws DirectoryServiceException, InvalidManagementPermissionException {
        ((IManagementSecurityConfigurator)ds).removeManagementPermissions(this.paths, this.getType(), principals);
    }

    protected IManagementPermission[][] getPermsFromDS(IDirectoryFileSystemService ds) throws DirectoryServiceException {
        return ((IManagementSecurityConfigurator)ds).getManagementPermissions(this.paths, this.getType());
    }

    protected String getDisplayType() {
        return MGMT_SECURITY_CONFIG;
    }

    protected String getType() {
        return "configure";
    }

    protected PermissionsList makePermsList() {
        return new PermissionsList.ConfigurePermissionsList(this.plugin);
    }

    protected AbstractPermissions makePerms(AbstractPermissions.Principal princi) {
        return new ConfigurePermissions(princi);
    }
}

