/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.perms;

import com.sonicsw.ma.gui.perms.AbstractPermissions;
import com.sonicsw.ma.gui.perms.PermissionsList;
import com.sonicsw.mf.common.security.IManagePermissionBits;
import com.sonicsw.mf.common.security.IManageScopeBits;

public class ManagePermissions
extends AbstractPermissions
implements IManagePermissionBits,
IManageScopeBits {
    public static PermissionsList.ScopeType[] folderScopeTypes = new PermissionsList.ScopeType[]{new PermissionsList.ScopeType("This folder's and subfolders' containers and components", 21), new PermissionsList.ScopeType("This folder's and subfolders' containers", 5), new PermissionsList.ScopeType("This folder's and subfolders' components", 17), new PermissionsList.ScopeType("This folder's containers and components", 20), new PermissionsList.ScopeType("This folder's containers only", 4), new PermissionsList.ScopeType("This folder's components only", 16)};
    public static PermissionsList.ScopeType[] containerScopeTypes = new PermissionsList.ScopeType[]{new PermissionsList.ScopeType("This container and its components", 18), new PermissionsList.ScopeType("This container only", 2), new PermissionsList.ScopeType("This container's components only", 16)};
    public static PermissionsList.ScopeType[] componentScopeTypes = new PermissionsList.ScopeType[]{new PermissionsList.ScopeType("This component only", 8)};
    public static final int ALLOW_FULL_CONTROL = 1365;
    public static final int DENY_FULL_CONTROL = 2730;
    public static PermissionsList.PermissionType[] permissionTypes = new PermissionsList.PermissionType[]{new PermissionsList.PermissionType("Full control", 1365, 2730), new PermissionsList.PermissionType("Life cycle control", 1, 2), new PermissionsList.PermissionType("Enable/disable metrics", 4, 8), new PermissionsList.PermissionType("Subscribe to notifications", 16, 32), new PermissionsList.PermissionType("Set attributes", 64, 128), new PermissionsList.PermissionType("Other actions", 256, 512), new PermissionsList.PermissionType("Get information", 1024, 2048)};

    public ManagePermissions(AbstractPermissions.Principal principal) {
        super(principal);
    }

    @Override
    public void removePermissionBit(int perm) {
        if (perm == 1365 || perm == 2730) {
            return;
        }
        super.removePermissionBit(perm);
    }

    public static String getPermissionName(int bit) {
        PermissionsList.PermissionType[] types = permissionTypes;
        for (int i = 0; i < types.length; ++i) {
            PermissionsList.PermissionType perm = types[i];
            if (bit == perm.allowBit) {
                return perm.name;
            }
            if (bit != perm.denyBit) continue;
            return "Deny " + perm.name;
        }
        return "Unknown Permission";
    }

    @Override
    protected String getScopeDisplayName() {
        String s = this.nameFrom(folderScopeTypes);
        if (s != null) {
            return s;
        }
        s = this.nameFrom(containerScopeTypes);
        if (s != null) {
            return s;
        }
        s = this.nameFrom(componentScopeTypes);
        if (s != null) {
            return s;
        }
        return "?";
    }

    @Override
    protected String getPermsDisplayName() {
        int perms = this.getPermissionsBits();
        StringBuffer buf = new StringBuffer("[ ");
        for (int i = 0; i < permissionTypes.length; ++i) {
            PermissionsList.PermissionType type = permissionTypes[i];
            if ((perms & type.allowBit) == type.allowBit) {
                buf.append(type.name + ":Allow").append(",");
            }
            if ((perms & type.denyBit) != type.allowBit) continue;
            buf.append(type.name + ":Deny").append(",");
        }
        buf.setLength(buf.length() - 1);
        buf.append(" ]");
        return buf.toString();
    }
}

