/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.perms;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.config.AbstractConfigPlugin;
import com.sonicsw.ma.gui.config.ConfigDomainFolderPlugin;
import com.sonicsw.ma.gui.config.ConfigFolderPlugin;
import com.sonicsw.ma.gui.perms.ConfigurePermissions;
import com.sonicsw.ma.gui.perms.ConfigurePermsAction;
import com.sonicsw.ma.gui.perms.ManagePermissions;
import com.sonicsw.ma.gui.perms.ManagePermsAction;
import com.sonicsw.ma.gui.perms.ManagementSecurityAction;
import com.sonicsw.ma.gui.runtime.AbstractRuntimePlugin;
import com.sonicsw.ma.gui.util.JBasicMenu;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.security.ConfigurePermissionDeniedException;
import com.sonicsw.mf.common.security.IManagementPermission;
import com.sonicsw.mf.common.security.IManagementSecurityConfigurator;
import com.sonicsw.mf.common.security.ManagePermissionDeniedException;
import com.sonicsw.mf.common.security.ManagementPermissionDeniedException;
import com.sonicsw.mx.config.ConfigServiceException;
import java.util.Arrays;
import javax.swing.JComponent;

public class ManagementSecurityUtils {
    public static final String MF_CONTAINER = "MF_CONTAINER";
    public static final String AUTHENTICATION_DOMAIN = "AUTHENTICATION_DOMAIN";
    public static final String[] LOG4J_CONFIG_TYPES = new String[]{"*.xml", "*.properties", "*.*"};

    public static boolean allowsConfigPerms(IPlugin plugin) {
        String type = plugin.getAttributes().getType();
        return plugin.getAttributes().isCreatable() || plugin.getAttributes().isComponent() || "MF_FILE".equals(type) || ManagementSecurityUtils.isFolder(plugin);
    }

    public static Readability getReadability(IPlugin plugin) {
        try {
            IDirectoryFileSystemService ds = plugin.getPluginContext().getConnectionInfo().getDirectoryService();
            IManagementPermission[][] iManagementPermissionArray = ((IManagementSecurityConfigurator)ds).getManagementPermissions(new String[]{plugin.getPluginPath()}, "configure");
        }
        catch (ConfigurePermissionDeniedException e) {
            return new Readability(plugin, false, ManagementSecurityUtils.getErrorMessageFor((ManagementPermissionDeniedException)((Object)e)));
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        return new Readability(plugin, true, null);
    }

    public static boolean allowsManagePerms(IPlugin plugin) {
        String type = plugin.getAttributes().getType();
        return plugin instanceof AbstractConfigPlugin && MF_CONTAINER.equals(type) || ManagementSecurityUtils.isFolder(plugin);
    }

    public static boolean hasManagePerms(IPlugin plugin) {
        String type = plugin.getAttributes().getType();
        return plugin instanceof AbstractRuntimePlugin && MF_CONTAINER.equals(type) || ManagementSecurityUtils.isFolder(plugin) || plugin.getAttributes().isComponent() || MF_CONTAINER.equals(((IPlugin)((Object)((AbstractGUIPlugin)plugin).getParent())).getAttributes().getType());
    }

    public static boolean isFolder(IPlugin plugin) {
        return plugin != null && (plugin.getClass().equals(ConfigDomainFolderPlugin.class) || plugin.getClass().equals(ConfigFolderPlugin.class));
    }

    public static String getSecurityDomain(IPlugin plugin) {
        try {
            IDirElement domainElement = ((IManagementSecurityConfigurator)plugin.getPluginContext().getConnectionInfo().getDirectoryService()).getDomainElement(false);
            IAttributeSet attributes = domainElement.getAttributes();
            Reference authDomanRef = (Reference)attributes.getAttribute(AUTHENTICATION_DOMAIN);
            String elementName = authDomanRef.getElementName();
            String path = plugin.getPluginContext().getConnectionInfo().getDirectoryService().storageToLogical(elementName);
            if (path.endsWith("_Default") || path.endsWith("_MFDomainDescriptor") || path.endsWith("_MQPolicyDescriptor")) {
                int lastIndex = path.lastIndexOf(47);
                path = path.substring(0, lastIndex);
            }
            return path;
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            return null;
        }
    }

    public static boolean isManagementSecurityEnabled(IPlugin plugin) {
        try {
            IDirElement domainElement = ((IManagementSecurityConfigurator)plugin.getPluginContext().getConnectionInfo().getDirectoryService()).getDomainElement(false);
            IAttributeSet attributes = domainElement.getAttributes();
            Reference authDomanRef = (Reference)attributes.getAttribute(AUTHENTICATION_DOMAIN);
            if (authDomanRef == null) {
                return false;
            }
            String elementName = authDomanRef.getElementName();
            return elementName != null && elementName.trim().length() > 0;
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            return false;
        }
    }

    public static String[] getAllowedLog4jConfigExtensions() {
        return Arrays.copyOf(LOG4J_CONFIG_TYPES, LOG4J_CONFIG_TYPES.length);
    }

    public static JComponent[] getPermissionsMenuItems(IPlugin plugin) {
        boolean allowsConfig = ManagementSecurityUtils.allowsConfigPerms(plugin);
        boolean allowsManage = ManagementSecurityUtils.allowsManagePerms(plugin);
        if (!allowsConfig && !allowsManage) {
            return new JComponent[0];
        }
        String pluginPath = plugin.getPluginPath();
        return ManagementSecurityUtils._getMenuItems(plugin, pluginPath, allowsConfig, allowsManage);
    }

    public static JComponent[] getComponentPermissionsMenuItems(IPlugin componentPlugin, String componentPath) {
        return ManagementSecurityUtils._getMenuItems(componentPlugin, componentPath, false, true);
    }

    private static JComponent[] _getMenuItems(IPlugin plugin, String pluginPath, boolean allowsConfig, boolean allowsManage) {
        JComponent[] ret = new JComponent[1];
        JBasicMenu permsMenu = new JBasicMenu(new ManagementSecurityAction());
        ConfigurePermsAction cAction = new ConfigurePermsAction(plugin, pluginPath);
        boolean deflt = plugin != null && ManagementSecurityUtils.isManagementSecurityEnabled(plugin);
        cAction.setEnabled(deflt && allowsConfig);
        permsMenu.add(new JBasicMenuItem(cAction));
        ManagePermsAction mAction = new ManagePermsAction(plugin, pluginPath);
        mAction.setEnabled(deflt && allowsManage);
        permsMenu.add(new JBasicMenuItem(mAction));
        ret[0] = permsMenu;
        return ret;
    }

    public static String getErrorMessageFor(ManagementPermissionDeniedException e) {
        String requiredPerm;
        int bit;
        String dontHave = "You do not have permission to perform a '";
        String on = "' on ";
        String onCofig = "' on this configuration";
        String onTarget = "' on this target";
        if (e instanceof ConfigurePermissionDeniedException) {
            ConfigurePermissionDeniedException ce = (ConfigurePermissionDeniedException)((Object)e);
            String path = ce.getLogicalPath();
            bit = ce.getRequiredPermission();
            String string = requiredPerm = bit == 0 ? null : ConfigurePermissions.getPermissionName(bit).toLowerCase();
            if (path != null && requiredPerm != null) {
                return dontHave + requiredPerm + on + path;
            }
            if (path == null && requiredPerm != null) {
                return dontHave + requiredPerm + onCofig;
            }
        }
        if (e instanceof ManagePermissionDeniedException) {
            ManagePermissionDeniedException me = (ManagePermissionDeniedException)e;
            String target = me.getTarget();
            bit = me.getRequiredPermission();
            String string = requiredPerm = bit == 0 ? null : ManagePermissions.getPermissionName(bit).toLowerCase();
            if (target != null && requiredPerm != null) {
                if (requiredPerm.equals("Subscribe to notifications")) {
                    return "You do not have permission to listen to notifications from " + target;
                }
                return dontHave + requiredPerm + on + target;
            }
            if (target == null && requiredPerm != null) {
                return dontHave + requiredPerm + onTarget;
            }
        }
        return e.getMessage();
    }

    public static boolean isCausedByPermissionDenial(Exception e) {
        if (e instanceof ConfigServiceException) {
            return ManagementSecurityUtils.isCausedByPermissionDenial(((ConfigServiceException)((Object)e)).getLinkedException());
        }
        return e instanceof ManagementPermissionDeniedException;
    }

    public static class Readability {
        public static final Readability READABLE = new Readability(null, true, null);
        public final IPlugin plugin;
        public final boolean readable;
        public final String message;

        private Readability(IPlugin plugin, boolean readable, String denyMessage) {
            this.plugin = plugin;
            this.readable = readable;
            this.message = denyMessage;
        }
    }
}

