/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.perms;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.perms.AbstractPermissions;
import com.sonicsw.ma.gui.perms.ManagementSecurityUtils;
import com.sonicsw.ma.gui.perms.PermissionsList;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.PrincipalChooserDialog;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.gui.util.Utils;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigPath;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PermissionsDialog
extends JMADialog {
    private JList principalsList;
    private DefaultListModel listModel;
    private JButton addButton;
    private JButton deleteButton;
    private JComboBox scopesCombo;
    private JCheckBox[][] permissionChx;
    private static final String chkBoxBit = PermissionsDialog.class.getName() + ".checkBoxBit";
    private PermissionsList permsModel;
    private AbstractPermissions current;
    private boolean itsMe = false;
    private IPlugin plugin;
    private MyOKAction okAction = new MyOKAction();

    public PermissionsDialog(IPlugin plugin, PermissionsList perms, JMAFrame parent, String name) {
        super(parent, name);
        this.plugin = plugin;
        this.permsModel = perms;
    }

    @Override
    protected void maInitialize() {
        Container contentPane = this.getContentPane();
        JPanel topPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 11;
        topPanel.add((Component)this.makePrincipalsPanel(), gbc);
        ++gbc.gridy;
        topPanel.add((Component)this.makeScopesPanel(), gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        topPanel.add((Component)this.makePermsPanel(), gbc);
        contentPane.add(topPanel);
        this.listModel = new SortedListModel(this.permsModel.getPermissions(), new PrincipalsComparator());
        this.principalsList.setModel(this.listModel);
        this.scopesCombo.setModel(new DefaultComboBoxModel<PermissionsList.ScopeType>(this.permsModel.getAvailableScopeTypes()));
        if (!this.listModel.isEmpty()) {
            this.principalsList.setSelectedIndex(0);
        } else {
            this.renderDetails(this.current);
        }
        this.deleteButton.setEnabled(!this.listModel.isEmpty());
        this.okAction.setEnabled(false);
    }

    @Override
    protected void maCleanup() {
    }

    @Override
    public Action[] getButtonActions() {
        return new Action[]{this.okAction, this.getDefaultCancelAction()};
    }

    public PermissionsList getModel() {
        List<Object> list = Arrays.asList(this.listModel.toArray());
        this.permsModel.setPermissions(list);
        return this.permsModel;
    }

    private JPanel makePermsPanel() {
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.setBorder(BorderFactory.createTitledBorder("Permissions"));
        JLabel allow = new JLabel("Allow");
        Font font = topPanel.getFont();
        JLabel deny = new JLabel("Deny");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        topPanel.add((Component)new JLabel(), gbc);
        ++gbc.gridx;
        gbc.weightx = 0.01;
        topPanel.add((Component)allow, gbc);
        ++gbc.gridx;
        topPanel.add((Component)deny, gbc);
        PermissionsList.PermissionType[] permissionTypes = this.permsModel.getAvailablePermissionTypes();
        this.permissionChx = new JCheckBox[permissionTypes.length][2];
        ActionListener l = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (PermissionsDialog.this.itsMe) {
                    return;
                }
                PermissionsDialog.this.itsMe = true;
                try {
                    JCheckBox source = (JCheckBox)e.getSource();
                    if (source.isSelected()) {
                        PermissionsDialog.this.current.addPermissionBit((Integer)source.getClientProperty(chkBoxBit));
                    } else {
                        PermissionsDialog.this.current.removePermissionBit((Integer)source.getClientProperty(chkBoxBit));
                    }
                    PermissionsDialog.this.renderPerms(PermissionsDialog.this.current);
                    PermissionsDialog.this.modelChanged();
                }
                finally {
                    PermissionsDialog.this.itsMe = false;
                }
            }
        };
        for (int i = 0; i < permissionTypes.length; ++i) {
            ++gbc.gridy;
            String permissionName = permissionTypes[i].name;
            this.permissionChx[i][0] = new JCheckBox();
            this.permissionChx[i][0].putClientProperty(chkBoxBit, new Integer(permissionTypes[i].allowBit));
            this.permissionChx[i][0].addActionListener(l);
            this.permissionChx[i][1] = new JCheckBox();
            this.permissionChx[i][1].putClientProperty(chkBoxBit, new Integer(permissionTypes[i].denyBit));
            this.permissionChx[i][1].addActionListener(l);
            gbc.gridx = 0;
            topPanel.add((Component)new JLabel(permissionName), gbc);
            ++gbc.gridx;
            topPanel.add((Component)this.permissionChx[i][0], gbc);
            ++gbc.gridx;
            topPanel.add((Component)this.permissionChx[i][1], gbc);
        }
        return topPanel;
    }

    private JPartitionPanel makeScopesPanel() {
        JPartitionPanel topPanel = new JPartitionPanel(false, "p,r", null);
        this.scopesCombo = new JComboBox();
        this.scopesCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PermissionsDialog.this.itsMe) {
                    return;
                }
                PermissionsList.ScopeType selectedItem = (PermissionsList.ScopeType)PermissionsDialog.this.scopesCombo.getSelectedItem();
                PermissionsDialog.this.current.setScopeBits(selectedItem.getBits());
                PermissionsDialog.this.modelChanged();
            }
        });
        topPanel.addRow("Scope", (JComponent)this.scopesCombo);
        return topPanel;
    }

    private JPartitionPanel makePrincipalsPanel() {
        JPartitionPanel topPanel = new JPartitionPanel(false, "r", "Principals");
        this.principalsList = new JList();
        this.principalsList.setCellRenderer(new PrincipalCellRenderer());
        this.principalsList.setSelectionMode(0);
        this.principalsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (evt.getValueIsAdjusting()) {
                    return;
                }
                int index = PermissionsDialog.this.principalsList.getSelectedIndex();
                PermissionsDialog.this.current = index >= 0 ? (AbstractPermissions)PermissionsDialog.this.listModel.getElementAt(index) : null;
                PermissionsDialog.this.renderDetails(PermissionsDialog.this.current);
            }
        });
        ExtendedJScrollPane membersScroll = new ExtendedJScrollPane(this.principalsList);
        Dimension pref = this.principalsList.getPreferredScrollableViewportSize();
        membersScroll.setPreferredSize(pref);
        membersScroll.setMinimumSize(pref);
        this.addButton = new JButton("Add...");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Set domainUsers = Utils.getDomainUsers(ManagementSecurityUtils.getSecurityDomain(PermissionsDialog.this.plugin), PermissionsDialog.this.plugin.getPluginContext().getConfigContext().getConfigServer(), true);
                PermissionsDialog.this.removeExistingPrincipals(domainUsers, true);
                Object[] users = domainUsers.toArray();
                Set domainGrps = Utils.getDomainGroups(ManagementSecurityUtils.getSecurityDomain(PermissionsDialog.this.plugin), PermissionsDialog.this.plugin.getPluginContext().getConfigContext().getConfigServer(), true);
                PermissionsDialog.this.removeExistingPrincipals(domainGrps, false);
                Object[] groups = domainGrps.toArray();
                PrincipalChooserDialog dialog = new PrincipalChooserDialog(MgmtConsole.getMgmtConsole(), users, groups, false);
                dialog.setVisible(true);
                if (dialog.getCloseCommand() == 0) {
                    String principalName = dialog.getSelectedItem();
                    boolean isUser = dialog.getSelectedItemWithPrefix().startsWith("^@_");
                    AbstractPermissions newPerms = PermissionsDialog.this.permsModel.newPermissions(new AbstractPermissions.Principal(principalName, isUser));
                    newPerms.setScopeBits(PermissionsDialog.this.permsModel.getAvailableScopeTypes()[0].getBits());
                    PermissionsDialog.this.listModel.addElement(newPerms);
                    PermissionsDialog.this.principalsList.setSelectedIndex(PermissionsDialog.this.listModel.indexOf(newPerms));
                    PermissionsDialog.this.deleteButton.setEnabled(true);
                    PermissionsDialog.this.modelChanged();
                }
            }
        });
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = PermissionsDialog.this.principalsList.getSelectedIndex();
                if (index > -1 && index < PermissionsDialog.this.listModel.getSize()) {
                    PermissionsDialog.this.listModel.remove(index);
                    PermissionsDialog.this.modelChanged();
                }
                if (PermissionsDialog.this.listModel.getSize() > 0) {
                    PermissionsDialog.this.principalsList.setSelectedIndex(Math.max(0, index - 1));
                } else {
                    PermissionsDialog.this.current = null;
                    PermissionsDialog.this.renderDetails(PermissionsDialog.this.current);
                    PermissionsDialog.this.deleteButton.setEnabled(false);
                }
            }
        });
        JPartitionPanel buttonsPanel = JPartitionPanel.merge("p,p,r", true, 5, 0, 0, new JComponent[]{this.addButton, this.deleteButton});
        JPartitionPanel membersPanel = JPartitionPanel.merge("r,p", false, new JComponent[]{membersScroll, buttonsPanel});
        topPanel.add(membersPanel);
        return topPanel;
    }

    private void renderDetails(AbstractPermissions selexn) {
        this.renderScope(selexn);
        this.renderPerms(selexn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderPerms(AbstractPermissions selexn) {
        int permissionsBits = selexn == null ? 0 : selexn.getPermissionsBits();
        this.itsMe = true;
        try {
            for (int i = 0; i < this.permissionChx.length; ++i) {
                JCheckBox[] jCheckBoxes = this.permissionChx[i];
                int allowBit = (Integer)jCheckBoxes[0].getClientProperty(chkBoxBit);
                jCheckBoxes[0].setSelected((allowBit & permissionsBits) == allowBit);
                jCheckBoxes[0].setEnabled(selexn != null);
                int denyBit = (Integer)jCheckBoxes[1].getClientProperty(chkBoxBit);
                jCheckBoxes[1].setSelected((denyBit & permissionsBits) == denyBit);
                jCheckBoxes[1].setEnabled(selexn != null);
            }
        }
        finally {
            this.itsMe = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void renderScope(AbstractPermissions selexn) {
        int scopeBits = selexn == null ? 0 : selexn.getScopeBits();
        PermissionsList.ScopeType[] availableScopeTypes = this.permsModel.getAvailableScopeTypes();
        this.itsMe = true;
        try {
            if (selexn != null) {
                for (int i = 0; i < availableScopeTypes.length; ++i) {
                    PermissionsList.ScopeType scopeType = availableScopeTypes[i];
                    if (scopeType.getBits() != scopeBits) continue;
                    this.scopesCombo.setSelectedIndex(i);
                    this.scopesCombo.setEnabled(selexn != null);
                    this.itsMe = false;
                    return;
                }
            }
            this.scopesCombo.setSelectedIndex(-1);
            this.scopesCombo.setEnabled(selexn != null);
            this.itsMe = false;
            return;
        }
        catch (Throwable throwable) {
            this.scopesCombo.setEnabled(selexn != null);
            this.itsMe = false;
            throw throwable;
        }
    }

    private void modelChanged() {
        this.okAction.setEnabled(true);
    }

    @Override
    protected boolean canClose() {
        int res = 0;
        if (this.okAction.isEnabled()) {
            res = JOptionPane.showConfirmDialog(this, "There are unapplied changes.\nAre you sure you want to cancel?", "Confirm Cancel", 0, 2);
        }
        return res == 0;
    }

    private void removeExistingPrincipals(Set allPrincipals, boolean forUsers) {
        Iterator iterator = allPrincipals.iterator();
        while (iterator.hasNext()) {
            IConfigBean bean = (IConfigBean)iterator.next();
            IConfigPath attributeName = forUsers ? PrincipalChooserDialog.USER_NAME : PrincipalChooserDialog.GROUP_NAME;
            String name = (String)bean.getAttribute(attributeName);
            Enumeration enumeration = this.listModel.elements();
            while (enumeration.hasMoreElements()) {
                AbstractPermissions.Principal principal = ((AbstractPermissions)enumeration.nextElement()).getPrincipal();
                if (!principal.getName().equals(name)) continue;
                iterator.remove();
            }
        }
    }

    public class MyOKAction
    extends BasicGuiAction {
        public MyOKAction() {
            super("dialog.ok");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Enumeration enumeration = PermissionsDialog.this.listModel.elements();
            while (enumeration.hasMoreElements()) {
                AbstractPermissions perms = (AbstractPermissions)enumeration.nextElement();
                if (perms.getPermissionsBits() != 0) continue;
                JOptionPane.showMessageDialog(PermissionsDialog.this, "No permissions have been set for " + perms.getPrincipal().getName(), "Invalid permissions", 2);
                return;
            }
            PermissionsDialog.this.getDefaultOKAction().actionPerformed(evt);
        }
    }

    public class PrincipalsComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            AbstractPermissions p1 = (AbstractPermissions)o1;
            AbstractPermissions p2 = (AbstractPermissions)o2;
            return p1.getPrincipal().getName().compareToIgnoreCase(p2.getPrincipal().getName());
        }
    }

    private class SortedListModel
    extends DefaultListModel {
        private Comparator comparator;

        public SortedListModel(List list) {
            this(list, null);
        }

        public SortedListModel(List list, Comparator comparator) {
            this.comparator = comparator;
            if (comparator == null) {
                Collections.sort(list);
            } else {
                Collections.sort(list, comparator);
            }
            this.addElements(list);
        }

        private void addElements(List list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                super.addElement(iterator.next());
            }
        }

        public void addElement(Object obj) {
            Object[] objects = super.toArray();
            int index = this.comparator == null ? Arrays.binarySearch(objects, obj) : Arrays.binarySearch(objects, obj, this.comparator);
            super.insertElementAt(obj, index < 0 ? -index - 1 : index);
        }
    }

    class PrincipalCellRenderer
    extends DefaultListCellRenderer {
        PrincipalCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel res = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            AbstractPermissions perms = (AbstractPermissions)value;
            try {
                AbstractPermissions.Principal principal = perms.getPrincipal();
                if (principal.isUser()) {
                    res.setIcon(ResourceManager.getIcon(this.getClass(), "type/AUTHENTICATION_USER"));
                }
                if (principal.isGroup()) {
                    res.setIcon(ResourceManager.getIcon(this.getClass(), "type/AUTHENTICATION_GROUP"));
                }
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            }
            return res;
        }
    }
}

