/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.perms;

import com.sonicsw.ma.gui.perms.AbstractPermissions;
import com.sonicsw.ma.gui.perms.ConfigurePermissions;
import com.sonicsw.ma.gui.perms.ManagePermissions;
import com.sonicsw.ma.gui.perms.ManagementSecurityUtils;
import com.sonicsw.ma.plugin.IPlugin;
import java.util.ArrayList;
import java.util.List;

public abstract class PermissionsList {
    protected List perms;
    protected IPlugin subject;

    public PermissionsList(ArrayList perms, IPlugin subject) {
        this.subject = subject;
        this.perms = perms;
    }

    public List getPermissions() {
        return this.perms;
    }

    public void setPermissions(List perms) {
        this.perms = perms;
    }

    public abstract ScopeType[] getAvailableScopeTypes();

    public abstract PermissionType[] getAvailablePermissionTypes();

    public abstract AbstractPermissions newPermissions(AbstractPermissions.Principal var1);

    public static class ManagePermissionsList
    extends PermissionsList {
        public ManagePermissionsList(IPlugin subject) {
            this(new ArrayList(), subject);
        }

        public ManagePermissionsList(ArrayList perms, IPlugin subject) {
            super(perms, subject);
        }

        @Override
        public ScopeType[] getAvailableScopeTypes() {
            if (ManagementSecurityUtils.isFolder(this.subject)) {
                return ManagePermissions.folderScopeTypes;
            }
            if ("MF_CONTAINER".equals(this.subject.getAttributes().getType())) {
                return ManagePermissions.containerScopeTypes;
            }
            return ManagePermissions.componentScopeTypes;
        }

        @Override
        public PermissionType[] getAvailablePermissionTypes() {
            return ManagePermissions.permissionTypes;
        }

        @Override
        public AbstractPermissions newPermissions(AbstractPermissions.Principal principal) {
            return new ManagePermissions(principal);
        }
    }

    public static class ConfigurePermissionsList
    extends PermissionsList {
        public ConfigurePermissionsList(IPlugin subject) {
            this(new ArrayList(), subject);
        }

        public ConfigurePermissionsList(ArrayList perms, IPlugin subject) {
            super(perms, subject);
        }

        @Override
        public ScopeType[] getAvailableScopeTypes() {
            if (ManagementSecurityUtils.isFolder(this.subject)) {
                return ConfigurePermissions.folderScopeTypes;
            }
            return ConfigurePermissions.fileOrConfigScopeTypes;
        }

        @Override
        public PermissionType[] getAvailablePermissionTypes() {
            return ConfigurePermissions.permissionTypes;
        }

        @Override
        public AbstractPermissions newPermissions(AbstractPermissions.Principal principal) {
            return new ConfigurePermissions(principal);
        }
    }

    public static class PermissionType {
        public final String name;
        public final int allowBit;
        public final int denyBit;

        public PermissionType(String name, int allowBit, int denyBit) {
            this.name = name;
            this.allowBit = allowBit;
            this.denyBit = denyBit;
        }
    }

    public static class ScopeType {
        private String displayName;
        private int bits;

        public ScopeType(String displayName, int bits) {
            this.displayName = displayName;
            this.bits = bits;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public int getBits() {
            return this.bits;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

