/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.plaf;

import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;

public class EditTextFieldUI
extends BasicTextFieldUI {
    private MouseListener listener = null;

    public static ComponentUI createUI(JComponent c) {
        return new EditTextFieldUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.listener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                this.mouseReleased(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    JPopupMenu menu = new JPopupMenu();
                    menu.add(new JBasicMenuItem(new EditCutAction()));
                    menu.add(new JBasicMenuItem(new EditCopyAction()));
                    menu.add(new JBasicMenuItem(new EditPasteAction()));
                    menu.show((JComponent)evt.getSource(), evt.getX(), evt.getY());
                }
            }
        };
        c.addMouseListener(this.listener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        if (this.listener != null) {
            c.removeMouseListener(this.listener);
        }
    }

    class EditPasteAction
    extends BasicGuiAction {
        public EditPasteAction() {
            super("edit.paste");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            EditTextFieldUI.this.getComponent().paste();
        }

        @Override
        public boolean isEnabled() {
            return EditTextFieldUI.this.getComponent().isEnabled() && EditTextFieldUI.this.getComponent().isEditable();
        }
    }

    class EditCutAction
    extends BasicGuiAction {
        public EditCutAction() {
            super("edit.cut");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            EditTextFieldUI.this.getComponent().cut();
        }

        @Override
        public boolean isEnabled() {
            String sel = EditTextFieldUI.this.getComponent().getSelectedText();
            return sel != null && sel.trim().length() > 0;
        }
    }

    class EditCopyAction
    extends BasicGuiAction {
        public EditCopyAction() {
            super("edit.copy");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            EditTextFieldUI.this.getComponent().copy();
        }

        @Override
        public boolean isEnabled() {
            String sel = EditTextFieldUI.this.getComponent().getSelectedText();
            return sel != null && sel.trim().length() > 0;
        }
    }
}

