/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.propsheets;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.config.DSFileChooser;
import com.sonicsw.ma.gui.config.FileElementFilter;
import com.sonicsw.ma.gui.config.propsheets.JConfigDialog;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.JRowTableAspectAdapter;
import com.sonicsw.ma.gui.table.ModelListTableModel;
import com.sonicsw.ma.gui.table.RowTableColumn;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.JPathField;
import com.sonicsw.ma.gui.util.JRowTable;
import com.sonicsw.ma.gui.util.JRowTableButtonPanel;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.IPluginFilter;
import com.sonicsw.mx.config.ConfigFactory;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.IConfigServer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumn;
import modelobjects.framework.EditRule;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.util.ObjectCopier;

public class ClasspathPanel
extends JPanel {
    public static final IConfigPath CLASSPATH = ConfigFactory.createConfigPath((String)"CLASSPATH");
    private static final String TOKEN = ";";
    private static final String SONICFS_URL_PREFIX = "sonicfs:///";
    protected JConfigDialog m_configParent;
    protected JRowTable m_classpathTable;

    public ClasspathPanel(JConfigDialog parent) {
        super(new BorderLayout(5, 5));
        this.setBorder();
        this.m_configParent = parent;
    }

    private void setBorder() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private ModelEditMediator getMediator() {
        return this.m_configParent.getEditForm().getModelEditMediator();
    }

    public void initUI() {
        this.add((Component)this.makeClasspathTable(), "Center");
        this.add((Component)this.makeClasspathButtons(), "East");
    }

    public void initForm() {
        new FormattedStringTableAspectAdapter(this.m_configParent.getModelAspectId(CLASSPATH), this.m_classpathTable, EditRule.ALWAYS, this.getMediator());
    }

    private JPanel makeClasspathButtons() {
        ClasspathButtonPanel panel = new ClasspathButtonPanel(this.m_classpathTable);
        panel.setAddAction(new AddAction());
        panel.setEditAction(new EditAction());
        panel.setRemoveAction(new RemoveAction(panel.getRemoveAction()));
        panel.addRemainder();
        panel.addButton(new MoveUpAction());
        panel.addButton(new MoveDownAction());
        panel.updateState(null);
        return panel;
    }

    private JComponent makeClasspathTable() {
        TableColumn[] COLUMNS = new RowTableColumn[]{new RowTableColumn(0, "Classpath", 100)};
        COLUMNS[0].setSortable(false);
        this.m_classpathTable = new JRowTable(COLUMNS, this.getClass().getName());
        return new ExtendedJScrollPane(this.m_classpathTable);
    }

    class FormattedStringTableAspectAdapter
    extends JRowTableAspectAdapter
    implements ObjectCopier {
        public FormattedStringTableAspectAdapter(ModelAspectId modelAspectId, JRowTable table, EditRule editRule, ModelEditMediator modelEditMediator) {
            super(modelAspectId, table, null, editRule, modelEditMediator);
            this.rowModelCopier = this;
        }

        @Override
        protected void setViewAspectValue(Object viewAspectValue) throws IllegalArgumentException {
            if (viewAspectValue == null) {
                return;
            }
            if (!(viewAspectValue instanceof String)) {
                throw new IllegalArgumentException("The view aspect value must be of type String!");
            }
            try {
                String value = (String)viewAspectValue;
                StringTokenizer tn = new StringTokenizer(value, ClasspathPanel.TOKEN);
                ArrayList<String> contents = new ArrayList<String>();
                while (tn.hasMoreTokens()) {
                    String path = tn.nextToken();
                    if (path == null) continue;
                    contents.add(path);
                }
                super.setViewAspectValue(contents);
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to build classpath view", e, true);
            }
        }

        @Override
        public Object getViewAspectValue() {
            StringBuffer buffer = new StringBuffer();
            try {
                Iterator i = ((IModelTableModel)this.table.getModel()).getContents().iterator();
                while (i.hasNext()) {
                    buffer.append((String)i.next());
                    if (!i.hasNext()) continue;
                    buffer.append(ClasspathPanel.TOKEN);
                }
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to build classpath view", e, true);
            }
            return buffer.toString();
        }

        @Override
        public Object copyObject(Object obj) {
            return obj;
        }
    }

    class MoveDownAction
    extends BasicGuiAction {
        public MoveDownAction() {
            super("editable_component.movedown");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                IModelTableModel model = (IModelTableModel)ClasspathPanel.this.m_classpathTable.getModel();
                int[] selRow = ClasspathPanel.this.m_classpathTable.getSelectedRows();
                if (selRow != null && selRow.length > 0 && selRow[selRow.length - 1] < model.getRowCount() - 1) {
                    String value = (String)model.getRowModel(selRow[selRow.length - 1] + 1);
                    model.deleteRow(selRow[selRow.length - 1] + 1);
                    int newSel = selRow[0];
                    model.insertRow(value, newSel);
                    ClasspathPanel.this.m_classpathTable.setRowSelectionInterval(selRow[0] + 1, selRow[selRow.length - 1] + 1);
                }
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Unable to modify classpath order.", e, true);
            }
        }
    }

    class MoveUpAction
    extends BasicGuiAction {
        public MoveUpAction() {
            super("editable_component.moveup");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                IModelTableModel model = (IModelTableModel)ClasspathPanel.this.m_classpathTable.getModel();
                int[] selRow = ClasspathPanel.this.m_classpathTable.getSelectedRows();
                if (selRow != null && selRow.length > 0 && selRow[0] > 0) {
                    String value = (String)model.getRowModel(selRow[0] - 1);
                    model.deleteRow(selRow[0] - 1);
                    model.insertRow(value, selRow[selRow.length - 1]);
                    ClasspathPanel.this.m_classpathTable.setRowSelectionInterval(selRow[0] - 1, selRow[0] - 1);
                }
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Unable to modify classpath order.", e, true);
            }
        }
    }

    class ClasspathButtonPanel
    extends JRowTableButtonPanel {
        public ClasspathButtonPanel(JRowTable table) {
            super(table, 5, 0, 0);
        }

        @Override
        protected void updateState(ListSelectionModel selModel) {
            int selCount;
            super.updateState(selModel);
            int n = selCount = selModel != null ? this.getSelectedRowCount(selModel) : 0;
            if (this.getMoveUpAction() != null) {
                this.getMoveUpAction().setEnabled(selCount == 1 && selModel != null && selModel.getMinSelectionIndex() > 0);
            }
            if (this.getMoveDownAction() != null) {
                this.getMoveDownAction().setEnabled(selCount == 1 && selModel != null && selModel.getMaxSelectionIndex() < this.getTable().getRowCount() - 1);
            }
        }

        private Action getMoveUpAction() {
            return this.getAction("editable_component.moveup") != null ? this.getAction("editable_component.moveup") : null;
        }

        private Action getMoveDownAction() {
            return this.getButton("editable_component.movedown") != null ? this.getButton("editable_component.movedown").getAction() : null;
        }
    }

    class AddClassPathDialog
    extends JMADialog {
        JPathField m_classpath;
        Action m_okAction;
        IPlugin m_plugin;
        boolean m_multiSelect;

        public AddClassPathDialog(JMADialog parent, String resource, boolean multiSelect) {
            super(parent, resource);
            this.m_classpath = new JPathField(32);
            this.m_plugin = null;
            this.m_plugin = ClasspathPanel.this.m_configParent.getPlugin();
            this.setResizableProperty();
            this.m_okAction = this.createOKAction();
            this.m_multiSelect = multiSelect;
        }

        private void setResizableProperty() {
            this.setResizable(true);
        }

        private OKAction createOKAction() {
            return new OKAction((Action)this.getDefaultOKAction());
        }

        @Override
        public void maInitialize() {
            this.getContentPane().add(this.makeMainPanel());
            this.m_classpath.setButtonAction(new ClasspathAction(this.m_multiSelect));
        }

        @Override
        public void maCleanup() {
        }

        private JPanel makeMainPanel() {
            JPartitionPanel topPanel = new JPartitionPanel(true, "p", null);
            this.getContentPane().add((Component)topPanel, "Center");
            JPartitionPanel pathPanel = new JPartitionPanel(false, "p,r", "", 5, 0, 0);
            topPanel.add(pathPanel);
            pathPanel.addRow(ResourceManager.getString(this.getClass(), "dialog.classpath.path.label"), (JComponent)this.m_classpath);
            return topPanel;
        }

        public String getPath() {
            return this.m_classpath.getText();
        }

        public void setPath(String path) {
            this.m_classpath.setText(path);
        }

        @Override
        public Action[] getButtonActions() {
            ArrayList<Action> list = new ArrayList<Action>();
            list.add(this.m_okAction);
            list.add(this.getDefaultCancelAction());
            return list.toArray(new Action[list.size()]);
        }

        class ClasspathAction
        extends BasicGuiAction {
            String selectedFilter;
            String[] m_filters;
            boolean m_multiSelect;

            ClasspathAction(boolean multiSelect) {
                super("archive.browse");
                this.selectedFilter = "*.jar, *.war, *.zip";
                this.m_filters = new String[]{this.selectedFilter, "*.*"};
                this.m_multiSelect = multiSelect;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileElementFilter filter = new FileElementFilter();
                filter.setSelectedFilter(this.selectedFilter);
                IConfigServer server = null;
                IPluginContext context = null;
                if (AddClassPathDialog.this.m_plugin != null) {
                    server = AddClassPathDialog.this.m_plugin.getPluginContext().getConfigContext().getConfigServer();
                    context = AddClassPathDialog.this.m_plugin.getPluginContext();
                } else {
                    server = MgmtConsole.getMgmtConsole().getPluginContext().getConfigContext().getConfigServer();
                    context = MgmtConsole.getMgmtConsole().getPluginContext();
                }
                DSFileChooser dialog = new DSFileChooser(ClasspathPanel.this.m_configParent, "classpath.choose", context, server, (IPluginFilter)filter, this.m_filters, this.m_multiSelect);
                try {
                    HashMap selList;
                    dialog.editInstance(AddClassPathDialog.this.m_plugin, new HashMap(), false);
                    dialog.setVisible(true);
                    if (dialog.getCloseCommand() == 0 && (selList = (HashMap)dialog.getModel()) != null && !selList.isEmpty()) {
                        StringBuffer sb = new StringBuffer();
                        for (String path : selList.keySet()) {
                            if (path.startsWith("/")) {
                                path = path.substring(1);
                            }
                            if (sb.length() > 0) {
                                sb.append("; ");
                            }
                            sb.append(ClasspathPanel.SONICFS_URL_PREFIX + path);
                        }
                        AddClassPathDialog.this.m_classpath.setText(sb.toString());
                    }
                }
                catch (Exception e) {
                    MgmtConsole.displayMessage(4, "Error specifying classpath.", e, true);
                }
            }
        }

        class OKAction
        extends BasicGuiAction {
            public OKAction(Action target) {
                super("dialog.ok", target);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (AddClassPathDialog.this.getPath().length() == 0) {
                    MgmtConsole.getMgmtConsole().notifyMessage(4, "Path can't be empty", true);
                    return;
                }
                super.actionPerformed(evt);
            }
        }
    }

    class RemoveAction
    extends BasicGuiAction {
        public RemoveAction(Action target) {
            super("editable_component.remove", target);
        }
    }

    class EditAction
    extends BasicGuiAction {
        public EditAction() {
            super("editable_component.edit");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String path;
            IModelTableModel model = (IModelTableModel)ClasspathPanel.this.m_classpathTable.getModel();
            int sel = ClasspathPanel.this.m_classpathTable.getSelectedRow();
            String rowModel = (String)model.getRowModel(sel);
            AddClassPathDialog dialog = new AddClassPathDialog(ClasspathPanel.this.m_configParent, "classpath.edit", false);
            dialog.setPath(rowModel);
            dialog.setVisible(true);
            if (dialog.getCloseCommand() == 0 && (path = dialog.getPath()).length() > 0 && !rowModel.equals(path)) {
                int match = model.findCell(0, 0, path);
                if (match != -1 && match != sel) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    model.getContents().set(sel, path);
                    ((ModelListTableModel)model).fireTableRowsUpdated(sel, sel);
                }
            }
        }
    }

    class AddAction
    extends BasicGuiAction {
        public AddAction() {
            super("editable_component.add");
        }

        private String[] splitPath(String path) {
            StringTokenizer st = new StringTokenizer(path, ClasspathPanel.TOKEN);
            ArrayList<String> res = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                res.add(st.nextToken().trim());
            }
            return res.toArray(new String[0]);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AddClassPathDialog dialog = new AddClassPathDialog(ClasspathPanel.this.m_configParent, "classpath.add", true);
            dialog.setVisible(true);
            if (dialog.getCloseCommand() == 0) {
                int found;
                String[] path = this.splitPath(dialog.getPath());
                IModelTableModel model = (IModelTableModel)ClasspathPanel.this.m_classpathTable.getModel();
                for (int i = 0; i < path.length; ++i) {
                    found = model.findCell(0, 0, path[i]);
                    if (path[i].length() <= 0 || found != -1) continue;
                    model.insertRow(path[i], ClasspathPanel.this.m_classpathTable.getRowCount());
                }
                for (int j = 0; j < path.length; ++j) {
                    found = model.findCell(0, 0, path[j]);
                    if (found == -1) continue;
                    ClasspathPanel.this.m_classpathTable.getSelectionModel().addSelectionInterval(found, found);
                }
            }
        }
    }
}

