/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.propsheets;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.propsheets.PropSheetModelDescriptor;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import modelobjects.framework.EditForm;
import modelobjects.framework.ModelEditFailureEvent;
import modelobjects.framework.ModelEditFailureListener;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.ViewAspectAdapter;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.ViewValueConverter;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.model.ModelDescriptor;
import modelobjects.framework.model.ModelObjectAdapter;
import modelobjects.framework.model.ModelObjectPropagator;
import modelobjects.framework.model.ModelObjectValidator;
import modelobjects.framework.model.ModelValidationException;
import modelobjects.framework.model.NoSuchAspectException;
import modelobjects.util.WrapperException;

public abstract class JPropSheetDialog
extends JMADialog
implements ModelEditFailureListener {
    public static final String CHANGES = "There are unapplied changes.\nAre you sure you want to cancel?";
    public static final String CHANGES_TITLE = "Confirm Cancel";
    public static final String SILENT_VALIDATION_EXCEPTION = "silentValidationException";
    private Class m_modelClass;
    private EditForm m_editForm;
    private JPanel m_contentPanel;
    private IPlugin m_plugin;
    private boolean m_formInit = false;
    private boolean m_modelSet = false;
    private Object m_tmpModel = null;
    private boolean m_tmpNew = false;
    private BasicAction m_psOK = null;

    public JPropSheetDialog(JMADialog parent, String name, Class modelClass) {
        super(parent, name);
        this.m_modelClass = modelClass;
        this.initPropSheet();
    }

    public JPropSheetDialog(JMAFrame parent, String name, Class modelClass) {
        super(parent, name);
        this.m_modelClass = modelClass;
        this.initPropSheet();
    }

    private void initPropSheet() {
        this.setModal(true);
        try {
            ModelDescriptor descriptor = this.makeModelDescriptor();
            ModelEditMediator mediator = new ModelEditMediator();
            this.m_editForm = new EditForm(descriptor, this, mediator);
            this.m_editForm.addModelEditFailureListener(this);
        }
        catch (Exception e) {
            MgmtConsole.displayMessage(4, "Error while initializing the property sheet.", e, true);
        }
    }

    @Override
    protected void internalInitialize() {
        super.internalInitialize();
        this.m_contentPanel = new JPanel(new BorderLayout(2, 2));
        super.getContentPane().add(this.m_contentPanel);
    }

    protected ModelDescriptor makeModelDescriptor() throws Exception {
        return new PropSheetModelDescriptor(this.m_modelClass);
    }

    @Override
    public Container getContentPane() {
        return this.m_contentPanel;
    }

    public Class getModelClass() {
        return this.m_modelClass;
    }

    public EditForm getEditForm() {
        return this.m_editForm;
    }

    public IPlugin getPlugin() {
        return this.m_plugin;
    }

    public IPluginContext getPluginContext() {
        return this.m_plugin != null ? this.m_plugin.getPluginContext() : null;
    }

    public Object getModel() {
        Object res = this.m_tmpModel;
        try {
            ModelObjectAdapter modelObjectAdapter = this.m_editForm.getModel();
            if (modelObjectAdapter != null) {
                res = modelObjectAdapter.getModelObject();
            }
        }
        catch (NullPointerException e) {
            res = this.m_tmpModel;
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        return res;
    }

    public boolean isNew() {
        boolean res = this.m_tmpNew;
        try {
            this.m_editForm.getModel().getModelObject();
            ModelEditMediator mediator = this.m_editForm.getModelEditMediator();
            res = mediator.getEditModelAsNewObject();
        }
        catch (NullPointerException e) {
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        return res;
    }

    public void editInstance(IPlugin plugin, Object model, boolean isNew) throws Exception {
        this.m_plugin = plugin;
        if (this.m_formInit) {
            this.editModel(model, isNew);
        } else {
            this.m_tmpModel = model;
            this.m_tmpNew = isNew;
        }
    }

    protected void editModel(Object model, boolean isNew) throws Exception {
        ModelDescriptor descriptor = this.getDescriptor();
        ModelObjectAdapter adapter = null;
        if (model != null) {
            adapter = descriptor.makeModelObjectAdapter(model);
        }
        if (isNew) {
            this.m_editForm.editModelAsNewObject(adapter);
        } else {
            this.m_editForm.editModelObject(adapter);
        }
        this.m_modelSet = true;
    }

    public ModelObjectValidator getValidator() {
        Iterator i = this.getDescriptor().getModelObjectValidators();
        return i.hasNext() ? (ModelObjectValidator)i.next() : null;
    }

    public final void setValidator(ModelObjectValidator validator) {
        Iterator i = this.getDescriptor().getModelObjectValidators();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
        this.getDescriptor().addModelObjectValidator(validator);
    }

    public ModelObjectPropagator getPropagator() {
        return this.getDescriptor().getModelObjectPropagator();
    }

    public final void setPropagator(ModelObjectPropagator propagator) {
        this.getDescriptor().setModelObjectPropagator(propagator);
    }

    protected ModelDescriptor getDescriptor() {
        return this.getEditForm().getModelDescriptor();
    }

    protected ModelEditMediator getMediator() {
        return this.getEditForm().getModelEditMediator();
    }

    @Override
    protected boolean canClose() {
        int res = 0;
        if (this.getMediator().hasUnappliedChanges()) {
            res = JOptionPane.showConfirmDialog(this, CHANGES, CHANGES_TITLE, 0, 2);
        }
        return res == 0;
    }

    protected abstract void initUI() throws Exception;

    protected abstract void initForm() throws Exception;

    @Override
    protected void maInitialize() {
        try {
            this.initUI();
            this.initForm();
            this.m_formInit = true;
            if (!this.m_modelSet) {
                this.editModel(this.m_tmpModel, this.m_tmpNew);
                this.m_tmpModel = null;
                this.m_tmpNew = false;
            }
        }
        catch (NoSuchAspectException e) {
            MgmtConsole.displayMessage(4, "Error initializing the property sheet. Aspect not found.", e, true);
        }
        catch (Exception e) {
            MgmtConsole.displayMessage(4, "Error initializing the property sheet.", e, true);
        }
    }

    @Override
    protected void maCleanup() {
        this.m_modelClass = null;
        this.m_contentPanel = null;
        this.m_plugin = null;
        this.m_tmpModel = null;
    }

    @Override
    public void modelEditFailed(ModelEditFailureEvent evt) {
        WrapperException e;
        String msg = this.getModelEditFailureMessage(evt.getException());
        JComponent c = null;
        if (evt.getException() instanceof ViewValueConversionException) {
            e = (ViewValueConversionException)evt.getException();
            ViewAspectAdapter adapter = this.getMediator().getViewAspectAdapter(((ViewValueConversionException)e).getModelAspectId());
            c = (JComponent)adapter.getViewComponent();
        } else if (evt.getException() instanceof ModelValidationException) {
            e = (ModelValidationException)evt.getException();
            Exception nested = (Exception)e.getNestedException();
            if (e.getMessage() != null && e.getMessage().equals(SILENT_VALIDATION_EXCEPTION)) {
                return;
            }
            if (nested instanceof IllegalArgumentException) {
                IllegalArgumentException iae = (IllegalArgumentException)nested;
                ViewAspectAdapter adapter = this.getMediator().getViewAspectAdapter(ModelAspectId.forName(iae.getMessage()));
                if (adapter != null) {
                    c = (JComponent)adapter.getViewComponent();
                }
            }
        }
        if (c != null) {
            Container container;
            JTabbedPane tab = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, c);
            if (tab != null && (container = this.findTabContainer(c, tab)) != null) {
                tab.setSelectedComponent(container);
            }
            c.requestFocus();
            if (c instanceof JTextComponent) {
                JTextComponent tc = (JTextComponent)c;
                if (tc.getText().length() > 0) {
                    tc.select(0, tc.getText().length());
                } else {
                    tc.setCaretPosition(0);
                }
            }
        }
        if (msg == null) {
            msg = evt.getException().getMessage();
        }
        MgmtConsole.getMgmtConsole().notifyMessage(this, 3, msg, evt.getException(), true);
    }

    public Container findTabContainer(Container c, JTabbedPane tab) {
        Container res;
        Container old = c;
        for (res = c.getParent(); res != null && !(res instanceof JTabbedPane); res = res.getParent()) {
            old = res;
        }
        if (res == null || res.getParent() == null) {
            old = null;
        }
        return old;
    }

    private String mangleClassName(Class modelClass) {
        String modelName = modelClass.getName();
        modelName = modelName.substring(modelName.lastIndexOf(46) + 1);
        modelName = modelName.toLowerCase();
        return modelName;
    }

    private String buildOptionList(String[] options) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < options.length; ++i) {
            sb.append(options[i]).append("\n");
        }
        return sb.toString();
    }

    protected String postProcessViewValueMessage(ViewValueConversionException e, Class modelClass, String msg) {
        StringTokenizer st = new StringTokenizer(msg, "|");
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken()).append("\n");
        }
        return sb.toString();
    }

    protected String getModelEditFailureMessage(Throwable throwable) {
        ModelValidationException e;
        Exception nested;
        String msg = null;
        if (throwable instanceof ViewValueConversionException) {
            ViewValueConversionException e2 = (ViewValueConversionException)throwable;
            ViewAspectAdapter adapter = this.getMediator().getViewAspectAdapter(e2.getModelAspectId());
            ViewValueConverter vvc = adapter.getViewValueConverter();
            String[] options = vvc.getViewStringValues();
            if (options == null) {
                Object[] args = new Object[]{adapter.getViewAspectStringValue()};
                String msgResId = "failure.message." + vvc.getModelClass().getName().toLowerCase();
                String resource = ResourceManager.getMessage(this.getClass(), msgResId, args);
                msg = resource != null ? this.postProcessViewValueMessage(e2, vvc.getModelClass(), resource) : ResourceManager.getMessage(this.getClass(), "failure.message.view.options.1", args);
            } else {
                String part1 = ResourceManager.getString(this.getClass(), "failure.message.view.options.1");
                String part2 = ResourceManager.getString(this.getClass(), "failure.message.view.options.2");
                msg = part1 + "\n\r" + part2 + "\n\r" + this.buildOptionList(options);
            }
        } else if (throwable instanceof ModelValidationException && (nested = (Exception)(e = (ModelValidationException)throwable).getNestedException()) instanceof IllegalArgumentException) {
            IllegalArgumentException iae = (IllegalArgumentException)nested;
            ViewAspectAdapter adapter = this.getMediator().getViewAspectAdapter(ModelAspectId.forName(iae.getMessage()));
            if (iae.getCause() != null) {
                msg = iae.getCause().getMessage();
            }
        }
        return msg;
    }

    @Override
    public Action[] getButtonActions() {
        ArrayList<BasicAction> list = new ArrayList<BasicAction>();
        list.add(this.getDefaultOKAction());
        list.add(this.getDefaultCancelAction());
        if (this.getHelpId() != null) {
            list.add(this.getDefaultHelpAction());
        }
        return list.toArray(new Action[list.size()]);
    }

    @Override
    public BasicAction getDefaultOKAction() {
        if (this.m_psOK == null) {
            this.m_psOK = new OkAction(this.getMediator().getApplyAction());
        }
        return this.m_psOK;
    }

    class OkAction
    extends BasicGuiAction {
        public OkAction(Action targetAction) {
            super("dialog.ok", targetAction);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            super.actionPerformed(evt);
            Component source = (Component)evt.getSource();
            JPropSheetDialog dialog = (JPropSheetDialog)SwingUtilities.getAncestorOfClass(JDialog.class, source);
            if (!dialog.getMediator().hasUnappliedChanges()) {
                dialog.m_closeCommand = 0;
                dialog.dispose();
            }
        }
    }
}

