/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.propsheets;

import com.sonicsw.ma.gui.config.propsheets.JConfigDialog;
import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigPath;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.ViewValueConverter;

public class RefToStringFromAnotherFieldConverter
implements ViewValueConverter {
    private IConfigPath m_path;
    private JConfigDialog m_sheet;
    private IPluginContext m_context;

    public RefToStringFromAnotherFieldConverter() {
    }

    public RefToStringFromAnotherFieldConverter(JConfigDialog sheet, IConfigPath path) {
        this.m_path = path;
        this.m_sheet = sheet;
    }

    public void setConfigContext(IPluginContext context) {
        this.m_context = context;
    }

    @Override
    public Object viewValueToModel(Object viewValue) throws ViewValueConversionException {
        if (viewValue == null || viewValue.equals("")) {
            return null;
        }
        if (viewValue instanceof String) {
            try {
                this.m_context.getConfigContext().getConfigServer().loadConfigElement((String)viewValue);
                return (String)viewValue;
            }
            catch (Exception e) {
                throw new ViewValueConversionException("Element " + (String)viewValue + " does not exist", e);
            }
        }
        throw new ViewValueConversionException("expected a string");
    }

    @Override
    public Object modelValueToView(Object modelValue) throws ViewValueConversionException {
        ConfigBeanModel model = (ConfigBeanModel)this.m_sheet.getModel();
        IConfigBean bean = (IConfigBean)model.getData();
        Object value = bean.getAttribute(this.m_path);
        if (value != null) {
            if (value instanceof IConfigBean) {
                String name = ((IConfigBean)value).getName();
                String[] viewNames = new String[]{name};
                if (viewNames != null && viewNames.length > 0) {
                    return viewNames[0];
                }
                return null;
            }
            return value.toString();
        }
        return null;
    }

    @Override
    public String[] getViewStringValues() {
        return null;
    }

    @Override
    public boolean isViewValueToModelSupported() {
        return true;
    }

    @Override
    public Class getModelClass() {
        return String.class;
    }

    @Override
    public Class getViewClass() {
        return String.class;
    }
}

