/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime;

import com.sonicsw.ma.gui.JWorkspacePanel;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.action.GoToConfigurationAction;
import com.sonicsw.ma.gui.action.PropSheetAction;
import com.sonicsw.ma.gui.action.RefreshPluginAction;
import com.sonicsw.ma.gui.domain.DomainConnectionModel;
import com.sonicsw.ma.gui.runtime.propsheets.RuntimeBean;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.IRuntimePlugin;
import com.sonicsw.ma.plugin.PluginAttributes;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.runtime.IComponentIdentity;
import com.sonicsw.mf.common.runtime.IContainerState;
import com.sonicsw.mf.common.runtime.IIdentity;
import com.sonicsw.mf.common.runtime.IState;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import java.util.List;
import java.util.Map;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.swing.JComponent;

public abstract class AbstractRuntimePlugin
extends AbstractGUIPlugin
implements IRuntimePlugin {
    private ObjectName m_runtimeName;
    private IIdentity m_runtimeID;
    private RuntimeBean m_model = null;
    protected static double ESB_76_VERSION = 7.6;

    public AbstractRuntimePlugin(IPluginContext context, String id, Map data) {
        super(context, id);
        this.setAttributes();
        this.getAttributes().put(data);
    }

    private void setAttributes() {
        this.setAttributes(new PluginAttributes());
    }

    @Override
    public void dispose() {
        this.m_model = null;
    }

    @Override
    protected JComponent[] getPropertiesMenuItems() {
        return new JComponent[]{new JBasicMenuItem(new PropSheetAction(this))};
    }

    @Override
    protected JComponent[] getViewMenuItems() {
        return new JComponent[]{new JBasicMenuItem(new RefreshPluginAction(this)), new JBasicMenuItem(new GoToConfigurationAction(this))};
    }

    @Override
    public Object getModel() {
        if (this.m_model == null) {
            this.m_model = new RuntimeBean(this.getPluginContext().getConnectionInfo().getMBeanServer(), this.m_runtimeName, this.m_runtimeID);
        }
        return this.m_model;
    }

    public IState getState(boolean recalculate) {
        return this.getState();
    }

    public IState getState() {
        return this.getAttributes().getState();
    }

    public void setState() {
    }

    @Override
    public ObjectName getRuntimeName() {
        return this.m_runtimeName;
    }

    @Override
    public IIdentity getRuntimeID() {
        return this.m_runtimeID;
    }

    @Override
    public void setRuntimeID(IIdentity id, IState state) {
        this.m_runtimeID = id;
        if (id == null) {
            return;
        }
        String name = id.getCanonicalName();
        if (id instanceof IComponentIdentity) {
            this.setPluginName(((IComponentIdentity)id).getComponentName());
        }
        if (name.indexOf(":ID=") == -1) {
            name = name + ":ID=AGENT";
        }
        try {
            this.m_runtimeName = new ObjectName(name);
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to create runtime name for " + this.getPluginName(), e, false);
            return;
        }
        try {
            if (state != null && state.getState() != 1 && state.getState() != 0) {
                boolean isDynamic = this.getAttributes().isDynamicRuntime();
                this.updateMBeanInfo(isDynamic ? this.getAttributes() : this.getAttributes().getParent(), this.getPluginContext().getConnectionInfo().getMBeanServer());
            }
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to load MBeanInfo for " + this.getPluginName(), e, false);
        }
    }

    private void updateMBeanInfo(PluginAttributes attributes, IRemoteMBeanServer server) throws Exception {
        MBeanOperationInfo[] operations;
        if (this.m_runtimeID.getConfigIdentity() == null) {
            return;
        }
        if (attributes.containsKey("MBEAN_INFO")) {
            return;
        }
        MBeanInfo info = server.getMBeanInfo(this.m_runtimeName);
        attributes.set("MBEAN_INFO", info);
        if (info != null && (operations = info.getOperations()) != null) {
            for (int i = 0; i < operations.length; ++i) {
                if (!operations[i].getName().equals("getMetricsInfo")) continue;
                IMetricInfo[] metric = (IMetricInfo[])server.invoke(this.m_runtimeName, "getMetricsInfo", new Object[0], new String[0]);
                attributes.set("METRIC_INFO", metric);
                break;
            }
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanInfo info = (MBeanInfo)this.getAttributes().get("MBEAN_INFO");
        MBeanNotificationInfo[] res = null;
        if (info != null) {
            res = info.getNotifications();
        }
        if (res != null && res.length == 0) {
            res = null;
        }
        return res;
    }

    protected IMetricInfo[] getMetricInfo() {
        IMetricInfo[] res = (IMetricInfo[])this.getAttributes().get("METRIC_INFO");
        if (res != null && res.length == 0) {
            res = null;
        }
        return res;
    }

    @Override
    public Object invokeAction(String action, Object[] args, String[] sigs) {
        return this.invokeAction(action, args, sigs, -1);
    }

    @Override
    public Object invokeAction(String action, Object[] args, String[] sigs, int timeout) {
        Object ret = null;
        try {
            long lTimeout = -1L;
            DomainConnectionModel domainModel = this.getPluginContext().getConnectionInfo();
            if (timeout >= 0) {
                int defTimeout = domainModel.getTimeout();
                lTimeout = defTimeout * 1000 * timeout;
            }
            IRemoteMBeanServer server = domainModel.getMBeanServer();
            ret = AbstractRuntimePlugin.invokeAction(server, this.getRuntimeName(), action, args, sigs, lTimeout, this.getClass().getClassLoader());
        }
        catch (Throwable e) {
            Throwable tmpE = e;
            if (e instanceof RuntimeOperationsException) {
                tmpE = ((RuntimeOperationsException)e).getTargetException();
            }
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to perform action " + action + "() on\r\n" + this.m_runtimeName.getCanonicalName(), tmpE, true);
        }
        return ret;
    }

    public static Object invokeAction(IRemoteMBeanServer server, ObjectName name, String action, Object[] args, String[] sigs, long timeout, ClassLoader loader) throws Throwable {
        if (timeout < 0L) {
            return ((JMSConnectorClient)server).invoke(name, action, args, sigs, loader);
        }
        return ((JMSConnectorClient)server).invoke(name, action, args, sigs, timeout, loader);
    }

    public void goToConfiguration() {
        boolean isStateable = this.getAttributes().isStateable();
        String path = this.getPluginPath();
        if (isStateable) {
            String runtimeID = this.getRuntimeID().getCanonicalName();
            path = this.getPluginContext().getConnectionInfo().getAgentManagerConnection().runtimeIDToConfigName(runtimeID);
            int index = path.indexOf("_Default");
            if (index != -1) {
                path = path.substring(0, index - 1);
            }
        }
        if (path != null) {
            this.getPluginContext().getWorkspace().goToConfiguration(path, true);
        }
    }

    @Override
    public List getToolTipList() {
        List list = super.getToolTipList();
        IState state = this.getAttributes().getState();
        if (state != null) {
            list.add(this.formatToolTipText("State", state.getStateString()));
            if (state instanceof IContainerState) {
                list.add(this.formatToolTipText("Host", ((IContainerState)state).getContainerHost()));
            }
        }
        return list;
    }

    @Override
    protected JWorkspacePanel getWorkspacePanel() {
        return this.getPluginContext().getWorkspace().getWorkspacePanel("Manage");
    }

    protected boolean checkVersion(double version) {
        try {
            double productVersion = Double.parseDouble(this.getAttributes().getProductVersion());
            if (productVersion >= version) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        return false;
    }
}

