/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.WorkspaceWindow;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.runtime.AbstractRuntimePlugin;
import com.sonicsw.ma.gui.runtime.ComponentPropSheet;
import com.sonicsw.ma.gui.runtime.JMonitorDialog;
import com.sonicsw.ma.gui.runtime.RuntimeAction;
import com.sonicsw.ma.gui.runtime.RuntimeStartAction;
import com.sonicsw.ma.gui.runtime.RuntimeStopAction;
import com.sonicsw.ma.gui.runtime.metrics.model.MetricsModel;
import com.sonicsw.ma.gui.runtime.notifications.model.NotificationsModel;
import com.sonicsw.ma.gui.table.IContentPane;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JBasicMenu;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.IRuntimePlugin;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.runtime.IState;
import com.sonicsw.mf.common.runtime.impl.ComponentState;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.management.MBeanNotificationInfo;
import javax.swing.JComponent;
import javax.swing.tree.DefaultTreeModel;

public class ComponentPlugin
extends AbstractRuntimePlugin {
    private static final String TRACKID_TOOLS = "MANAGED_TOOLS_DIALOG";
    public static final String ATTRIBUTE_CONFIGID = "ConfigID";
    public static final String ATTRIBUTE_RELEASE_VERSION = "ReleaseVersion";
    public static final String ATTRIBUTE_STATE = "State";
    public static final String ATTRIBUTE_STATE_STRING = "StateString";
    public static final String ATTRIBUTE_LAST_ERROR = "LastError";
    public static final String ATTRIBUTE_ERROR_LEVEL = "LastErrorLevel";
    public static final String ATTRIBUTE_ERROR_STRING = "LastErrorLevelString";
    public static final String ATTRIBUTE_UPTIME = "Uptime";
    public static final String ATTRIBUTE_CLASS_NAME = "Classname";
    public static final String ATTRIBUTE_CLASS_PATH = "Classpath";
    public static final String ATTRIBUTE_TRACE_MASK = "TraceMask";
    public static final String ATTRIBUTE_TRACE_VALUES = "TraceMaskValues";
    private NotificationsModel m_notificationsModel;
    private MetricsModel m_metricsModel;

    public ComponentPlugin(IPluginContext context, String id, Map data) {
        super(context, id, data);
    }

    @Override
    public boolean expand() {
        return false;
    }

    @Override
    public JPropSheetDialog getPropSheetDialog() {
        return new ComponentPropSheet(MgmtConsole.getMgmtConsole());
    }

    @Override
    public String[] getAllSupportedMonitors() {
        ArrayList<String> res = new ArrayList<String>();
        if (this.isMonitorSupported("_Metrics")) {
            res.add("_Metrics");
        }
        if (this.isMonitorSupported("_Notifications")) {
            res.add("_Notifications");
        }
        return res.toArray(new String[res.size()]);
    }

    @Override
    public boolean isMonitorSupported(String monitorId) {
        boolean res = false;
        if (monitorId != null) {
            if (monitorId.equals("_Metrics")) {
                res = this.getMetricInfo() != null;
            } else if (monitorId.equals("_Notifications")) {
                res = this.getNotificationInfo() != null;
            }
        }
        return res;
    }

    @Override
    public Object getMonitorModel(String monitorId) {
        DefaultTreeModel res = null;
        if (this.isMonitorSupported(monitorId)) {
            if (monitorId.equals("_Metrics")) {
                try {
                    IRemoteMBeanServer server = this.getPluginContext().getRuntimeContext().getMBeanServer();
                    IMetricInfo[] info = this.getMetricInfo();
                    this.m_metricsModel = new MetricsModel(server, this.getRuntimeName(), info);
                }
                catch (Exception e) {
                    MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to get metrics info: " + e.getMessage(), e, false);
                    this.m_metricsModel = null;
                }
                res = this.m_metricsModel;
            } else if (monitorId.equals("_Notifications")) {
                try {
                    IRemoteMBeanServer server = this.getPluginContext().getRuntimeContext().getMBeanServer();
                    MBeanNotificationInfo[] info = this.getNotificationInfo();
                    if (this.m_notificationsModel == null) {
                        this.m_notificationsModel = new NotificationsModel(server, this.getRuntimeName(), info);
                    }
                }
                catch (Exception e) {
                    MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to get notifications info: " + e.getMessage(), e, false);
                    this.m_notificationsModel = null;
                }
                res = this.m_notificationsModel;
            }
        }
        return res;
    }

    protected boolean isComponentAvailable() {
        IState state = this.getAttributes().getState();
        return state != null && (state.getState() == 3 || state.getState() == 0);
    }

    protected boolean isParentContainerAvailable() {
        IPlugin container = (IPlugin)((Object)this.getParent());
        IState state = container != null ? container.getAttributes().getState() : null;
        return state != null && (state.getState() == 3 || state.getState() == 0);
    }

    protected JComponent getOperationsStartMenuItem() {
        return new JBasicMenuItem(new RuntimeStartAction(this, "ComponentPlugin.start"));
    }

    protected JComponent getOperationsStopMenuItem() {
        return new JBasicMenuItem(new RuntimeStopAction(this, "ComponentPlugin.stop", "Are you sure you want to stop this component?"));
    }

    protected JComponent[] getOperationsMenuItems() {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        list.add(this.getOperationsStartMenuItem());
        list.add(this.getOperationsStopMenuItem());
        if (this.getAttributes().isReloadable()) {
            list.add(new JBasicMenuItem(new RuntimeAction(this, "ComponentPlugin.reload", "reload", "Are you sure you want to reload this component?", 4)));
        }
        list.add(new JBasicMenuItem(new ClearErrorAction(this, "ComponentPlugin.clearError", "clearError")));
        if (this.isComponentAvailable() && this.isMonitorSupported("_Metrics")) {
            list.add(new JBasicMenuItem(new RuntimeAction(this, "ComponentPlugin.resetMetrics", "resetMetrics", "Are you sure you want to reset all metrics?")));
        }
        return list.toArray(new JComponent[list.size()]);
    }

    @Override
    public JComponent[] getPluginMenuItems() {
        JBasicMenu opMenu = new JBasicMenu(new ComponentOperationsAction("runtime.operations"));
        JComponent[] ops = this.getOperationsMenuItems();
        for (int i = 0; i < ops.length; ++i) {
            ((Container)opMenu).add(ops[i]);
        }
        return Helper.combineMenu(new JComponent[]{opMenu}, super.getPluginMenuItems(), false);
    }

    @Override
    protected JComponent[] getPropertiesMenuItems() {
        JBasicMenuItem notificationsMenuItem = new JBasicMenuItem(new NotificationsAction(this));
        JBasicMenuItem metricsMenuItem = new JBasicMenuItem(new MetricsAction(this));
        JComponent[] items = new JComponent[]{notificationsMenuItem, metricsMenuItem};
        return Helper.combineMenu(items, super.getPropertiesMenuItems(), true);
    }

    private void launchMonitorDialog(String monitorId) {
        try {
            JMonitorDialog dialog = (JMonitorDialog)this.getPluginContext().getWorkspace().getTrackedDialog(TRACKID_TOOLS);
            if (dialog == null) {
                final WorkspaceWindow ww = this.getPluginContext().getWorkspace();
                dialog = new JMonitorDialog((JMAFrame)MgmtConsole.getMgmtConsole(), this.getPluginContext().getWorkspace());
                this.getPluginContext().getWorkspace().addTrackedDialog(TRACKID_TOOLS, dialog);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent evt) {
                        ww.removeTrackedDialog(ComponentPlugin.TRACKID_TOOLS);
                    }
                });
                dialog.setVisible(true);
                dialog.pluginChange(this);
            } else {
                dialog.toFront();
            }
            dialog.setVisibleMonitor(monitorId);
        }
        catch (Throwable e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to launch manage tools", e, true);
        }
    }

    private class ClearErrorAction
    extends RuntimeAction {
        public ClearErrorAction(IRuntimePlugin plugin, String name, String action) {
            super(plugin, name, action);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            super.actionPerformed(evt);
            IState state = this.m_plugin.getAttributes().getState();
            if (state instanceof ComponentState) {
                ((ComponentState)state).setLastErrorDescription("");
                ((ComponentState)state).setLastErrorLevel(0);
                IContentPane pluginContentPane = this.m_plugin.getPluginContentPane();
                if (pluginContentPane != null) {
                    pluginContentPane.refresh();
                }
            }
        }
    }

    private class MetricsAction
    extends BasicPluginAction {
        public MetricsAction(IPlugin plugin) {
            super(plugin, "ComponentPlugin.metrics");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());
            try {
                ComponentPlugin.this.launchMonitorDialog("_Metrics");
            }
            finally {
                wc.release();
            }
        }

        @Override
        public boolean isEnabled() {
            return ((ComponentPlugin)this.getPlugin()).isParentContainerAvailable() && ((ComponentPlugin)this.getPlugin()).isMonitorSupported("_Metrics");
        }
    }

    private class NotificationsAction
    extends BasicPluginAction {
        public NotificationsAction(IPlugin plugin) {
            super(plugin, "ComponentPlugin.notifications");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());
            try {
                ComponentPlugin.this.launchMonitorDialog("_Notifications");
            }
            finally {
                wc.release();
            }
        }

        @Override
        public boolean isEnabled() {
            return ((ComponentPlugin)this.getPlugin()).isParentContainerAvailable() && ((ComponentPlugin)this.getPlugin()).isMonitorSupported("_Notifications");
        }
    }

    class ComponentOperationsAction
    extends BasicGuiAction {
        public ComponentOperationsAction(String resId) {
            super(resId);
        }
    }
}

