/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.runtime.propsheets.JRuntimeTabbedDialog;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ColorIcon;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.JPathChooser;
import com.sonicsw.ma.gui.util.StateHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import modelobjects.framework.EditRule;
import modelobjects.framework.LongDateToStringConverter;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.ViewAspectAdapter;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.ViewValueConverter;
import modelobjects.framework.model.ModelAspectId;

public class ComponentPropSheet
extends JRuntimeTabbedDialog {
    private static final String RES_COMPONENT = "component";
    private static final String SCHEMA_FILE = "file:/";
    private int m_startMask = -1;
    private JPartitionPanel m_generalPanel;
    private JTextField m_name = new JTextField();
    private JTextField m_uptime = new JTextField();
    private JTextField m_releaseVersion = new JTextField();
    private JTextField m_className = new JTextField(32);
    private JTextArea m_classPath = new JTextArea(8, 32);
    private JTextField m_configID = new JTextField();
    private JTextField m_sharedSpace = new JTextField();
    private JLabel m_state = new JLabel();
    private JLabel m_stateIcon = new JLabel();
    private JLabel m_errorIcon = new JLabel();
    private JLabel m_errorLevel = new JLabel();
    private JTextArea m_lastError = new JTextArea(4, 32);
    private JTraceList m_trace;

    public ComponentPropSheet(JMAFrame parent) {
        this(parent, "runtime.component");
    }

    public ComponentPropSheet(JMAFrame parent, String name) {
        super(parent, name);
    }

    @Override
    public void initUI() throws Exception {
        this.m_generalPanel = (JPartitionPanel)this.makeGeneralPanel();
        this.addTabPanel("General", JPartitionPanel.wrap(this.m_generalPanel));
        this.addTabPanel("Loading", this.makeLoadingPanel());
        this.addTabPanel("Tracing", this.makeTracePanel());
    }

    @Override
    public void initForm() throws Exception {
        this.createJTextFieldAdapter("_NAME", this.m_name, null);
        this.createJTextFieldAdapter("Classname", this.m_className, null);
        this.createJTextAreaAdapter("Classpath", this.m_classPath, new ClassViewValueConverter());
        this.createJTextFieldAdapter("ReleaseVersion", this.m_releaseVersion, null);
        this.createJTextFieldAdapter("ConfigID", this.m_configID, null);
        this.createJTextFieldAdapter("Uptime", this.m_uptime, new LongDateToStringConverter(true, "{0} days, {1} hours, {2} minutes"));
        new JStateIconLabelAdapter(ModelAspectId.forName("State"), this.m_stateIcon, null, this.getEditForm().getModelEditMediator());
        this.createJLabelAdapter("StateString", this.m_state, null);
        new JErrorLevelIconLabelAdapter(ModelAspectId.forName("LastErrorLevel"), this.m_errorIcon, null, this.getEditForm().getModelEditMediator());
        this.createJLabelAdapter("LastErrorLevelString", this.m_errorLevel, null);
        this.createJTextAreaAdapter("LastError", this.m_lastError, null);
        this.m_lastError.setWrapStyleWord(true);
        this.m_lastError.setLineWrap(true);
        new JTraceListViewAspectAdapter(ModelAspectId.forName("TraceMaskValues"), this.m_trace, null, this.getEditForm().getModelEditMediator());
        new JTraceListViewAspectAdapter(ModelAspectId.forName("TraceMask"), this.m_trace, null, this.getEditForm().getModelEditMediator());
    }

    protected JPartitionPanel getGeneralPanel() {
        return this.m_generalPanel;
    }

    private JPanel makeGeneralPanel() {
        JPartitionPanel panel = new JPartitionPanel(true, "p,p,p", null, 0, 0, 0);
        panel.add(this.makeGeneralMainPanel());
        panel.add(this.makeGeneralStatusPanel());
        return panel;
    }

    private JPanel makeGeneralMainPanel() {
        JPartitionPanel panel = new JPartitionPanel("Identity");
        panel.addRow(this.getResourceLabel("_NAME"), (JComponent)this.m_name);
        panel.addRow(this.getResourceLabel("ConfigID"), (JComponent)this.m_configID);
        panel.addRow(this.getResourceLabel("Uptime"), (JComponent)this.m_uptime);
        return panel;
    }

    private JPanel makeGeneralStatusPanel() {
        JPartitionPanel pState = JPartitionPanel.merge("p,r", false, 5, 0, 0, new Component[]{this.m_stateIcon, this.m_state});
        JPartitionPanel eState = JPartitionPanel.merge("p,r", false, 5, 0, 0, new Component[]{this.m_errorIcon, this.m_errorLevel});
        JPartitionPanel panel = new JPartitionPanel("Status");
        panel.addRow(this.getResourceLabel("StateString"), (JComponent)pState);
        panel.addRow(this.getResourceLabel("LastErrorLevelString"), (JComponent)eState);
        panel.addRow(this.getResourceLabel("LastError"), (JComponent)new ExtendedJScrollPane(this.m_lastError));
        return panel;
    }

    private JPanel makeLoadingPanel() {
        JPartitionPanel panel = new JPartitionPanel("Loader Details");
        panel.addRow(this.getResourceLabel("Classname"), (JComponent)this.m_className);
        panel.addRow(this.getResourceLabel("Classpath"), (JComponent)new ExtendedJScrollPane(this.m_classPath));
        panel.addRow(this.getResourceLabel("ReleaseVersion"), (JComponent)this.m_releaseVersion);
        return JPartitionPanel.wrap(panel);
    }

    private JPanel makeTracePanel() {
        this.m_trace = new JTraceList();
        JPartitionPanel panel = new JPartitionPanel(false, "r", null);
        panel.add(new ExtendedJScrollPane(this.m_trace));
        return panel;
    }

    private String capitalizeDescription(String desc) {
        StringBuffer sb = new StringBuffer(desc);
        if (Character.isLowerCase(sb.charAt(0))) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        for (int i = 1; i < sb.length(); ++i) {
            if (Character.isLetterOrDigit(sb.charAt(i - 1)) || !Character.isLetterOrDigit(sb.charAt(i))) continue;
            sb.setCharAt(i, Character.toUpperCase(sb.charAt(i)));
        }
        return sb.toString();
    }

    public class ClassViewValueConverter
    implements ViewValueConverter {
        @Override
        public String[] getViewStringValues() {
            return null;
        }

        @Override
        public Class getModelClass() {
            return String.class;
        }

        @Override
        public Class getViewClass() {
            return String.class;
        }

        @Override
        public Object viewValueToModel(Object viewValue) throws ViewValueConversionException {
            throw new ViewValueConversionException("not supported - read only");
        }

        @Override
        public Object modelValueToView(Object modelValue) throws ViewValueConversionException {
            if (modelValue == null || !(modelValue instanceof String)) {
                return null;
            }
            String inValue = (String)modelValue;
            StringTokenizer st = new StringTokenizer((String)modelValue, ";");
            StringBuffer sb = new StringBuffer();
            while (st.hasMoreTokens()) {
                String classItem = st.nextToken().replaceAll("%20", " ");
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(classItem);
            }
            return sb.toString();
        }

        @Override
        public boolean isViewValueToModelSupported() {
            return true;
        }
    }

    public class ClassPathAction
    extends BasicGuiAction {
        public ClassPathAction() {
            super("ComponentPropSheet.classpath");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                String[] list = Helper.stringToArray(ComponentPropSheet.this.m_classPath.getText());
                JPathChooser chooser = new JPathChooser();
                chooser.setReadOnly(true);
                chooser.setSelectedPaths(list);
                chooser.showDialog(ComponentPropSheet.this);
            }
            catch (Exception e) {
                MgmtConsole.displayMessage(4, "Error in ClassPathAction.", e, true);
            }
        }
    }

    public class JStateIconLabelAdapter
    extends ViewAspectAdapter {
        private JLabel viewComponent;

        public JStateIconLabelAdapter(ModelAspectId modelAspectId, JLabel viewComponent) {
            super(modelAspectId);
            this.setViewComponent(viewComponent);
        }

        public JStateIconLabelAdapter(ModelAspectId modelAspectId, JLabel viewComponent, ViewValueConverter viewValueConverter, ModelEditMediator modelEditMediator) {
            super(modelAspectId, EditRule.NEVER, viewValueConverter, modelEditMediator);
            this.setViewComponent(viewComponent);
        }

        private void setViewComponent(JLabel viewComponent) {
            this.viewComponent = viewComponent;
        }

        @Override
        public Component getViewComponent() {
            return this.viewComponent;
        }

        @Override
        public boolean isEditable() {
            return false;
        }

        @Override
        public void setEditable(boolean editable) {
        }

        @Override
        public Object getViewAspectValue() {
            return this.viewComponent.getText();
        }

        @Override
        public String getViewAspectStringValue() {
            return this.viewComponent.getText();
        }

        @Override
        protected void setViewAspectValue(Object viewAspectValue) throws IllegalArgumentException {
            if (viewAspectValue == null) {
                this.viewComponent.setIcon(null);
            } else if (viewAspectValue instanceof Short) {
                short value = (Short)viewAspectValue;
                Color color = StateHelper.componentStateToColor(value);
                if (color != null) {
                    this.viewComponent.setIcon(new ColorIcon(color, 14));
                }
            } else {
                throw new IllegalArgumentException("value must be a Short");
            }
        }

        @Override
        protected void setViewAspectStringValue(String viewStringValue) throws IllegalArgumentException {
            if (viewStringValue == null) {
                this.viewComponent.setText("");
            } else {
                this.viewComponent.setText(viewStringValue);
            }
        }
    }

    public class JErrorLevelIconLabelAdapter
    extends ViewAspectAdapter {
        private JLabel viewComponent;

        public JErrorLevelIconLabelAdapter(ModelAspectId modelAspectId, JLabel viewComponent) {
            super(modelAspectId);
            this.setViewComponent(viewComponent);
        }

        public JErrorLevelIconLabelAdapter(ModelAspectId modelAspectId, JLabel viewComponent, ViewValueConverter viewValueConverter, ModelEditMediator modelEditMediator) {
            super(modelAspectId, EditRule.NEVER, viewValueConverter, modelEditMediator);
            this.setViewComponent(viewComponent);
        }

        private void setViewComponent(JLabel viewComponent) {
            this.viewComponent = viewComponent;
        }

        @Override
        public Component getViewComponent() {
            return this.viewComponent;
        }

        @Override
        public boolean isEditable() {
            return false;
        }

        @Override
        public void setEditable(boolean editable) {
        }

        @Override
        public Object getViewAspectValue() {
            return this.viewComponent.getText();
        }

        @Override
        public String getViewAspectStringValue() {
            return this.viewComponent.getText();
        }

        @Override
        protected void setViewAspectValue(Object viewAspectValue) throws IllegalArgumentException {
            if (viewAspectValue == null) {
                this.viewComponent.setIcon(new ColorIcon(Color.BLUE, 14));
            } else if (viewAspectValue instanceof Integer) {
                int value = (Integer)viewAspectValue;
                Color color = StateHelper.errorLevelToColor(value);
                if (color != null) {
                    this.viewComponent.setIcon(new ColorIcon(color, 14));
                }
            } else {
                throw new IllegalArgumentException("value must be an Integer");
            }
        }

        @Override
        protected void setViewAspectStringValue(String viewStringValue) throws IllegalArgumentException {
            if (viewStringValue == null) {
                this.viewComponent.setText("");
            } else {
                this.viewComponent.setText(viewStringValue);
            }
        }
    }

    class JTraceListViewAspectAdapter
    extends ViewAspectAdapter
    implements ListDataListener {
        private JTraceList m_list;

        public JTraceListViewAspectAdapter(ModelAspectId aspectId, JTraceList list, EditRule editRule, ModelEditMediator modelEditMediator) {
            super(aspectId, editRule, null, modelEditMediator);
            this.m_list = list;
            this.m_list.getModel().addListDataListener(this);
        }

        @Override
        public Component getViewComponent() {
            return this.m_list;
        }

        @Override
        public Object getModelAspectValue() throws ViewValueConversionException {
            ListModel model = this.m_list.getModel();
            int maskValue = 0;
            for (int i = 0; i < model.getSize(); ++i) {
                TraceItem item = (TraceItem)model.getElementAt(i);
                if (!item.isSelected()) continue;
                maskValue |= item.getMask();
            }
            return new Integer(maskValue);
        }

        @Override
        public Object getViewAspectValue() {
            return this.m_list.getModel();
        }

        @Override
        public void setViewAspectValue(Object value) {
            if (value != null) {
                if (value instanceof Integer) {
                    int newValue = (Integer)value;
                    if (newValue >= 0) {
                        ComponentPropSheet.this.m_startMask = newValue;
                        this.enforceMask();
                    }
                } else if (value instanceof String) {
                    StringTokenizer st = new StringTokenizer((String)value, ",");
                    ((DefaultListModel)this.m_list.getModel()).clear();
                    while (st.hasMoreTokens()) {
                        String[] split = st.nextToken().split("=");
                        TraceItem anItem = new TraceItem(Integer.parseInt(split[0]), split[1]);
                        ((DefaultListModel)this.m_list.getModel()).addElement(anItem);
                    }
                    if (ComponentPropSheet.this.m_startMask >= 0) {
                        this.enforceMask();
                    }
                } else {
                    throw new IllegalArgumentException("value must be a String");
                }
            }
        }

        @Override
        public String getViewAspectStringValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setViewAspectStringValue(String stringValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setEditable(boolean editable) {
            this.m_list.setEnabled(true);
        }

        @Override
        public boolean isEditable() {
            return this.m_list.isEnabled();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.fireChangeEvent();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.fireChangeEvent();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.fireChangeEvent();
        }

        private void enforceMask() {
            int maskValue;
            DefaultListModel model = (DefaultListModel)this.m_list.getModel();
            for (int i = 0; i < 16 && (maskValue = (int)Math.pow(2.0, i)) <= ComponentPropSheet.this.m_startMask; ++i) {
                TraceItem item;
                int index;
                if ((maskValue & ComponentPropSheet.this.m_startMask) != maskValue || (index = this.findMask(model, maskValue)) < 0 || (item = (TraceItem)model.getElementAt(index)) == null) continue;
                item.setSelected(true);
                model.set(index, item);
            }
        }

        private int findMask(DefaultListModel model, int maskValue) {
            for (int i = 0; i < model.size(); ++i) {
                TraceItem item = (TraceItem)model.getElementAt(i);
                if (maskValue != item.getMask()) continue;
                return i;
            }
            return -1;
        }
    }

    class TraceListCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        public TraceListCellRenderer() {
            this.setProperties();
        }

        private void setProperties() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
            this.setBorderPainted(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            TraceItem item = (TraceItem)value;
            this.setComponentOrientation(list.getComponentOrientation());
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            this.setText(item.toString());
            this.setSelected(item.isSelected());
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            return this;
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, char oldValue, char newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, short oldValue, short newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    class JTraceList
    extends JList
    implements MouseListener {
        public JTraceList() {
            super(new DefaultListModel());
            this.setProperties();
        }

        private void setProperties() {
            this.setCellRenderer(new TraceListCellRenderer());
            this.setSelectionMode(0);
            this.addMouseListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            int click = evt.getClickCount();
            Point point = evt.getPoint();
            DefaultListModel model = (DefaultListModel)this.getModel();
            int index = this.locationToIndex(point);
            TraceItem item = (TraceItem)model.getElementAt(index);
            if (click == 1 && index == ComponentPropSheet.this.m_trace.getSelectedIndex() || click == 2) {
                item.setSelected(!item.isSelected());
                model.set(index, item);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    class TraceItem {
        private int m_mask;
        private String m_desc;
        private boolean m_selected;

        public TraceItem(int mask, String desc) {
            this.m_mask = mask;
            this.m_desc = ComponentPropSheet.this.capitalizeDescription(desc);
            this.m_selected = false;
        }

        public int getMask() {
            return this.m_mask;
        }

        public String getDescription() {
            return this.m_desc;
        }

        public boolean isSelected() {
            return this.m_selected;
        }

        public void setSelected(boolean selected) {
            this.m_selected = selected;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getDescription());
            sb.append(" (");
            sb.append(this.getMask());
            sb.append(")");
            return sb.toString();
        }
    }
}

