/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime;

import com.sonicsw.ma.gui.runtime.ViewLogInternalFrame;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import modelobjects.layout.PartitionLayout;

class FindToolBar
extends JToolBar
implements DocumentListener {
    private ViewLogInternalFrame frame = null;
    private JTextField textField = new JTextField(20);
    private JButton closeButton = null;
    private JButton nextButton = null;
    private JButton previousButton = null;
    private JCheckBox matchCaseCheckBox = null;
    private String findString = "";
    private JLabel statusLabel = new JLabel("");
    public static final int FOUND = 0;
    public static final int ON_TEXT = 1;
    public static final int ON_NEXT = 2;
    public static final int ON_PREVIOUS = 3;
    private int nextCount = 0;
    private int previousCount = 0;

    public FindToolBar(ViewLogInternalFrame viewLogFrame) {
        this.prepareFindToolBar(viewLogFrame);
    }

    private void prepareFindToolBar(ViewLogInternalFrame viewLogFrame) {
        this.frame = viewLogFrame;
        this.setFloatable(false);
        this.setRollover(true);
        this.setLayout(new PartitionLayout(false, "p,p,p,p,p,p,r", 5));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.textField.getDocument().addDocumentListener(this);
        this.closeButton = new JButton(new BasicGuiAction("ContainerPlugin.viewlog.close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindToolBar.this.setVisible(false);
            }
        });
        this.nextButton = new JButton(new NextAction());
        this.previousButton = new JButton(new PreviousAction());
        this.matchCaseCheckBox = new JCheckBox("Match Case");
        this.matchCaseCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!FindToolBar.this.matchCaseCheckBox.isSelected() && FindToolBar.this.getFindString().equalsIgnoreCase(FindToolBar.this.frame.getSelectedText())) {
                    FindToolBar.this.nextCount = (FindToolBar.this.previousCount = 1);
                } else {
                    FindToolBar.this.nextCount = (FindToolBar.this.previousCount = 0);
                }
            }
        });
        this.add(this.closeButton);
        this.add(new JLabel("Find: "));
        this.add(this.textField);
        this.add(this.nextButton);
        this.add(this.previousButton);
        this.add(this.matchCaseCheckBox);
        this.add(this.statusLabel);
    }

    public void resetCounters() {
        this.nextCount = 0;
        this.previousCount = 0;
    }

    public boolean getMatchCase() {
        return this.matchCaseCheckBox.isSelected();
    }

    public void setFocus() {
        this.textField.requestFocus();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.findStringStatus(1);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.findStringStatus(1);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.findStringStatus(1);
    }

    private void findStringStatus(int type) {
        int ret = -1;
        switch (type) {
            case 1: {
                ret = this.frame.searchString();
                if (ret == -1) {
                    this.nextCount = 0;
                    this.previousCount = 0;
                    this.setStatus(1);
                    break;
                }
                this.setStatus(0);
                ++this.nextCount;
                ++this.previousCount;
                break;
            }
            case 2: {
                ret = this.frame.searchNext();
                if (ret == -1) {
                    if (this.nextCount == 0) {
                        this.setStatus(1);
                        break;
                    }
                    this.setStatus(2);
                    break;
                }
                ++this.nextCount;
                this.previousCount = 0;
                this.setStatus(0);
                break;
            }
            case 3: {
                ret = this.frame.searchPrevious();
                if (ret == -1) {
                    if (this.previousCount == 0) {
                        this.setStatus(1);
                        break;
                    }
                    this.setStatus(3);
                    break;
                }
                ++this.previousCount;
                this.nextCount = 0;
                this.setStatus(0);
                break;
            }
        }
    }

    public void setStatus(int status) {
        switch (status) {
            case 1: {
                this.statusLabel.setText("     String Not Found");
                this.textField.setBackground(new Color(192, 72, 72));
                break;
            }
            case 2: {
                this.textField.setBackground(Color.WHITE);
                this.statusLabel.setText("     Reached end of the log");
                break;
            }
            case 3: {
                this.textField.setBackground(Color.WHITE);
                this.statusLabel.setText("     Reached beginning of the log");
                break;
            }
            default: {
                this.textField.setBackground(Color.WHITE);
                this.statusLabel.setText("");
            }
        }
    }

    public String getFindString() {
        this.findString = this.textField.getText();
        return this.findString;
    }

    public class PreviousAction
    extends BasicGuiAction {
        public PreviousAction() {
            super("ContainerPlugin.viewlog.previous");
            this.putMnemonicKeyVal();
        }

        private void putMnemonicKeyVal() {
            this.putValue("MnemonicKey", new Integer(78));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            FindToolBar.this.findStringStatus(3);
        }
    }

    public class NextAction
    extends BasicGuiAction {
        public NextAction() {
            super("ContainerPlugin.viewlog.next");
            this.putMnemonicKeyVal();
        }

        private void putMnemonicKeyVal() {
            this.putValue("MnemonicKey", new Integer(78));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            FindToolBar.this.findStringStatus(2);
        }
    }
}

