/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime;

import com.sonicsw.ma.gui.GUIMonitorPluginListener;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.WorkspaceWindow;
import com.sonicsw.ma.gui.runtime.JAbstractMonitorPanel;
import com.sonicsw.ma.gui.runtime.metrics.JAggregateMetricPanel;
import com.sonicsw.ma.gui.runtime.metrics.JMetricsPanel;
import com.sonicsw.ma.gui.runtime.notifications.JForwardedNotificationsPanel;
import com.sonicsw.ma.gui.runtime.notifications.JNotificationsPanel;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JMAInternalFrame;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IMonitorPlugin;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;

public final class JMonitorDialog
extends JMADialog {
    private static final Class[] TAB_CLASS = new Class[]{JNotificationsPanel.class, JMetricsPanel.class, JForwardedNotificationsPanel.class, JAggregateMetricPanel.class, com.sonicsw.ma.gui.config.metrics.JMetricsPanel.class};
    private JTabbedPane m_tab;
    private JMAInternalFrame m_parentInternal;
    private HashMap m_panels;
    private GUIMonitorPluginListener listener;

    public JMonitorDialog(JMAFrame parent, JMAInternalFrame parentInternal) throws Exception {
        super(parent, "manage-tools");
        this.setModal(false);
        this.m_panels = new HashMap();
        this.m_parentInternal = parentInternal;
        this.listener = new GUIMonitorPluginListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void guiMonitorPluginChanged(IMonitorPlugin plugin) {
                JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());
                try {
                    JMonitorDialog.this.pluginChange(plugin);
                }
                finally {
                    wc.release();
                }
            }
        };
        ((WorkspaceWindow)this.m_parentInternal).addGUIMonitorPluginListener(this.listener);
    }

    @Override
    public String getTitle() {
        return ResourceManager.getString(this.getClass(), "dialog." + this.m_name + ".title");
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(300, 350);
    }

    public void setVisibleMonitor(String monitorId) {
        int index;
        JAbstractMonitorPanel panel = this.getPanel(monitorId);
        if (panel != null && (index = this.m_tab.indexOfTab(panel.getTabTitle())) >= 0) {
            this.m_tab.setSelectedIndex(index);
        }
    }

    public WorkspaceWindow getWorkspaceWindow() {
        return (WorkspaceWindow)this.m_parentInternal;
    }

    @Override
    public void maInitialize() {
        this.m_tab = new JMonitorTabbedPane(1);
        this.getContentPane().add((Component)this.m_tab, "Center");
        try {
            for (int i = 0; i < TAB_CLASS.length; ++i) {
                JAbstractMonitorPanel panel = (JAbstractMonitorPanel)TAB_CLASS[i].newInstance();
                panel.maInitialize();
                this.m_panels.put(panel.getTabTitle(), panel);
            }
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to initialize monitor", e, false);
        }
    }

    @Override
    public void maCleanup() {
        for (String tabTitle : this.m_panels.keySet()) {
            JAbstractMonitorPanel panel = (JAbstractMonitorPanel)this.m_panels.get(tabTitle);
            panel.maCleanup();
        }
        ((WorkspaceWindow)this.m_parentInternal).removeGUIMonitorPluginListener(this.listener);
        this.m_panels.clear();
    }

    @Override
    public Action[] getButtonActions() {
        return new Action[0];
    }

    public void pluginChange(IMonitorPlugin plugin) {
        String path;
        for (Map.Entry entry : this.m_panels.entrySet()) {
            JAbstractMonitorPanel panel = (JAbstractMonitorPanel)entry.getValue();
            boolean visible = plugin != null && plugin.isMonitorSupported(panel.getMonitorId());
            this.setTabVisibility(panel, visible);
            ((JAbstractMonitorPanel)entry.getValue()).changeModel(plugin);
        }
        StringBuffer title = new StringBuffer();
        title.append(ResourceManager.getString(this.getClass(), "dialog." + this.m_name + ".title"));
        String string = path = plugin != null ? plugin.getPluginPath() : null;
        if (path != null && path.trim().length() > 0) {
            title.append(" - ").append(path);
        }
        this.setTitle(title.toString());
    }

    private JAbstractMonitorPanel getPanel(String monitorId) {
        JAbstractMonitorPanel res = null;
        Iterator i = this.m_panels.entrySet().iterator();
        if (monitorId != null) {
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                JAbstractMonitorPanel panel = (JAbstractMonitorPanel)entry.getValue();
                if (!panel.getMonitorId().equals(monitorId)) continue;
                res = panel;
                break;
            }
        }
        return res;
    }

    private void setTabVisibility(JAbstractMonitorPanel panel, boolean state) {
        int index = this.m_tab.indexOfTab(panel.getTabTitle());
        if (state) {
            if (index < 0) {
                if (panel.getClass() == TAB_CLASS[0]) {
                    this.m_tab.insertTab(panel.getTabTitle(), panel.getIcon(), panel, null, 0);
                } else if (panel.getClass() == TAB_CLASS[TAB_CLASS.length - 1]) {
                    this.m_tab.insertTab(panel.getTabTitle(), panel.getIcon(), panel, null, this.m_tab.getTabCount());
                } else {
                    Class findClass = null;
                    for (int i = 1; i < TAB_CLASS.length - 2; ++i) {
                        if (panel.getClass() != TAB_CLASS[i]) continue;
                        findClass = TAB_CLASS[i + 1];
                        break;
                    }
                    int findIndex = 0;
                    for (int j = 0; j < this.m_tab.getTabCount(); ++j) {
                        Component tabPanel = this.m_tab.getComponentAt(j);
                        if (tabPanel.getClass() != findClass) continue;
                        findIndex = j;
                        break;
                    }
                    this.m_tab.insertTab(panel.getTabTitle(), panel.getIcon(), panel, null, findIndex);
                }
            }
        } else if (index >= 0) {
            this.m_tab.remove(index);
        }
    }

    class JMonitorTabbedPane
    extends JTabbedPane {
        public JMonitorTabbedPane(int tabPlacement) {
            super(tabPlacement);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.getTabCount() == 0) {
                JLabel label = new JLabel("No options");
                label.setSize((int)g.getClipBounds().getWidth(), (int)g.getClipBounds().getHeight());
                label.setHorizontalAlignment(0);
                label.paint(g);
            }
        }
    }
}

