/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime;

import com.sonicsw.ma.gui.runtime.ViewLogInternalFrame;
import com.sonicsw.ma.gui.runtime.propsheets.JRuntimeDialog;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

class LogPreferencesDialog
extends JRuntimeDialog {
    private JTextField maxBufferSizeTextField = null;
    private JTextField retrieveSizeTextField = null;
    private ViewLogInternalFrame frame = null;

    public LogPreferencesDialog(ViewLogInternalFrame frame) {
        super((JMAFrame)JOptionPane.getFrameForComponent(frame), "viewlog.preferences");
        this.frame = frame;
    }

    private int validateBufferSize(String maxSize, String retrieveSize) {
        try {
            long maxSizeValue = Long.parseLong(maxSize);
            long retrieveSizeValue = Long.parseLong(retrieveSize);
            if (maxSizeValue < 200L || maxSizeValue > 1000L) {
                JOptionPane.showMessageDialog(this, "Max Buffer Size cannot be less than 200 Kbytes and greater than 1000 Kbytes", "Input Error", 0);
                return 1;
            }
            if (retrieveSizeValue < 200L || retrieveSizeValue > 1000L) {
                JOptionPane.showMessageDialog(this, "Retrieve Size should be between 200 Kbytes and 1000 Kbytes", "Input Error", 0);
                return 1;
            }
            if (maxSizeValue < retrieveSizeValue) {
                JOptionPane.showMessageDialog(this, "Retrieve Size cannot be more than Max Buffer Size", "Input Error", 0);
                return 1;
            }
            this.frame.setReadLength(retrieveSizeValue * 1024L);
            this.frame.setMaxBuffer(maxSizeValue * 1024L);
            this.frame.setLogText(retrieveSizeValue * 1024L);
            return 0;
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Enter a Valid Size Value in Kb.", "Input Error", 0);
            return 1;
        }
    }

    public void setPreferences() {
        this.frame.getP_manager().setString("preferences.log", "readLength", String.valueOf(this.frame.getReadLength()), true);
        this.frame.getP_manager().setString("preferences.log", "maxBuffer", String.valueOf(this.frame.getMaxBuffer()), true);
    }

    @Override
    public BasicAction getDefaultOKAction() {
        return new OkAction();
    }

    @Override
    protected void initForm() throws Exception {
    }

    @Override
    protected void initUI() throws Exception {
        JPartitionPanel panel = new JPartitionPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Log Preferences"));
        this.maxBufferSizeTextField = new JTextField(20);
        this.retrieveSizeTextField = new JTextField(20);
        this.maxBufferSizeTextField.setText(new Long(this.frame.getMaxBuffer() / 1024L).toString());
        this.retrieveSizeTextField.setText(new Long(this.frame.getReadLength() / 1024L).toString());
        panel.addRow("Max Viewer Buffer Size", (JComponent)this.maxBufferSizeTextField, " Kbytes");
        panel.addRow("Retrieve Size", (JComponent)this.retrieveSizeTextField, " Kbytes");
        super.getContentPane().add(JPartitionPanel.wrap(panel));
    }

    public class OkAction
    extends BasicGuiAction {
        public OkAction() {
            super("dialog.ok");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int ret = LogPreferencesDialog.this.validateBufferSize(LogPreferencesDialog.this.maxBufferSizeTextField.getText(), LogPreferencesDialog.this.retrieveSizeTextField.getText());
            if (ret == 0) {
                LogPreferencesDialog.this.setPreferences();
                LogPreferencesDialog.this.dispose();
            }
        }
    }
}

