/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime;

import com.sonicsw.ma.gui.runtime.ViewLogInternalFrame;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class LogViewerSlider
extends JSlider
implements ChangeListener,
MouseListener,
MouseMotionListener {
    final JPopupMenu pop = new JPopupMenu();
    JPanel parent;
    ViewLogInternalFrame frame = null;
    JTextArea toolTipText = new JTextArea();

    public LogViewerSlider(ViewLogInternalFrame frame) {
        super(0);
        this.prepareLogViewSlider(frame);
    }

    private void prepareLogViewSlider(ViewLogInternalFrame frame) {
        this.frame = frame;
        this.setMaximum(frame.getLogFileSize());
        this.setMinimum(0);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addChangeListener(this);
        this.toolTipText.setEditable(false);
        this.setToolTipText(0);
        this.pop.add(this.toolTipText);
        this.pop.setDoubleBuffered(true);
    }

    public void setToolTipText(int sliderValue) {
        int maxValue = this.frame.getLogFileSize();
        if (maxValue <= 0) {
            this.toolTipText.setText("");
            return;
        }
        float logPercent = 0.0f;
        logPercent = (long)(maxValue - sliderValue) > this.frame.getReadLength() ? (float)(this.frame.getReadLength() * 100L / (long)maxValue) : (sliderValue == 0 ? 100.0f : (float)((maxValue - sliderValue) * 100 / maxValue));
        maxValue = maxValue == 0 ? maxValue : maxValue / 1024;
        sliderValue = sliderValue == 0 ? sliderValue : sliderValue / 1024;
        this.toolTipText.setText(Math.ceil(logPercent) + "% of log in view");
        this.toolTipText.append("\nLog Size is " + maxValue + " Kbytes");
        this.toolTipText.append("\nViewing from " + sliderValue + " Kbytes");
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider slider = (JSlider)e.getSource();
        this.setToolTipText(slider.getValue());
        if (!slider.getValueIsAdjusting()) {
            this.frame.setLogText(this.frame.getReadLength());
        }
    }

    public void showToolTip(MouseEvent me) {
        this.pop.show(me.getComponent(), me.getX() - 5, -30);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.showToolTip(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.pop.setVisible(false);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.showToolTip(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

