/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.plugin.IRuntimePlugin;
import com.sonicsw.mf.common.runtime.IComponentState;
import com.sonicsw.mf.common.runtime.IContainerState;
import com.sonicsw.mf.common.runtime.IState;
import com.sonicsw.mf.common.runtime.impl.RemoteCallResult;
import java.awt.event.ActionEvent;

public class RuntimeAction
extends BasicGuiAction {
    protected IRuntimePlugin m_plugin;
    protected String m_prompt;
    protected String m_action;
    protected int m_timeoutFactor;

    public RuntimeAction(IRuntimePlugin plugin, String name, String action) {
        this(plugin, name, action, null);
    }

    public RuntimeAction(IRuntimePlugin plugin, String name, String action, String prompt) {
        this(plugin, name, action, prompt, -1);
    }

    public RuntimeAction(IRuntimePlugin plugin, String name, String action, String prompt, int timeoutFactor) {
        super(name);
        this.m_plugin = plugin;
        this.m_prompt = prompt;
        this.m_action = action;
        this.m_timeoutFactor = timeoutFactor;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int ok = 0;
        if (this.m_prompt != null) {
            ok = MgmtConsole.getMgmtConsole().showConfirmDialog(this.m_prompt, "Perform operation", 3, 0);
        }
        if (ok == 0) {
            this.invokeAction();
        }
    }

    @Override
    public boolean isEnabled() {
        boolean res = true;
        IState state = this.m_plugin.getAttributes().getState();
        if (state == null) {
            res = false;
        } else {
            if (state instanceof IContainerState) {
                if (this.m_action.equals("start") && state.getState() == 3) {
                    res = false;
                }
                if (this.m_action.equals("stop") && state.getState() == 1) {
                    res = false;
                }
            }
            if (state instanceof IComponentState) {
                if (this.m_action.equals("start") && state.getState() == 3) {
                    res = false;
                }
                if (this.m_action.equals("stop") && state.getState() == 1) {
                    res = false;
                }
            }
        }
        return res;
    }

    protected void invokeAction() {
        this.invokeAction(new Object[0], new String[0]);
    }

    protected void invokeAction(Object[] args, String[] sigs) {
        if (this.m_action == null) {
            System.err.println("RuntimeAction::invokeAction : Action not defined for " + this.getValue("Name"));
            return;
        }
        this.invokeAction(this.m_action, args, sigs, this.m_timeoutFactor);
    }

    protected void invokeAction(Object[] args, String[] sigs, int timeout) {
        if (this.m_action == null) {
            System.err.println("RuntimeAction::invokeAction : Action not defined for " + this.getValue("Name"));
            return;
        }
        this.invokeAction(this.m_action, args, sigs, timeout);
    }

    protected void invokeAction(String action, Object[] args, String[] sigs) {
        this.invokeAction(this.m_action, args, sigs, this.m_timeoutFactor);
    }

    protected void invokeAction(final String action, final Object[] args, final String[] sigs, final int timeout) {
        if (this.m_plugin == null) {
            System.err.println("RuntimeAction::invokeAction : Plugin not defined for " + this.getValue("Name"));
            return;
        }
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                RemoteCallResult ret = (RemoteCallResult)RuntimeAction.this.m_plugin.invokeAction(action, args, sigs, timeout);
                if (ret != null && !ret.isSuccessful()) {
                    MgmtConsole.getMgmtConsole();
                    MgmtConsole.displayMessage(0, ret.getOutput(), true);
                }
            }
        });
        th.start();
    }
}

