/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime;

import com.sonicsw.ma.gui.action.RuntimeClearLogAction;
import com.sonicsw.ma.gui.action.RuntimeSaveLogFileAction;
import com.sonicsw.ma.gui.domain.DomainConnectionModel;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.runtime.RuntimeDomainFolderDialog;
import com.sonicsw.ma.gui.runtime.RuntimeDomainFolderModel;
import com.sonicsw.ma.gui.runtime.RuntimeFolderPlugin;
import com.sonicsw.ma.gui.runtime.RuntimeViewLogAction;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JBasicMenu;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.plugin.IPluginContext;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSeparator;

public class RuntimeDomainFolderPlugin
extends RuntimeFolderPlugin {
    public static final String PLUGIN_NAME = "Managed Objects";
    public static final String PLUGIN_TYPE = "RuntimeDomain";
    public static final String DISPLAY_TYPE = "RuntimeDomain";
    private static final Object[][] ATTRIBUTES = new Object[][]{{"TYPE", "RuntimeDomain"}, {"SYSTEM", "true"}, {"DISPLAY_TYPE", "RuntimeDomain"}};
    private RuntimeDomainFolderModel m_model = null;

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public String getPluginPath() {
        return "/";
    }

    public RuntimeDomainFolderPlugin(IPluginContext context) {
        super(context, null, null);
        this.getAttributes().put(ATTRIBUTES);
    }

    @Override
    public void dispose() {
        this.m_model = null;
    }

    @Override
    protected JComponent[] getSystemMenuItems() {
        JComponent[] compMenuItems = super.getSystemMenuItems();
        JBasicMenu logMenu = new JBasicMenu(new LogAction("runtime.log.central"));
        JComponent[] ops = this.getLogMenuItems();
        for (int i = 0; i < ops.length; ++i) {
            ((Container)logMenu).add(ops[i]);
        }
        return Helper.combineMenu(compMenuItems, new JComponent[]{new JSeparator(), logMenu}, false);
    }

    protected JComponent[] getLogMenuItems() {
        ArrayList<JBasicMenuItem> list = new ArrayList<JBasicMenuItem>();
        list.add(new JBasicMenuItem(new RuntimeViewLogAction(this)));
        list.add(new JBasicMenuItem(new RuntimeClearLogAction(this)));
        list.add(new JBasicMenuItem(new RuntimeSaveLogFileAction(this)));
        return list.toArray(new JComponent[list.size()]);
    }

    @Override
    public JPropSheetDialog getPropSheetDialog() {
        return new RuntimeDomainFolderDialog(this.getPluginContext().getMgmtConsole());
    }

    @Override
    public Object getModel() {
        if (this.m_model == null) {
            this.m_model = new RuntimeDomainFolderModel(this, this.getPluginContext());
        }
        return this.m_model;
    }

    @Override
    public List getToolTipList() {
        DomainConnectionModel model = this.getPluginContext().getConnectionInfo();
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.formatToolTipText("Connection", model.getConnectionName()));
        list.add(this.formatToolTipText("Domain", model.getDomainName()));
        list.add(this.formatToolTipText("URL", model.getUrl()));
        String userName = model.getUserName();
        if (userName != null && userName.trim().length() > 0) {
            list.add(this.formatToolTipText("User Name", userName));
        }
        return list;
    }

    private class LogAction
    extends BasicGuiAction {
        public LogAction(String resId) {
            super(resId);
        }
    }
}

