/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.action.FolderPluginExpandAction;
import com.sonicsw.ma.gui.file.FileFolderDialog;
import com.sonicsw.ma.gui.file.FileFolderPluginModel;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.runtime.AbstractRuntimePlugin;
import com.sonicsw.ma.gui.runtime.RuntimeFolderContentPane;
import com.sonicsw.ma.gui.table.IContentPane;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.IRuntimePluginFactory;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mx.config.IConfigServer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JProgressBar;

public class RuntimeFolderPlugin
extends AbstractRuntimePlugin {
    private static final String DISPLAY_TYPE = "Folder";
    private static final Object[][] ATTRIBUTES = new Object[][]{{"DISPLAY_TYPE", "Folder"}, {"CHILD_BEARING", Boolean.TRUE}};
    private FileFolderPluginModel m_model = null;

    public RuntimeFolderPlugin(IPluginContext context, String name, Map data) {
        super(context, name, data);
        this.getAttributes().put(ATTRIBUTES);
    }

    @Override
    public void dispose() {
        this.m_model = null;
    }

    @Override
    public BasicAction getDefaultAction() {
        return new FolderPluginExpandAction(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean expand() {
        JProgressBar bar = MgmtConsole.getMgmtConsole().getStatusBar().getProgressBar();
        try {
            String path = this.getPluginPath();
            IConfigServer server = this.getPluginContext().getConfigContext().getConfigServer();
            Set childSet = server.list(path);
            Iterator i = childSet != null ? childSet.iterator() : null;
            int nPluginCount = childSet != null ? childSet.size() : 0;
            int nCount = 0;
            if (bar != null) {
                bar.setMinimum(0);
                bar.setMaximum(nPluginCount);
                bar.setVisible(true);
            }
            while (i != null && i.hasNext()) {
                HashMap row = (HashMap)i.next();
                MgmtConsole.getMgmtConsole().notifyMessage(0, "Loading runtime element " + ++nCount + " of " + nPluginCount, null, false);
                if (bar != null) {
                    bar.setValue(nCount);
                }
                this.addChildPlugin(this.createChildPlugin(null, row), row);
            }
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "RuntimeFolderPlugin::expand failed", e, false);
        }
        finally {
            if (bar != null) {
                bar.setVisible(false);
                MgmtConsole.getMgmtConsole().getStatusBar().releaseProgressBar();
            }
        }
        return true;
    }

    @Override
    protected IPlugin createChildPlugin(String strName, Map metaAttributes) {
        IPlugin plugin = null;
        String metaName = null;
        String fullName = null;
        boolean isFolder = false;
        try {
            if (metaAttributes.containsKey("_FOLDER_NAME")) {
                String folderName = (String)metaAttributes.remove("_FOLDER_NAME");
                int folderIndex = folderName.lastIndexOf(47);
                metaName = folderName.substring(folderIndex + 1);
                isFolder = true;
            } else if (metaAttributes.containsKey("_ELEMENT_IDENTITY")) {
                IElementIdentity eId = (IElementIdentity)metaAttributes.remove("_ELEMENT_IDENTITY");
                String[] comp = eId.getNameComponents();
                metaName = comp[comp.length - 1];
                fullName = eId.getName();
            } else {
                return null;
            }
            if (metaAttributes.containsKey("TYPE")) {
                String type = (String)metaAttributes.get("TYPE");
                String cVersion = (String)metaAttributes.get("CONFIG_VERSION");
                String pVersion = (String)metaAttributes.get("PRODUCT_VERSION");
                IRuntimePluginFactory factory = this.getPluginContext().getRuntimeContext().getPluginFactory(type, cVersion, pVersion);
                if (factory != null && factory.getAttributes().isRuntimeRoot()) {
                    Helper.logDebugMessage("RuntimeFolderPlugin::createChildPlugin(" + metaName + " " + type + " c=" + cVersion + " p=" + pVersion + ")");
                    metaAttributes.put("STATE", this.getPluginContext().getConnectionInfo().getAgentManagerConnection().getContainerStateByLogicalName(fullName));
                    plugin = factory.createPlugin(this.getPluginContext(), metaName, pVersion, metaAttributes);
                }
            } else if (isFolder) {
                plugin = new RuntimeFolderPlugin(this.getPluginContext(), metaName, metaAttributes);
            }
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "RuntimeFolderPlugin::createChildPlugin failed", e, false);
        }
        return plugin;
    }

    @Override
    protected IContentPane createReadablePluginContentPane() {
        return new RuntimeFolderContentPane(this);
    }

    @Override
    protected boolean isReadDeniable() {
        return true;
    }

    @Override
    public JPropSheetDialog getPropSheetDialog() {
        return new FileFolderDialog(MgmtConsole.getMgmtConsole(), this.getPluginName());
    }

    @Override
    public Object getModel() {
        if (this.m_model == null) {
            this.m_model = new FileFolderPluginModel(this);
        }
        return this.m_model;
    }
}

