/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.PreferenceManager;
import com.sonicsw.ma.gui.action.RuntimeClearLogAction;
import com.sonicsw.ma.gui.domain.DomainConnectionModel;
import com.sonicsw.ma.gui.runtime.AbstractRuntimePlugin;
import com.sonicsw.ma.gui.runtime.ComponentPlugin;
import com.sonicsw.ma.gui.runtime.FindToolBar;
import com.sonicsw.ma.gui.runtime.LogViewerSlider;
import com.sonicsw.ma.gui.runtime.PreferencesAction;
import com.sonicsw.ma.gui.runtime.RuntimeAction;
import com.sonicsw.ma.gui.runtime.RuntimeDomainFolderPlugin;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.BasicResourceAction;
import com.sonicsw.ma.gui.util.JMAInternalFrame;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IRuntimePlugin;
import com.sonicsw.mf.mgmtapi.runtime.IAgentManagerProxy;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.management.openmbean.CompositeData;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import modelobjects.layout.PartitionLayout;

public class ViewLogInternalFrame
extends JMAInternalFrame {
    private JScrollPane viewLogScrollpanel = null;
    private JTextArea logTextArea = null;
    private JToolBar logToolBar = null;
    private AbstractRuntimePlugin plugin = null;
    private long readLength;
    private long maxBuffer;
    private Action copyAction = null;
    private Action findAction = null;
    private Action findAgainAction = null;
    private FindToolBar findToolBar = null;
    private BasicResourceAction clearLogAction = null;
    private LogViewerSlider rangeSlider = null;
    private PreferenceManager p_manager = null;
    private RefreshAction refreshAction = null;
    public static final String KB = " Kbytes";
    public static final String LOG_PREFERENCES = "preferences.log";
    private int logFileSize = 0;

    public ViewLogInternalFrame(AbstractRuntimePlugin plugin) {
        super("viewlog");
        this.plugin = plugin;
        this.p_manager = PreferenceManager.getInstance();
        this.readLength = new Long(this.p_manager.getString(LOG_PREFERENCES, "readLength", String.valueOf(204800)));
        this.maxBuffer = new Long(this.p_manager.getString(LOG_PREFERENCES, "maxBuffer", String.valueOf(512000)));
        this.setTitleProperty();
        this.setFrameIcon();
    }

    private void setTitleProperty() {
        StringBuffer title1 = new StringBuffer();
        title1.append(ResourceManager.getString(this.getClass(), "iframe.viewlog.title"));
        if (this.plugin instanceof RuntimeDomainFolderPlugin) {
            title1.append(" - ").append(ResourceManager.getString(this.getClass(), "iframe.viewcentrallog.title"));
        } else {
            String path;
            String string = path = this.plugin != null ? this.plugin.getPluginPath() : null;
            if (path != null && path.trim().length() > 0) {
                title1.append(" - ").append(path);
            }
        }
        this.setTitle(title1.toString());
    }

    private void setFrameIcon() {
        this.setFrameIcon(ResourceManager.getApplicationIcon(this.getClass(), "Application18", 18));
    }

    public String getPluginName() {
        return this.plugin.getPluginName();
    }

    public long getReadLength() {
        return this.readLength;
    }

    public void setReadLength(long readLength) {
        this.readLength = readLength;
    }

    public long getMaxBuffer() {
        return this.maxBuffer;
    }

    public void setMaxBuffer(long maxBuffer) {
        this.maxBuffer = maxBuffer;
    }

    public void setLogText(long retrieveLength) {
        if (this.plugin instanceof ComponentPlugin && this.plugin.getState().getState() != 3) {
            this.logTextArea.setText("<Container might be offline.>");
            this.logFileSize = -1;
            return;
        }
        long fromSize = this.rangeSlider.getValue();
        if (this.plugin instanceof ComponentPlugin) {
            CompositeData data = (CompositeData)this.plugin.invokeAction("getLogExtractAndLogFileSize", new Object[]{new Long(fromSize), new Long(retrieveLength)}, new String[]{Long.class.getName(), Long.class.getName()});
            this.logTextArea.setText((String)data.get("LogExtract"));
            this.logFileSize = (int)((Long)data.get("LogFileSize")).longValue();
        } else {
            DomainConnectionModel domainModel = this.plugin.getPluginContext().getConnectionInfo();
            IAgentManagerProxy agentManager = domainModel.getAgentManager();
            this.logTextArea.setText(agentManager.getLogExtract(new Long(fromSize), new Long(retrieveLength)));
            this.logFileSize = (int)agentManager.getLogFileSize().longValue();
        }
        this.rangeSlider.setMaximum(this.logFileSize);
        this.findToolBar.resetCounters();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewLogInternalFrame.this.logTextArea.requestFocus();
            }
        });
    }

    public int getLogFileSize() {
        return this.logFileSize;
    }

    public void disableCopyAction() {
        if (this.logTextArea.getSelectedText() == null) {
            this.copyAction.setEnabled(false);
        } else {
            this.copyAction.setEnabled(true);
        }
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.add(this.clearLogAction);
        toolBar.add(this.refreshAction);
        toolBar.addSeparator();
        toolBar.add(this.createFindAction());
        toolBar.add(this.createFindAgainAction());
        toolBar.addSeparator();
        toolBar.add(new PreferencesAction(this));
        return toolBar;
    }

    public Action createCopyAction() {
        this.copyAction = this.logTextArea.getActionMap().get("copy-to-clipboard");
        KeyStroke copyKeyStroke = KeyStroke.getKeyStroke(67, 2);
        try {
            this.copyAction.putValue("AcceleratorKey", copyKeyStroke);
            this.copyAction.putValue("Name", "Copy");
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        return this.copyAction;
    }

    public Action createSelectAllAction() {
        Action selectAllAction = this.logTextArea.getActionMap().get("select-all");
        selectAllAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, 2));
        selectAllAction.putValue("Name", "Select All");
        selectAllAction.setEnabled(true);
        return selectAllAction;
    }

    public Action createFindAction() {
        this.findAction = new BasicGuiAction("ContainerPlugin.viewlog.find"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewLogInternalFrame.this.findToolBar.setVisible(true);
                ViewLogInternalFrame.this.findToolBar.setFocus();
            }
        };
        this.findAction.putValue("MnemonicKey", new Integer(70));
        KeyStroke key = KeyStroke.getKeyStroke(70, 2);
        this.findAction.putValue("AcceleratorKey", key);
        this.logTextArea.getInputMap(2).put(key, this.findAction);
        this.logTextArea.getActionMap().put("findAction", this.findAction);
        return this.findAction;
    }

    public Action createFindAgainAction() {
        this.findAgainAction = new BasicGuiAction("ContainerPlugin.viewlog.findagain"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewLogInternalFrame.this.findToolBar.setVisible(true);
                ViewLogInternalFrame.this.findToolBar.setFocus();
                ViewLogInternalFrame.this.searchNext();
            }
        };
        this.findAgainAction.putValue("MnemonicKey", new Integer(71));
        KeyStroke key = KeyStroke.getKeyStroke(71, 2);
        this.findAgainAction.putValue("AcceleratorKey", key);
        this.logTextArea.getInputMap(2).put(key, this.findAgainAction);
        this.logTextArea.getActionMap().put("findAgainAction", this.findAgainAction);
        return this.findAgainAction;
    }

    public int searchString() {
        String searchStr = this.findToolBar.getFindString();
        boolean matchCase = this.findToolBar.getMatchCase();
        int ret = 0;
        this.logTextArea.getCaret().setSelectionVisible(true);
        int startIndex = matchCase ? this.logTextArea.getText().indexOf(searchStr) : this.logTextArea.getText().toLowerCase().indexOf(searchStr.toLowerCase());
        if (startIndex != -1) {
            this.logTextArea.select(startIndex, startIndex + searchStr.length());
        } else {
            this.logTextArea.getCaret().setSelectionVisible(false);
            ret = -1;
        }
        return ret;
    }

    public int searchNext() {
        String searchStr = this.findToolBar.getFindString();
        boolean matchCase = this.findToolBar.getMatchCase();
        int pos = this.logTextArea.getCaretPosition();
        int startIndex = 0;
        startIndex = matchCase ? this.logTextArea.getText().indexOf(searchStr, pos) : this.logTextArea.getText().toLowerCase().indexOf(searchStr.toLowerCase(), pos);
        if (startIndex != -1) {
            this.logTextArea.select(startIndex, startIndex + searchStr.length());
            this.logTextArea.getCaret().setSelectionVisible(true);
        }
        return startIndex;
    }

    public int searchPrevious() {
        String searchStr = this.findToolBar.getFindString();
        boolean matchCase = this.findToolBar.getMatchCase();
        int pos = this.logTextArea.getCaretPosition();
        int wordStart = pos - searchStr.length();
        int startIndex = 0;
        if (matchCase) {
            pos = this.logTextArea.getText().substring(wordStart, pos).equals(searchStr) ? wordStart - 1 : pos;
            startIndex = this.logTextArea.getText().lastIndexOf(searchStr, pos);
        } else {
            pos = this.logTextArea.getText().substring(wordStart, pos).equalsIgnoreCase(searchStr) ? wordStart - 1 : pos;
            startIndex = this.logTextArea.getText().toLowerCase().lastIndexOf(searchStr.toLowerCase(), pos);
        }
        if (startIndex != -1) {
            this.logTextArea.select(startIndex, startIndex + searchStr.length());
            this.logTextArea.getCaret().setSelectionVisible(true);
        }
        return startIndex;
    }

    public String getSelectedText() {
        return this.logTextArea.getSelectedText() != null ? this.logTextArea.getSelectedText() : "";
    }

    public PreferenceManager getP_manager() {
        return this.p_manager;
    }

    @Override
    protected void maCleanup() {
    }

    @Override
    protected void maInitialize() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new PartitionLayout(true, "p,r,p,p", 0));
        this.clearLogAction = this.plugin instanceof RuntimeDomainFolderPlugin ? new CentralLogClearLogAction(this.plugin) : new ClearLogAction(this.plugin);
        this.clearLogAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, 2));
        this.refreshAction = new RefreshAction(this.plugin);
        this.logTextArea = new JTextArea();
        this.logTextArea.setEditable(false);
        this.logTextArea.addMouseListener(new ReadOnlyListener(this));
        this.logTextArea.setMargin(new Insets(5, 5, 5, 5));
        this.logTextArea.getInputMap(2).put(KeyStroke.getKeyStroke(76, 2), this.clearLogAction);
        this.logTextArea.getInputMap(2).put(KeyStroke.getKeyStroke("F5"), this.refreshAction);
        this.logToolBar = this.createToolBar();
        contentPane.add(this.logToolBar);
        this.viewLogScrollpanel = new JScrollPane(this.logTextArea);
        this.rangeSlider = new LogViewerSlider(this);
        this.rangeSlider.setToolTipText("Drag the slider to extract log from a different position");
        this.findToolBar = new FindToolBar(this);
        this.findToolBar.setVisible(false);
        this.setLogText(this.getReadLength());
        contentPane.add(this.viewLogScrollpanel);
        contentPane.add(this.rangeSlider);
        contentPane.add(this.findToolBar);
    }

    class RefreshAction
    extends BasicGuiAction {
        public RefreshAction(IRuntimePlugin plugin) {
            super("ContainerPlugin.viewlog.refresh");
            this.putKeyProperty();
        }

        private void putKeyProperty() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F5"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ViewLogInternalFrame.this.setLogText(ViewLogInternalFrame.this.getReadLength());
        }
    }

    class CentralLogClearLogAction
    extends RuntimeClearLogAction {
        public CentralLogClearLogAction(AbstractRuntimePlugin plugin) {
            super(plugin);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            super.actionPerformed(evt);
            try {
                Thread.sleep(100L);
                ViewLogInternalFrame.this.rangeSlider.setValue(0);
                ViewLogInternalFrame.this.setLogText(ViewLogInternalFrame.this.getLogFileSize());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class ClearLogAction
    extends RuntimeAction {
        IRuntimePlugin plugin;

        public ClearLogAction(IRuntimePlugin plugin) {
            super(plugin, "ContainerPlugin.viewlog.clearlog", "clearLogFile", "Are you sure you want to clear the container log file?");
            this.plugin = null;
            this.plugin = plugin;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (this.plugin.getAttributes().getState().getState() != 3) {
                ViewLogInternalFrame.this.logTextArea.setText("<Container might be offline.>");
                ViewLogInternalFrame.this.logFileSize = -1;
                return;
            }
            super.actionPerformed(evt);
            try {
                Thread.sleep(100L);
                ViewLogInternalFrame.this.rangeSlider.setValue(0);
                ViewLogInternalFrame.this.setLogText(ViewLogInternalFrame.this.getLogFileSize());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class ReadOnlyListener
    extends MouseAdapter {
        ViewLogInternalFrame frame = null;
        ViewLogPopUpMenu popup = null;

        public ReadOnlyListener(ViewLogInternalFrame frame) {
            this.popup = new ViewLogPopUpMenu();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class ViewLogPopUpMenu
    extends JPopupMenu {
        public ViewLogPopUpMenu() {
            this.addProperties();
        }

        private void addProperties() {
            this.add(ViewLogInternalFrame.this.createCopyAction());
            this.add(ViewLogInternalFrame.this.createSelectAllAction());
            this.addSeparator();
            this.add(ViewLogInternalFrame.this.clearLogAction);
            this.add(ViewLogInternalFrame.this.refreshAction);
            this.addSeparator();
            this.add(ViewLogInternalFrame.this.createFindAction());
            this.add(ViewLogInternalFrame.this.createFindAgainAction());
            this.addSeparator();
            this.add(new PreferencesAction(ViewLogInternalFrame.this));
            this.addPopupMenuListener(new PopupListener());
        }

        class PopupListener
        implements PopupMenuListener {
            PopupListener() {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                ViewLogInternalFrame.this.disableCopyAction();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        }
    }
}

