/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.metrics;

import com.sonicsw.ma.gui.PreferenceManager;
import com.sonicsw.ma.gui.runtime.metrics.MetricValue;
import com.sonicsw.ma.gui.runtime.metrics.MetricsTable;
import com.sonicsw.ma.gui.runtime.metrics.MetricsWatchPanel;
import com.sonicsw.ma.gui.runtime.metrics.MetricsWatchWindow;
import com.sonicsw.ma.gui.runtime.metrics.model.AbstractMetricsModel;
import com.sonicsw.ma.gui.runtime.metrics.model.AggregateMetricsModel;
import com.sonicsw.ma.gui.runtime.metrics.model.AggregateValueUpdatedEvent;
import com.sonicsw.ma.gui.runtime.metrics.model.IValueUpdatedEvent;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.ModelListTableModel;
import com.sonicsw.ma.gui.table.RowTableColumn;
import com.sonicsw.ma.gui.util.ColorIcon;
import com.sonicsw.ma.gui.util.ExtendedJTable;
import com.sonicsw.ma.gui.util.JRowTable;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.ObjectName;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.table.TableColumn;

public class AggregateMetricsWatchWindow
extends MetricsWatchWindow {
    public static final String[] AGGREGATION_TYPE_TEXT = new String[]{"Total", "Average", "Maximum", "Minimum"};

    static AggregateMetricsWatchWindow getWatchWindow(ObjectName scopeName) {
        CanonicalName cname = new CanonicalName(scopeName.toString());
        String name = cname.getCanonicalName();
        AggregateMetricsWatchWindow window = (AggregateMetricsWatchWindow)m_watchWindows.get(name);
        if (window == null) {
            window = new AggregateMetricsWatchWindow(name);
            m_watchWindows.put(name, window);
        }
        return window;
    }

    public AggregateMetricsWatchWindow(String scopeID) {
        super((short)0, scopeID);
        this.prepareObject(scopeID);
    }

    private void prepareObject(String scopeID) {
        this.setTitle(this.getTitle());
        this.setFrameIcon(ResourceManager.getIcon(this.getClass(), "linechart"));
        this.m_scopeID = scopeID;
        this.m_panelMetrics = new AggregateMetricsWatchPanel(this.getWatchScope());
        this.getContentPane().add(this.m_panelMetrics);
    }

    private class AggregateMetricValue
    extends MetricValue {
        private String[] m_sources;
        private String m_collectionID;
        private short m_type;

        public AggregateMetricValue(ObjectName nameSource, String collectionID, IMetricIdentity metric, short type) {
            super(nameSource, metric);
            this.m_sources = new String[0];
            this.m_collectionID = collectionID;
            this.m_type = type;
        }

        @Override
        public String getMetricDescription() {
            return super.getMetricDescription() + " (" + this.getAggregationStringType() + ")";
        }

        public String getCollectionID() {
            return this.m_collectionID;
        }

        private void setSources(String[] sources) {
            this.m_sources = sources;
        }

        private String[] getSources() {
            return this.m_sources;
        }

        private Integer getSourcesCount() {
            int count = this.m_sources.length == 0 ? 0 : this.m_sources.length;
            return new Integer(count);
        }

        private Short getAggregationType() {
            return new Short(this.m_type);
        }

        private String getAggregationStringType() {
            return AGGREGATION_TYPE_TEXT[this.m_type];
        }
    }

    public class AggregateMetricsTable
    extends MetricsTable {
        public AggregateMetricsTable(AggregateMetricsWatchPanel panelParent, short nScope) {
            super(panelParent, nScope);
        }

        @Override
        protected void createGUI(short nScope) {
            TableColumn[] tableColumns = new TableColumn[]{new MetricsTable.MetricColumn(this, 0, "Metric", 30), new SourcesColumn(1, "Sources", 10), new TypesColumn(2, "Aggregation Type", 20), new MetricsTable.ValueColumn(this, 3, "Value", 20), new MetricsTable.CurrencyColumn(this, 4, "Date & Time", 20)};
            this.m_table = new JRowTable(tableColumns, this.getClass().getName());
            this.m_table.setSelectionMode(2);
            this.m_table.setDefaultRenderer(Object.class, new AggregateMetricsTableCellRenderer());
        }

        public class AggregateMetricsTableCellRenderer
        extends ExtendedJTable.ExtendedTableCellRenderer {
            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel result = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (column == 0) {
                    ModelListTableModel model = (ModelListTableModel)((JRowTable)table).getModel();
                    AggregateMetricValue metricValue = (AggregateMetricValue)model.getRowModel(row);
                    result.setIcon(new ColorIcon(metricValue.getColorId(), 14));
                } else {
                    result.setIcon(null);
                }
                return result;
            }
        }

        private class SourcesColumn
        extends RowTableColumn {
            SourcesColumn(int modelIndex, String name, int width) {
                super(modelIndex, name, width);
            }

            @Override
            public Object getColumnValue(Object rowModel) {
                return ((AggregateMetricValue)rowModel).getSourcesCount();
            }
        }

        private class TypesColumn
        extends RowTableColumn {
            TypesColumn(int modelIndex, String name, int width) {
                super(modelIndex, name, width);
            }

            @Override
            public Object getColumnValue(Object rowModel) {
                return ((AggregateMetricValue)rowModel).getAggregationStringType();
            }
        }
    }

    public class AggregateMetricsWatchPanel
    extends MetricsWatchPanel {
        public AggregateMetricsWatchPanel(short scope) {
            super(scope);
        }

        @Override
        protected MetricsTable createTable(short scope) {
            return new AggregateMetricsTable(this, scope);
        }

        @Override
        protected void maInitialize() {
            PreferenceManager pManager = PreferenceManager.getInstance();
            this.m_pollFrequency = pManager.getInt("preferences.metrics", "aggrPollFrequencySecs", 60);
            ToolTipManager.sharedInstance().registerComponent(this.m_table);
        }

        @Override
        protected void createGui(short scope) {
            super.createGui(scope);
            this.m_chartBar.setElevatedAndRotated(true);
        }

        @Override
        protected void maCleanup() {
            for (Map.Entry entry : this.m_subscriptions.entrySet()) {
                String collectionID = (String)entry.getKey();
                HashMap map = (HashMap)entry.getValue();
                AggregateMetricsModel model = (AggregateMetricsModel)((Object[])this.m_modelMap.get(collectionID))[0];
                Iterator metricIds = map.keySet().iterator();
                while (metricIds.hasNext()) {
                    model.removeValueListener((IMetricIdentity)metricIds.next(), this);
                }
                map.clear();
            }
            this.m_subscriptions.clear();
            this.m_modelMap.clear();
            MetricsWatchWindow.m_watchWindows.remove(AggregateMetricsWatchWindow.this.m_scopeID);
            ToolTipManager.sharedInstance().unregisterComponent(this.m_table);
        }

        @Override
        public void addWatch(IMetricIdentity metricId, AbstractMetricsModel metricsModel) {
            HashMap<String, AggregateMetricValue> types;
            ObjectName componentName = metricsModel.getComponentName();
            String collectionID = ((AggregateMetricsModel)metricsModel).getCollectionConfigID();
            HashMap metricValues = (HashMap)this.m_subscriptions.get(collectionID);
            if (metricValues == null) {
                metricValues = new HashMap();
                this.m_subscriptions.put(collectionID, metricValues);
            }
            if ((types = (HashMap<String, AggregateMetricValue>)metricValues.get(metricId)) == null) {
                types = new HashMap<String, AggregateMetricValue>(4);
                Object[] modelUsage = (Object[])this.m_modelMap.get(collectionID);
                if (modelUsage == null) {
                    modelUsage = new Object[]{metricsModel, new int[]{0}};
                    this.m_modelMap.put(collectionID, modelUsage);
                }
                int[] nArray = (int[])modelUsage[1];
                nArray[0] = nArray[0] + 1;
                for (int i = 0; i < AGGREGATION_TYPE_TEXT.length; ++i) {
                    short type = new Integer(i).shortValue();
                    AggregateMetricValue metricValue = new AggregateMetricValue(componentName, collectionID, metricId, type);
                    metricValue.setColorId(this.m_colors.getNextColor());
                    types.put(AGGREGATION_TYPE_TEXT[i], metricValue);
                    ((IModelTableModel)this.m_table.getModel()).addRow(metricValue);
                    this.m_chartLine.add(metricValue);
                    this.m_chartBar.add(metricValue);
                }
                metricValues.put(metricId, types);
                metricsModel.addValueListener(metricId, this);
            } else {
                if (types.size() == AGGREGATION_TYPE_TEXT.length) {
                    return;
                }
                for (int i = 0; i < AGGREGATION_TYPE_TEXT.length; ++i) {
                    if (types.containsKey(AGGREGATION_TYPE_TEXT[i])) continue;
                    short type = new Integer(i).shortValue();
                    AggregateMetricValue metricValue = new AggregateMetricValue(componentName, collectionID, metricId, type);
                    metricValue.setColorId(this.m_colors.getNextColor());
                    types.put(AGGREGATION_TYPE_TEXT[i], metricValue);
                    ((IModelTableModel)this.m_table.getModel()).addRow(metricValue);
                    this.m_chartLine.add(metricValue);
                    this.m_chartBar.add(metricValue);
                }
            }
        }

        @Override
        public void valueUpdated(IValueUpdatedEvent vue) {
            HashMap types;
            AggregateValueUpdatedEvent avue = (AggregateValueUpdatedEvent)vue;
            HashMap metricValues = (HashMap)this.m_subscriptions.get(avue.getCollectionID());
            if (metricValues != null && (types = (HashMap)metricValues.get(vue.getMetricId())) != null) {
                long[] results = avue.getValues();
                Iterator i = types.keySet().iterator();
                while (i.hasNext()) {
                    AggregateMetricValue metricValue = (AggregateMetricValue)types.get(i.next());
                    int rowIndex = ((IModelTableModel)this.m_table.getModel()).getIndexOf(metricValue);
                    int typeIndex = metricValue.getAggregationType().intValue();
                    metricValue.setValue(results[typeIndex]);
                    metricValue.setCurrency(avue.getCurrencyTimestamp());
                    metricValue.setSources(avue.getSources());
                    if (rowIndex >= 0) {
                        ((ModelListTableModel)this.m_table.getModel()).rowChanged(rowIndex);
                    }
                    this.m_chartLine.update(metricValue);
                    this.m_chartBar.update();
                }
            }
        }

        @Override
        public void removeWatch(MetricValue[] metricValue) {
            for (int i = 0; i < metricValue.length; ++i) {
                if (metricValue[i] == null) continue;
                boolean isRemoved = false;
                String collectionID = ((AggregateMetricValue)metricValue[i]).getCollectionID();
                IMetricIdentity metricId = metricValue[i].getMetricIdentity();
                HashMap metricValues = (HashMap)this.m_subscriptions.get(collectionID);
                String type = ((AggregateMetricValue)metricValue[i]).getAggregationStringType();
                HashMap types = (HashMap)metricValues.get(metricId);
                types.remove(type);
                if (types.isEmpty()) {
                    metricValues.remove(metricId);
                    isRemoved = true;
                }
                if (metricValues.isEmpty()) {
                    this.m_subscriptions.remove(collectionID);
                }
                if (isRemoved) {
                    Object[] modelUsage = (Object[])this.m_modelMap.get(collectionID);
                    AggregateMetricsModel metricsModel = (AggregateMetricsModel)modelUsage[0];
                    int[] nArray = (int[])modelUsage[1];
                    nArray[0] = nArray[0] - 1;
                    if (((int[])modelUsage[1])[0] == 0) {
                        this.m_modelMap.remove(collectionID);
                    }
                    metricsModel.removeValueListener(metricId, this);
                }
                this.m_chartLine.remove(metricValue[i]);
                this.m_chartBar.remove(metricValue[i]);
                ((IModelTableModel)this.m_table.getModel()).delete(metricValue[i]);
            }
        }

        @Override
        public void refreshWatch(MetricValue[] metricValue) {
            for (int i = 0; i < metricValue.length; ++i) {
                if (metricValue[i] == null) continue;
                String collectionID = ((AggregateMetricValue)metricValue[i]).getCollectionID();
                IMetricIdentity metricId = metricValue[i].getMetricIdentity();
                Object[] modelUsage = (Object[])this.m_modelMap.get(collectionID);
                AggregateMetricsModel metricsModel = (AggregateMetricsModel)modelUsage[0];
                metricsModel.refreshMetricValues(new IMetricIdentity[]{metricId});
            }
        }
    }
}

