/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.metrics;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.runtime.metrics.InstancePickSheet;
import com.sonicsw.ma.gui.runtime.metrics.model.InstanceParentNode;
import com.sonicsw.ma.gui.runtime.metrics.model.MetricsModel;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.RowTableColumn;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.JButtonPanel;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.JRowTable;
import com.sonicsw.ma.gui.util.ResourceManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

final class InstanceEnablementSheet
extends JMADialog {
    private static final String INSTANCE_ALL = "* (All Instances)";
    private static final String BANNER = "<html>The table below lists the currently enabled instance metrics:</html>";
    private MetricsModel m_model;
    private InstanceParentNode m_parentNode;
    private String[] m_enabledPatterns;
    private BasicAction m_removeAction = new RemoveAction();
    private BasicAction m_enableAction = new AllInstancesAction();
    private JRowTable m_table;

    public InstanceEnablementSheet(JMADialog parent, MetricsModel model, InstanceParentNode parentNode, String[] enabledPatterns) throws Exception {
        super(parent, "metrics.instance.enablement");
        this.m_model = model;
        this.m_parentNode = parentNode;
        this.m_enabledPatterns = enabledPatterns;
    }

    @Override
    public void maInitialize() {
        this.getContentPane().add(this.makeMainPanel());
        this.getOKButton().setEnabled(false);
        for (int i = 0; i < this.m_enabledPatterns.length; ++i) {
            String pattern = this.m_enabledPatterns[i];
            if (pattern.equals("*")) {
                pattern = INSTANCE_ALL;
            }
            ((IModelTableModel)this.m_table.getModel()).addRow(pattern);
        }
        this.enableButtons();
        this.initListeners();
    }

    @Override
    public void maCleanup() {
        if (this.m_table != null) {
            this.m_table.cleanup();
        }
    }

    @Override
    public Action[] getButtonActions() {
        return new Action[]{new OKAction(), this.getDefaultCancelAction()};
    }

    private JButton getOKButton() {
        return ((JButtonPanel)this.getButtonPanel()).getButton("dialog.ok");
    }

    public String[] getInstances() {
        String[] res = null;
        try {
            List instances = this.m_model.getInstances(this.m_parentNode);
            res = instances.toArray(new String[instances.size()]);
        }
        catch (Throwable e) {
            MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to get available instance identities", e, true);
            res = new String[]{};
        }
        return res;
    }

    private void initListeners() {
        this.m_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                InstanceEnablementSheet.this.enableButtons();
            }
        });
        ((IModelTableModel)this.m_table.getModel()).addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent evt) {
                InstanceEnablementSheet.this.getOKButton().setEnabled(true);
            }
        });
    }

    private JPanel makeBannerPanel() {
        JPartitionPanel panel = new JPartitionPanel(false, "p,r", null, 5, 0, 0);
        JLabel label = new JLabel(BANNER);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(2);
        panel.add(new JLabel(ResourceManager.getIcon(this.getClass(), "InstanceLarge")));
        panel.add(label);
        return panel;
    }

    private JPanel makeMainPanel() {
        JPartitionPanel panel = new JPartitionPanel(false, "r,p", null);
        this.m_table = new JRowTable(new RowTableColumn[]{new RowTableColumn(0, "Enabled Instance/Patterns", 100)}, this.getClass().getName());
        JButtonPanel btnPanel = new JButtonPanel(true, 5, 0, 0);
        btnPanel.addButton(new PickInstancesAction());
        btnPanel.addButton(this.m_removeAction);
        btnPanel.addSeparator();
        btnPanel.addButton(this.m_enableAction);
        panel.add(new ExtendedJScrollPane(this.m_table));
        panel.add(btnPanel);
        JPartitionPanel wrapPanel = new JPartitionPanel(true, "p,r", null);
        wrapPanel.setBorder(wrapPanel.getPreferredBorder());
        wrapPanel.add(this.makeBannerPanel());
        wrapPanel.add(panel);
        return wrapPanel;
    }

    private void enableButtons() {
        boolean enableAll = ((IModelTableModel)this.m_table.getModel()).getIndexOf(INSTANCE_ALL) < 0;
        this.m_removeAction.setEnabled(this.m_table.getSelectedRowCount() > 0);
        this.m_enableAction.setEnabled(enableAll);
    }

    public void addPattern(String pattern) {
        this.addPattern(new String[]{pattern});
    }

    public void addPattern(String[] pattern) {
        IModelTableModel tableModel = (IModelTableModel)this.m_table.getModel();
        if (pattern != null) {
            for (int i = 0; i < pattern.length; ++i) {
                if (pattern[i] == null) continue;
                String newPattern = pattern[i].trim();
                if (newPattern.equals("*")) {
                    newPattern = INSTANCE_ALL;
                }
                if (tableModel.findCell(0, 0, newPattern) >= 0) continue;
                tableModel.addRow(newPattern);
            }
        }
    }

    private void removePatterns() {
        int[] selected = this.m_table.getSelectedRows();
        int nextIndex = -1;
        if (selected.length > 0) {
            nextIndex = Integer.MAX_VALUE;
            for (int i = 0; i < selected.length; ++i) {
                if (selected[i] >= nextIndex) continue;
                nextIndex = selected[i];
            }
            nextIndex = Math.min(nextIndex, this.m_table.getRowCount() - 2);
        }
        IModelTableModel tableModel = (IModelTableModel)this.m_table.getModel();
        for (int i = selected.length - 1; i >= 0; --i) {
            tableModel.deleteRow(selected[i]);
        }
        if (nextIndex >= 0 && nextIndex < this.m_table.getRowCount()) {
            this.m_table.setRowSelectionInterval(nextIndex, nextIndex);
        }
    }

    private void applyPatternChanges() {
        int i;
        List contents = ((IModelTableModel)this.m_table.getModel()).getContents();
        if (contents.size() > 0 && contents.contains(INSTANCE_ALL)) {
            contents.remove(INSTANCE_ALL);
            contents.add("*");
        }
        Object[] patterns = contents.toArray();
        HashSet<Object> compare = new HashSet<Object>();
        for (int i2 = 0; i2 < this.m_enabledPatterns.length; ++i2) {
            compare.add(this.m_enabledPatterns[i2]);
        }
        ArrayList<Object> added = new ArrayList<Object>();
        for (i = 0; i < patterns.length; ++i) {
            if (compare.contains(patterns[i])) continue;
            added.add(patterns[i]);
        }
        compare.clear();
        for (i = 0; i < patterns.length; ++i) {
            compare.add(patterns[i]);
        }
        ArrayList<String> removed = new ArrayList<String>();
        for (int i3 = 0; i3 < this.m_enabledPatterns.length; ++i3) {
            if (compare.contains(this.m_enabledPatterns[i3])) continue;
            removed.add(this.m_enabledPatterns[i3]);
        }
        try {
            if (!added.isEmpty()) {
                this.m_model.enableInstancePatterns(this.m_parentNode, added);
            }
            if (!removed.isEmpty()) {
                this.m_model.disableInstancePatterns(this.m_parentNode, removed);
            }
        }
        catch (Throwable e) {
            MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to enable/disable instance(s)", e, true);
        }
    }

    private class AllInstancesAction
    extends BasicGuiAction {
        public AllInstancesAction() {
            super("InstanceEnablementSheet.add-all");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            InstanceEnablementSheet.this.addPattern("*");
        }
    }

    private class RemoveAction
    extends BasicGuiAction {
        public RemoveAction() {
            super("InstanceEnablementSheet.remove");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            InstanceEnablementSheet.this.removePatterns();
        }
    }

    private class PickInstancesAction
    extends BasicGuiAction {
        public PickInstancesAction() {
            super("InstanceEnablementSheet.add");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                InstancePickSheet dialog = new InstancePickSheet((JMADialog)InstanceEnablementSheet.this, InstanceEnablementSheet.this.m_model);
                dialog.setVisible(true);
            }
            catch (Throwable e) {
                MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to get/pick instance", e, true);
            }
        }
    }

    class OKAction
    extends BasicGuiAction {
        public OKAction() {
            super("dialog.ok", InstanceEnablementSheet.this.getDefaultOKAction());
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            InstanceEnablementSheet.this.applyPatternChanges();
            super.actionPerformed(evt);
        }
    }
}

