/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.metrics;

import com.sonicsw.ma.gui.runtime.metrics.InstanceEnablementSheet;
import com.sonicsw.ma.gui.runtime.metrics.model.MetricsModel;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.RowTableColumn;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.JButtonPanel;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.JRowTable;
import com.sonicsw.ma.plugin.IPlugin;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

final class InstancePickSheet
extends JMADialog {
    private static final String SYSTEM_INSTANCE = "sonicmq.";
    private static final String TYPE_BROKER = "MQ_BROKER";
    private static final String TEMP_INSTANCE = "$ISYS.USERS.TemporaryQueues";
    private JRowTable m_table;
    private JTextField m_tfPattern = new JTextField();
    private JRadioButton m_btnPattern = new JRadioButton("<html>By defining a pattern that matches one or more instances</html>");
    private JRadioButton m_btnAll = new JRadioButton("<html>Enable all instance metrics of this type</html>");
    private JRadioButton m_btnInstance = new JRadioButton("<html>Pick instance(s) that currently exist on the component...</html>");
    private JCheckBox m_showSystem = new JCheckBox("<html>Show System Instance<html>");
    private JCheckBox m_showTemp = new JCheckBox("<html>Show Temporary Queue Instances<html>");
    private MetricsModel m_model;

    public InstancePickSheet(JMADialog parent, MetricsModel m_model) {
        super(parent, "metrics.instance.pick");
        this.m_model = m_model;
    }

    private InstanceEnablementSheet getEnablementSheet() {
        return (InstanceEnablementSheet)this.getParent();
    }

    @Override
    public void maInitialize() {
        this.getContentPane().add(this.makePanel());
        this.refreshInstances();
    }

    @Override
    public void maCleanup() {
        if (this.m_table != null) {
            this.m_table.cleanup();
        }
    }

    @Override
    public Action[] getButtonActions() {
        return new Action[]{new OKAction(), this.getDefaultCancelAction()};
    }

    private void refreshInstances() {
        String[] iNames = this.getEnablementSheet().getInstances();
        IModelTableModel tableModel = (IModelTableModel)this.m_table.getModel();
        tableModel.clear();
        boolean isTemp = false;
        boolean isSystem = false;
        boolean canAdd = false;
        for (int i = 0; i < iNames.length; ++i) {
            String instanceName = iNames[i];
            isTemp = instanceName.startsWith(TEMP_INSTANCE);
            isSystem = instanceName.toLowerCase().startsWith(SYSTEM_INSTANCE);
            canAdd = false;
            if (isSystem) {
                if (this.m_showSystem.isSelected()) {
                    canAdd = true;
                }
            } else if (isTemp) {
                if (this.isValidSource() && this.m_showTemp.isSelected()) {
                    canAdd = true;
                }
            } else {
                canAdd = true;
            }
            if (!canAdd) continue;
            tableModel.addRow(instanceName);
        }
    }

    private JPanel makePanel() {
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add(this.m_btnAll);
        btnGroup.add(this.m_btnPattern);
        btnGroup.add(this.m_btnInstance);
        this.m_btnAll.setVerticalTextPosition(1);
        this.m_btnPattern.setVerticalTextPosition(1);
        this.m_btnInstance.setVerticalTextPosition(1);
        this.m_table = new JRowTable(new RowTableColumn[]{new RowTableColumn(0, "Instance Name", 100)}, this.getClass().getName());
        JPartitionPanel panel = new JPartitionPanel(true, "p,p,p,r", null, 5, 5, 5);
        panel.setBorder(panel.getPreferredBorder());
        panel.add(new JLabel("Add an instance:"));
        panel.add(this.makeAllPanel());
        panel.add(this.makePatternPanel());
        panel.add(this.makeInstancePanel());
        this.m_tfPattern.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                InstancePickSheet.this.m_btnPattern.setSelected(true);
                InstancePickSheet.this.enableButtons();
            }
        });
        this.m_table.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                InstancePickSheet.this.m_btnInstance.setSelected(true);
                InstancePickSheet.this.enableButtons();
            }
        });
        ChangeListener cl = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                InstancePickSheet.this.enableButtons();
            }
        };
        this.m_btnPattern.addChangeListener(cl);
        this.m_btnAll.addChangeListener(cl);
        this.m_btnAll.setSelected(true);
        this.m_btnInstance.addChangeListener(cl);
        this.m_tfPattern.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent evt) {
                InstancePickSheet.this.enableButtons();
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                InstancePickSheet.this.enableButtons();
            }

            @Override
            public void removeUpdate(DocumentEvent evt) {
                InstancePickSheet.this.enableButtons();
            }
        });
        this.m_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                InstancePickSheet.this.enableButtons();
            }
        });
        this.m_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    InstancePickSheet.this.getOKButton().doClick();
                }
            }
        });
        return panel;
    }

    private JPanel makeAllPanel() {
        JPartitionPanel panel = new JPartitionPanel(false, "r", null, 0, 0, 0);
        panel.add(this.m_btnAll);
        return panel;
    }

    private JPanel makePatternPanel() {
        JPartitionPanel panel = new JPartitionPanel(true, "r,r", null, 0, 0, 0);
        JPartitionPanel insetPanel = new JPartitionPanel(false, "p,p,r", null);
        insetPanel.add(new JLabel());
        insetPanel.add(new JLabel());
        insetPanel.add(new JLabel("e.g. Sample*"));
        insetPanel.add(new JPanel());
        insetPanel.add(new JLabel("Pattern: "));
        insetPanel.add(this.m_tfPattern);
        panel.add(this.m_btnPattern);
        panel.add(insetPanel);
        return panel;
    }

    private JPanel makeInstancePanel() {
        JPartitionPanel panel = new JPartitionPanel(true, "p,r", null);
        JPartitionPanel tablePanel = new JPartitionPanel(true, "r,p", null, 5, 0, 0);
        JButton btnRefresh = new JButton("Refresh");
        btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstancePickSheet.this.refreshInstances();
            }
        });
        this.m_showSystem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                IModelTableModel model = (IModelTableModel)InstancePickSheet.this.m_table.getModel();
                if (evt.getStateChange() == 2) {
                    for (int i = model.getRowCount() - 1; i >= 0; --i) {
                        String row = (String)model.getRowModel(i);
                        if (!row.toLowerCase().startsWith(InstancePickSheet.SYSTEM_INSTANCE)) continue;
                        model.deleteRow(i);
                    }
                } else {
                    InstancePickSheet.this.refreshInstances();
                }
            }
        });
        JPartitionPanel btnPanel = new JPartitionPanel(true, "p,p,r", null, 5, 0, 0);
        btnPanel.add(this.m_showSystem);
        if (this.isValidSource()) {
            this.m_showTemp.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    IModelTableModel model = (IModelTableModel)InstancePickSheet.this.m_table.getModel();
                    if (evt.getStateChange() == 2) {
                        for (int i = model.getRowCount() - 1; i >= 0; --i) {
                            String row = (String)model.getRowModel(i);
                            if (!row.startsWith(InstancePickSheet.TEMP_INSTANCE)) continue;
                            model.deleteRow(i);
                        }
                    } else {
                        InstancePickSheet.this.refreshInstances();
                    }
                }
            });
            btnPanel.add(this.m_showTemp);
        }
        btnPanel.add(JPartitionPanel.merge("p,r", false, 0, 0, 0, new Component[]{btnRefresh, new JPanel()}));
        tablePanel.add(new ExtendedJScrollPane(this.m_table));
        tablePanel.add(btnPanel);
        JPartitionPanel insetPanel = new JPartitionPanel(false, "p,r", "Instances", 5, 0, 0);
        insetPanel.add(new JPanel());
        insetPanel.add(tablePanel);
        panel.add(this.m_btnInstance);
        panel.add(insetPanel);
        return panel;
    }

    private boolean isValidSource() {
        String type = "";
        if (this.m_model.getSource() instanceof IPlugin) {
            IPlugin plugin = (IPlugin)this.m_model.getSource();
            type = plugin.getAttributes().getType();
        }
        return TYPE_BROKER.equals(type);
    }

    private void enableButtons() {
        boolean enable = false;
        if (this.m_btnPattern.isSelected()) {
            enable = this.m_tfPattern.getText().trim().length() > 0;
        } else if (this.m_btnAll.isSelected()) {
            enable = true;
        } else if (this.m_btnInstance.isSelected()) {
            enable = this.m_table.getSelectedRow() != -1;
        }
        this.getOKButton().setEnabled(enable);
    }

    private JButton getOKButton() {
        return ((JButtonPanel)this.getButtonPanel()).getButton("dialog.ok");
    }

    private class OKAction
    extends BasicGuiAction {
        public OKAction() {
            super("dialog.ok", InstancePickSheet.this.getDefaultOKAction());
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String[] value = null;
            if (InstancePickSheet.this.m_btnPattern.isSelected()) {
                value = new String[]{InstancePickSheet.this.m_tfPattern.getText().trim()};
            } else if (InstancePickSheet.this.m_btnAll.isSelected()) {
                value = new String[]{"*"};
            } else if (InstancePickSheet.this.m_btnInstance.isSelected()) {
                IModelTableModel tableModel = (IModelTableModel)InstancePickSheet.this.m_table.getModel();
                int[] sel = InstancePickSheet.this.m_table.getSelectedRows();
                ArrayList<Object> selList = new ArrayList<Object>();
                for (int i = 0; i < sel.length; ++i) {
                    selList.add(tableModel.getRowModel(sel[i]));
                }
                value = selList.toArray(new String[selList.size()]);
            }
            if (value != null) {
                InstancePickSheet.this.getEnablementSheet().addPattern(value);
            }
            super.actionPerformed(evt);
        }
    }
}

