/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.metrics;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.WorkspaceWindow;
import com.sonicsw.ma.gui.runtime.JAbstractMonitorPanel;
import com.sonicsw.ma.gui.runtime.JMonitorDialog;
import com.sonicsw.ma.gui.runtime.metrics.AggrMetricsTreeCellRenderer;
import com.sonicsw.ma.gui.runtime.metrics.AggregateMetricsWatchWindow;
import com.sonicsw.ma.gui.runtime.metrics.model.AggregateMetricsModel;
import com.sonicsw.ma.gui.runtime.util.AbstractNode;
import com.sonicsw.ma.gui.runtime.util.AbstractParentNode;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.gui.util.PopupMenuShower;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IMonitorPlugin;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class JAggregateMetricPanel
extends JAbstractMonitorPanel
implements TreeModelListener {
    public static final String MONITOR_ID_AGGREGATE_METRICS = "_AggregateMetrics";
    private JTree m_tree;
    private BasicAction m_watchAction = new WatchAction();
    private BasicAction m_refreshAction = new RefreshAction();

    public JAggregateMetricPanel() {
        this.m_tree = new JTree(null){

            @Override
            public String getToolTipText(MouseEvent event) {
                TreePath path = this.getPathForLocation(event.getX(), event.getY());
                if (path == null) {
                    return null;
                }
                return ((AbstractNode)path.getLastPathComponent()).getDescription();
            }
        };
        this.m_tree.setRootVisible(false);
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setCellRenderer(new AggrMetricsTreeCellRenderer());
        this.m_tree.setVisibleRowCount(10);
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.addMouseListener(new PopupMenuShower(this.m_tree, this.buildPopupMenu()));
        ExtendedJScrollPane scrollPane = new ExtendedJScrollPane(this.m_tree);
        JToolBar tb = new JToolBar(0);
        tb.setFloatable(false);
        tb.setRollover(true);
        tb.add(this.m_watchAction);
        tb.add(this.m_refreshAction);
        this.add((Component)tb, "North");
        this.add((Component)scrollPane, "Center");
        this.enableButtons();
        this.m_tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                JAggregateMetricPanel.this.enableButtons();
            }
        });
    }

    @Override
    public Icon getIcon() {
        return ResourceManager.getIcon(this.getClass(), "Metric");
    }

    @Override
    public void maInitialize() {
        ToolTipManager.sharedInstance().registerComponent(this.m_tree);
    }

    @Override
    public void maCleanup() {
        AggregateMetricsModel model = (AggregateMetricsModel)this.m_tree.getModel();
        if (model != null) {
            model.removeTreeModelListener(this);
        }
        ToolTipManager.sharedInstance().unregisterComponent(this.m_tree);
    }

    @Override
    public String getTabTitle() {
        return "Aggregated Metrics";
    }

    @Override
    public String getMonitorId() {
        return MONITOR_ID_AGGREGATE_METRICS;
    }

    @Override
    public void changeModel(IMonitorPlugin plugin) {
        AggregateMetricsModel newModel = (AggregateMetricsModel)plugin.getMonitorModel(MONITOR_ID_AGGREGATE_METRICS);
        AggregateMetricsModel oldModel = (AggregateMetricsModel)this.m_tree.getModel();
        if (oldModel != null) {
            oldModel.removeTreeModelListener(this);
        }
        this.m_tree.setModel(newModel);
        if (newModel != null) {
            newModel.addTreeModelListener(this);
        }
        this.expandTree();
    }

    private void expandTree() {
        for (int row = 0; row < this.m_tree.getRowCount(); ++row) {
            if (!(this.m_tree.getPathForRow(row).getLastPathComponent() instanceof AbstractParentNode)) continue;
            this.m_tree.expandRow(row);
        }
    }

    private JPopupMenu buildPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new JBasicMenuItem(this.m_watchAction));
        return menu;
    }

    private void enableButtons() {
        TreePath path = this.m_tree.getSelectionPath();
        boolean sel = path != null;
        AbstractNode node = sel ? (AbstractNode)path.getLastPathComponent() : null;
        boolean parent = sel && path.getLastPathComponent() instanceof AbstractParentNode;
        boolean enable = node != null && node.isEnabled();
        this.m_watchAction.setEnabled(!parent && enable);
        this.m_refreshAction.setEnabled(true);
    }

    private AbstractNode getCurrentNode() {
        return (AbstractNode)this.m_tree.getSelectionPath().getLastPathComponent();
    }

    private void refresh() {
        AggregateMetricsModel model = (AggregateMetricsModel)this.m_tree.getModel();
        try {
            model.refreshTree();
            this.expandTree();
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to refresh", e, true);
            return;
        }
    }

    @Override
    public void treeNodesChanged(TreeModelEvent evt) {
        this.enableButtons();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent evt) {
        this.enableButtons();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent evt) {
        this.enableButtons();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent evt) {
        this.enableButtons();
    }

    private class RefreshAction
    extends BasicGuiAction {
        public RefreshAction() {
            super("AggregateMetricsSheet.refresh");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                JAggregateMetricPanel.this.refresh();
            }
            catch (Throwable e) {
                MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to refresh", e, true);
            }
        }
    }

    private class WatchAction
    extends BasicGuiAction {
        public WatchAction() {
            super("AggregateMetricsSheet.watch");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JMonitorDialog parent;
            WorkspaceWindow domainParent;
            AggregateMetricsWatchWindow watcher = AggregateMetricsWatchWindow.getWatchWindow(((AggregateMetricsModel)JAggregateMetricPanel.this.m_tree.getModel()).getComponentName());
            if (!((JInternalFrame)watcher).isVisible() && (domainParent = (parent = (JMonitorDialog)SwingUtilities.getAncestorOfClass(JMonitorDialog.class, JAggregateMetricPanel.this)).getWorkspaceWindow()) != null) {
                domainParent.addDependantFrame(watcher);
                MgmtConsole.getMgmtConsole().showInternalFrame(watcher, true);
            }
            AbstractNode node = JAggregateMetricPanel.this.getCurrentNode();
            ArrayList<AbstractNode> nodes = new ArrayList<AbstractNode>();
            if (node instanceof AbstractParentNode) {
                Enumeration<TreeNode> en = node.depthFirstEnumeration();
                while (en.hasMoreElements()) {
                    node = (AbstractNode)en.nextElement();
                    if (node instanceof AbstractParentNode) continue;
                    nodes.add(node);
                }
            } else {
                nodes.add(node);
            }
            AggregateMetricsModel model = (AggregateMetricsModel)JAggregateMetricPanel.this.m_tree.getModel();
            for (int i = 0; i < nodes.size(); ++i) {
                Object data = ((AbstractNode)nodes.get(i)).getUserObject();
                IMetricIdentity id = data instanceof IMetricIdentity ? (IMetricIdentity)data : ((IMetricInfo)data).getMetricIdentity();
                watcher.addWatch(id, model);
            }
        }
    }
}

