/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.metrics;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.WorkspaceWindow;
import com.sonicsw.ma.gui.runtime.JAbstractMonitorPanel;
import com.sonicsw.ma.gui.runtime.JMonitorDialog;
import com.sonicsw.ma.gui.runtime.metrics.AlertsDialog;
import com.sonicsw.ma.gui.runtime.metrics.InstanceEnablementSheet;
import com.sonicsw.ma.gui.runtime.metrics.MetricsTreeCellRenderer;
import com.sonicsw.ma.gui.runtime.metrics.MetricsWatchWindow;
import com.sonicsw.ma.gui.runtime.metrics.model.InstanceNode;
import com.sonicsw.ma.gui.runtime.metrics.model.InstanceParentNode;
import com.sonicsw.ma.gui.runtime.metrics.model.MetricsModel;
import com.sonicsw.ma.gui.runtime.metrics.model.ParentNode;
import com.sonicsw.ma.gui.runtime.util.AbstractNode;
import com.sonicsw.ma.gui.runtime.util.AbstractParentNode;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JBasicMenu;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.gui.util.PopupMenuShower;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IMonitorPlugin;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class JMetricsPanel
extends JAbstractMonitorPanel
implements TreeModelListener {
    private JTree m_tree;
    private BasicAction m_enableAction = new EnableAction();
    private BasicAction m_disableAction = new DisableAction();
    private BasicAction m_enableInstancesAction = new InstancesAction();
    private BasicAction m_alertsAction = new AlertsAction();
    private BasicAction m_watchAction = new WatchButtonAction();

    public JMetricsPanel() {
        this.m_tree = new CustomJTree((TreeModel)null);
        this.m_tree.setRootVisible(false);
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setCellRenderer(new MetricsTreeCellRenderer());
        this.m_tree.setVisibleRowCount(10);
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.addMouseListener(new PopupMenuShower(this.m_tree, this.buildPopupMenu()));
        ExtendedJScrollPane scrollPane = new ExtendedJScrollPane(this.m_tree);
        JToolBar tb = new JToolBar(0);
        tb.setFloatable(false);
        tb.setRollover(true);
        tb.add(this.m_enableAction);
        tb.add(this.m_disableAction);
        tb.addSeparator();
        tb.add(this.m_enableInstancesAction);
        tb.addSeparator();
        tb.add(this.m_alertsAction);
        tb.addSeparator();
        tb.add(new JWatchButton(this.m_watchAction));
        this.add((Component)tb, "North");
        this.add((Component)scrollPane, "Center");
        this.enableButtons();
        this.m_tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                JMetricsPanel.this.enableButtons();
            }
        });
    }

    @Override
    public Icon getIcon() {
        return ResourceManager.getIcon(this.getClass(), "Metric");
    }

    @Override
    public void maInitialize() {
        ToolTipManager.sharedInstance().registerComponent(this.m_tree);
    }

    @Override
    public void maCleanup() {
        MetricsModel model = (MetricsModel)this.m_tree.getModel();
        if (model != null) {
            model.removeTreeModelListener(this);
        }
        this.m_tree.setModel(null);
        ToolTipManager.sharedInstance().unregisterComponent(this.m_tree);
    }

    @Override
    public String getTabTitle() {
        return "Metrics";
    }

    @Override
    public String getMonitorId() {
        return "_Metrics";
    }

    @Override
    public void changeModel(IMonitorPlugin plugin) {
        MetricsModel oldModel = (MetricsModel)this.m_tree.getModel();
        if (oldModel != null) {
            oldModel.removeTreeModelListener(this);
        }
        MetricsModel newModel = (MetricsModel)plugin.getMonitorModel("_Metrics");
        this.m_tree.setModel(newModel);
        if (newModel != null) {
            newModel.setSource(plugin);
            newModel.addTreeModelListener(this);
            try {
                newModel.refreshTree();
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to refresh metrics model", e, false);
            }
        }
        this.expandTree();
    }

    private void expandTree() {
        for (int row = 0; row < this.m_tree.getRowCount(); ++row) {
            if (!(this.m_tree.getPathForRow(row).getLastPathComponent() instanceof ParentNode)) continue;
            this.m_tree.expandRow(row);
        }
    }

    private JPopupMenu buildPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JBasicMenu watchMenu = new JBasicMenu(this.m_watchAction);
        watchMenu.add(new JBasicMenuItem(new WatchAction("MetricsSheet.watch.component", 2)));
        watchMenu.add(new JBasicMenuItem(new WatchAction("MetricsSheet.watch.container", 1)));
        watchMenu.add(new JBasicMenuItem(new WatchAction("MetricsSheet.watch.domain", 0)));
        menu.add(new JBasicMenuItem(this.m_enableAction));
        menu.add(new JBasicMenuItem(this.m_disableAction));
        menu.addSeparator();
        menu.add(new JBasicMenuItem(this.m_enableInstancesAction));
        menu.add(new JBasicMenuItem(this.m_alertsAction));
        menu.addSeparator();
        menu.add(watchMenu);
        return menu;
    }

    private void enableButtons() {
        TreePath path = this.m_tree.getSelectionPath();
        boolean sel = path != null;
        AbstractNode node = sel ? (AbstractNode)path.getLastPathComponent() : null;
        boolean parent = sel && path.getLastPathComponent() instanceof AbstractParentNode;
        boolean enable = node != null && node.isEnabled();
        this.m_enableAction.setEnabled(parent || node != null && !node.isEnabled() && !(node instanceof InstanceNode));
        this.m_disableAction.setEnabled(parent || node != null && node.isEnabled() && !(node instanceof InstanceNode));
        this.m_enableInstancesAction.setEnabled(node != null && node instanceof InstanceParentNode);
        this.m_alertsAction.setEnabled(node != null ? this.isAlertsEnabled(node) : false);
        this.m_watchAction.setEnabled(!parent && enable);
    }

    private AbstractNode getCurrentNode() {
        return (AbstractNode)this.m_tree.getSelectionPath().getLastPathComponent();
    }

    private boolean isAlertsEnabled(AbstractNode node) {
        InstanceParentNode parent;
        boolean result = false;
        IMetricInfo info = null;
        if (node.getUserObject() instanceof IMetricInfo) {
            info = (IMetricInfo)node.getUserObject();
        } else if (node instanceof InstanceNode && (parent = (InstanceParentNode)node.getParent()) != null) {
            info = (IMetricInfo)parent.getUserObject();
        }
        if (info != null) {
            result = info.supportsHighThresholdAlerts() ? true : info.supportsLowThresholdAlerts();
        }
        return result;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent evt) {
        this.enableButtons();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent evt) {
        this.enableButtons();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent evt) {
        this.enableButtons();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent evt) {
        this.enableButtons();
    }

    private static class CustomJTree
    extends JTree {
        public CustomJTree(TreeModel newModel) {
            super(newModel);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            TreePath path = this.getPathForLocation(event.getX(), event.getY());
            if (path == null) {
                return null;
            }
            return ((AbstractNode)path.getLastPathComponent()).getDescription();
        }
    }

    private class DisableDialog
    extends JMADialog {
        private int m_option;

        public DisableDialog(JMADialog parent) {
            super(parent, "manage-tools.metric.disable-instance");
            this.setResizableProperty();
        }

        private void setResizableProperty() {
            this.setResizable(false);
        }

        @Override
        public void maInitialize() {
            JRadioButton btn1 = new JRadioButton("Remove all instance patterns");
            JRadioButton btn2 = new JRadioButton("Remove only the '*' pattern");
            JRadioButton btn3 = new JRadioButton("Don't remove any patterns");
            btn1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DisableDialog.this.m_option = 1;
                }
            });
            btn2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DisableDialog.this.m_option = 2;
                }
            });
            btn3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DisableDialog.this.m_option = 0;
                }
            });
            btn2.doClick();
            ButtonGroup btnGroup = new ButtonGroup();
            btnGroup.add(btn1);
            btnGroup.add(btn2);
            btnGroup.add(btn3);
            JPartitionPanel btnPanel = new JPartitionPanel(true, "p,p,p", null, 0, 5, 5);
            btnPanel.add(btn1);
            btnPanel.add(btn2);
            btnPanel.add(btn3);
            JPartitionPanel wrapPanel = new JPartitionPanel(true, "p,p,r", null);
            JLabel label1 = new JLabel("You have choosen to disable the selected instance metric(s).");
            JLabel label2 = new JLabel("Do you want to:");
            wrapPanel.add(label1);
            wrapPanel.add(label2);
            wrapPanel.add(btnPanel);
            JPartitionPanel panel = new JPartitionPanel(false, "p,r", null, 5, 10, 10);
            panel.add(JPartitionPanel.merge("p", true, new Component[]{new JLabel(UIManager.getIcon("OptionPane.questionIcon"))}));
            panel.add(wrapPanel);
            this.getContentPane().add(panel);
        }

        @Override
        public void maCleanup() {
        }

        public int getDisableOption() {
            return this.m_option;
        }
    }

    private class AlertsAction
    extends BasicGuiAction {
        public AlertsAction() {
            super("MetricsSheet.alerts");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AbstractNode node = JMetricsPanel.this.getCurrentNode();
            JMADialog parentDialog = (JMADialog)SwingUtilities.getAncestorOfClass(JMADialog.class, JMetricsPanel.this);
            AlertsDialog dialog = new AlertsDialog(parentDialog, (MetricsModel)JMetricsPanel.this.m_tree.getModel(), node);
            dialog.setVisible(true);
        }
    }

    private class WatchAction
    extends BasicGuiAction {
        private short m_scope;

        public WatchAction(String resource, short scope) {
            super(resource);
            this.m_scope = scope;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    JWaitCursor wc = new JWaitCursor(Helper.getJDialog(JMetricsPanel.this));
                    try {
                        JMonitorDialog parent;
                        WorkspaceWindow domainParent;
                        final MetricsWatchWindow watcher = MetricsWatchWindow.getWatchWindow(WatchAction.this.m_scope, ((MetricsModel)JMetricsPanel.this.m_tree.getModel()).getComponentName());
                        if (!((JInternalFrame)watcher).isVisible() && (domainParent = (parent = (JMonitorDialog)SwingUtilities.getAncestorOfClass(JMonitorDialog.class, JMetricsPanel.this)).getWorkspaceWindow()) != null) {
                            domainParent.addDependantFrame(watcher);
                            watcher.setDomainParent(domainParent);
                            MgmtConsole.getMgmtConsole().showInternalFrame(watcher, true);
                        }
                        AbstractNode node = JMetricsPanel.this.getCurrentNode();
                        ArrayList<AbstractNode> nodes = new ArrayList<AbstractNode>();
                        if (node instanceof AbstractParentNode) {
                            Enumeration<TreeNode> en = node.depthFirstEnumeration();
                            while (en.hasMoreElements()) {
                                node = (AbstractNode)en.nextElement();
                                if (node instanceof AbstractParentNode) continue;
                                nodes.add(node);
                            }
                        } else {
                            nodes.add(node);
                        }
                        final MetricsModel model = (MetricsModel)JMetricsPanel.this.m_tree.getModel();
                        for (int i = 0; i < nodes.size(); ++i) {
                            Object data = ((AbstractNode)nodes.get(i)).getUserObject();
                            final IMetricIdentity id = data instanceof IMetricIdentity ? (IMetricIdentity)data : ((IMetricInfo)data).getMetricIdentity();
                            Helper.invoke(new Runnable(){

                                @Override
                                public void run() {
                                    watcher.addWatch(id, model);
                                }
                            }, true);
                        }
                    }
                    finally {
                        wc.release();
                    }
                }
            });
            t.start();
        }
    }

    private class WatchButtonAction
    extends BaseWatchAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            super.actionPerformed(evt);
            JPopupMenu pm = new JPopupMenu("-");
            pm.add(new JBasicMenuItem(new WatchAction("MetricsSheet.watch.component", 2)));
            pm.add(new JBasicMenuItem(new WatchAction("MetricsSheet.watch.container", 1)));
            pm.add(new JBasicMenuItem(new WatchAction("MetricsSheet.watch.domain", 0)));
            pm.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent evt) {
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                    JMetricsPanel.this.m_watchAction.setSelected(false);
                }
            });
            if (pm.getComponentCount() > 0) {
                JButton src = (JButton)evt.getSource();
                Point pt = Helper.getPopupMenuOrigin(src, pm);
                pm.show(src, pt.x, pt.y);
            }
        }
    }

    private class BaseWatchAction
    extends BasicGuiAction {
        public BaseWatchAction() {
            super("MetricsSheet.watch");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
        }
    }

    private class InstancesAction
    extends BasicGuiAction {
        public InstancesAction() {
            super("MetricsSheet.instances");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                MetricsModel model = (MetricsModel)JMetricsPanel.this.m_tree.getModel();
                InstanceParentNode node = (InstanceParentNode)JMetricsPanel.this.getCurrentNode();
                String[] enabledPatterns = model.getEnabledMetricsPatterns(node);
                JMADialog parent = (JMADialog)SwingUtilities.getAncestorOfClass(JMADialog.class, JMetricsPanel.this);
                InstanceEnablementSheet dialog = new InstanceEnablementSheet(parent, model, node, enabledPatterns);
                dialog.setVisible(true);
            }
            catch (Throwable e) {
                MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to enable/disable metric instances", e, true);
            }
        }
    }

    private class DisableAction
    extends BasicGuiAction {
        public DisableAction() {
            super("MetricsSheet.disable");
        }

        private boolean hasInstanceMetric(AbstractNode startNode) {
            boolean hasInstance = false;
            Enumeration<TreeNode> en = startNode.breadthFirstEnumeration();
            while (en.hasMoreElements()) {
                AbstractNode node = (AbstractNode)en.nextElement();
                if (!(node instanceof InstanceNode)) continue;
                hasInstance = true;
                break;
            }
            return hasInstance;
        }

        private boolean isInstanceEnablementSimple(AbstractNode startNode) {
            boolean state = true;
            MetricsModel model = (MetricsModel)JMetricsPanel.this.m_tree.getModel();
            Enumeration<TreeNode> en = startNode.breadthFirstEnumeration();
            while (en.hasMoreElements()) {
                AbstractNode node = (AbstractNode)en.nextElement();
                if (!(node instanceof InstanceParentNode)) continue;
                try {
                    String[] enabledPatterns = model.getEnabledMetricsPatterns((InstanceParentNode)node);
                    if ((enabledPatterns.length == 0 || enabledPatterns.length <= 1) && enabledPatterns[0].equals("*")) continue;
                    state = false;
                    break;
                }
                catch (Exception e) {
                    MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                }
            }
            return state;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (this.hasInstanceMetric(JMetricsPanel.this.getCurrentNode())) {
                    int disableOption = 0;
                    if (this.isInstanceEnablementSimple(JMetricsPanel.this.getCurrentNode())) {
                        disableOption = 1;
                    } else {
                        DisableDialog dlg = new DisableDialog((JMADialog)SwingUtilities.getAncestorOfClass(JMADialog.class, JMetricsPanel.this));
                        dlg.setVisible(true);
                        if (dlg.getCloseCommand() == 0) {
                            disableOption = dlg.getDisableOption();
                        }
                    }
                    ((MetricsModel)JMetricsPanel.this.m_tree.getModel()).disableMetric(JMetricsPanel.this.getCurrentNode(), disableOption);
                } else {
                    ((MetricsModel)JMetricsPanel.this.m_tree.getModel()).disableMetric(JMetricsPanel.this.getCurrentNode());
                }
            }
            catch (Throwable e) {
                MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to disable metric", e, true);
            }
        }
    }

    private class EnableAction
    extends BasicGuiAction {
        public EnableAction() {
            super("MetricsSheet.enable");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                ((MetricsModel)JMetricsPanel.this.m_tree.getModel()).enableMetric(JMetricsPanel.this.getCurrentNode());
            }
            catch (Throwable e) {
                MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to enable metric", e, true);
            }
        }
    }

    class JWatchButton
    extends JButton {
        public JWatchButton(Action action) {
            super(action);
        }

        @Override
        protected void configurePropertiesFromAction(Action a) {
            String[] types = new String[]{"SmallIcon", "ShortDescription", "LongDescription", "enabled"};
            Helper.configurePropertiesFromAction(this, a, types);
        }
    }
}

