/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.metrics;

import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.runtime.metrics.model.IMetricWatcher;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import modelobjects.framework.EditRule;
import modelobjects.framework.IntToStringConverter;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.model.ModelObjectAdapter;
import modelobjects.framework.model.ModelObjectPropagator;
import modelobjects.framework.model.ModelObjectValidator;
import modelobjects.framework.model.ModelPropagationException;
import modelobjects.framework.model.ModelValidationException;
import modelobjects.framework.swing.JTextFieldAdapter;

class JMetricsWatchOptionsDialog
extends JPropSheetDialog {
    private JTextField m_poll;

    public JMetricsWatchOptionsDialog(JMAFrame parent) {
        super(parent, "metrics.watcher.options", Model.class);
        this.setValidator(new Validator());
        this.setPropagator(new Propagator());
    }

    @Override
    public void initUI() throws Exception {
        this.getContentPane().add(JPartitionPanel.wrap(this.createMainPanel()));
    }

    @Override
    public void initForm() throws Exception {
        new JTextFieldAdapter(ModelAspectId.forName("pollFrequency"), this.m_poll, EditRule.NEVER, new IntToStringConverter(false), this.getMediator());
    }

    private JPanel createMainPanel() {
        this.m_poll = new JTextField(5);
        JPartitionPanel panel = new JPartitionPanel(false, "Watch Data");
        panel.addRow("Poll Frequency", (JComponent)this.m_poll, "seconds");
        return panel;
    }

    private static class Propagator
    implements ModelObjectPropagator {
        private Propagator() {
        }

        @Override
        public void propagateModelEdit(ModelObjectAdapter adapter) throws ModelPropagationException {
            Model model = (Model)adapter.getModelObject();
            model.watcher.setPollFrequency(model.getPollFrequency());
        }

        @Override
        public void propagateModelCreation(ModelObjectAdapter modelObjectAdapter) throws ModelPropagationException {
        }

        @Override
        public void propagateModelDeletion(ModelObjectAdapter modelObjectAdapter) throws ModelPropagationException {
        }
    }

    private static class Validator
    implements ModelObjectValidator {
        private Validator() {
        }

        @Override
        public void validateModelEdit(ModelObjectAdapter adapter) throws ModelValidationException {
            Model model = (Model)adapter.getModelObject();
            if (model.getPollFrequency() < 10) {
                throw new ModelValidationException("The poll frequency must be >= 10 seconds");
            }
            if (model.getPollFrequency() > 900) {
                throw new ModelValidationException("The poll frequency must be <= 900 seconds");
            }
        }

        @Override
        public void validateModelCreation(ModelObjectAdapter adapter) throws ModelValidationException {
        }

        @Override
        public void validateModelDeletion(ModelObjectAdapter adapter) throws ModelValidationException {
        }
    }

    public class Model {
        private int poll;
        IMetricWatcher watcher;

        public Model(IMetricWatcher watcher) {
            this.watcher = watcher;
            this.poll = watcher.getPollFrequency();
        }

        public int getPollFrequency() {
            return this.poll;
        }

        public void setPollFrequency(int poll) {
            this.poll = poll;
        }
    }
}

