/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.metrics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import lt.monarch.chart.AbstractChartPlugin;
import lt.monarch.chart.ChartEntity;
import lt.monarch.chart.HotSpotMap;
import lt.monarch.chart.chart2D.ScatterSeries;
import lt.monarch.chart.marker.DotMarker;

public class MarkerSelector
extends AbstractChartPlugin
implements MouseMotionListener {
    private ScatterSeries.MarkerEntity currentEntity;
    private DotMarker marker = new DotMarker();

    public MarkerSelector() {
        this.marker.setDotSize(10);
        this.marker.setFillColor(Color.red);
    }

    public void activate() {
        this.chart().container().addMouseMotionListener((MouseMotionListener)this);
    }

    public void deactivate() {
        this.chart().container().removeMouseMotionListener((MouseMotionListener)this);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.currentEntity != null) {
            Rectangle r = this.marker.getBounds();
            this.currentEntity = null;
            this.chart().repaint(r);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        HotSpotMap map = this.chart().container().getHotSpotMap();
        ChartEntity entity = map.findEntityAt(e.getPoint());
        if (this.currentEntity != null && !this.currentEntity.equals((Object)entity)) {
            Rectangle r = this.marker.getBounds();
            this.currentEntity = null;
            this.chart().repaint(r);
        }
        if (entity instanceof ScatterSeries.MarkerEntity && !entity.equals(this.currentEntity)) {
            e.consume();
            this.currentEntity = (ScatterSeries.MarkerEntity)entity;
            Graphics g = this.chart().container().getUpdateGraphics();
            this.marker.setLocation(this.chart().projector(), this.currentEntity.getPosition());
            this.marker.prepare(g);
            Rectangle r = this.marker.getBounds();
            g.dispose();
            this.chart().repaint(r);
        }
    }

    public void paint(Graphics g) {
        if (this.currentEntity != null) {
            this.marker.draw(g);
        }
    }
}

