/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.metrics;

import com.sonicsw.ma.gui.runtime.metrics.MetricValue;
import com.sonicsw.ma.gui.runtime.metrics.MetricsBarSeries;
import com.sonicsw.ma.gui.runtime.metrics.MetricsChart;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import lt.monarch.chart.AxisMapper;
import lt.monarch.chart.Chart;
import lt.monarch.chart.ChartObject;
import lt.monarch.chart.ChartPlugin;
import lt.monarch.chart.Grid;
import lt.monarch.chart.PlaneMapper;
import lt.monarch.chart.chart2D.Axis2D;
import lt.monarch.chart.chart2D.Axis2DX;
import lt.monarch.chart.chart2D.Axis2DY;
import lt.monarch.chart.chart2D.LinearLabelLayouter;
import lt.monarch.chart.chart2D.MultiLineLabelLayouter;
import lt.monarch.chart.chart2D.PlaneMapper2D;
import lt.monarch.chart.chart3D.BarChart3D;
import lt.monarch.chart.chart3D.ChartRotator;
import lt.monarch.chart.mapper.LabelAxisMapper;
import lt.monarch.chart.mapper.MathAxisMapper;
import lt.monarch.chart.view.ToolTipManager;

public class MetricsBarChart
extends MetricsChart {
    private BarChart3D m_chart = null;
    private Axis2DX m_axisX = null;
    private Axis2DY m_axisY = null;
    private AxisMapper m_yMapper = null;
    private AxisMapper m_xMapper = null;
    private Grid m_grid = null;
    private boolean m_bInitialized = false;
    private Collection m_colSeries = Collections.synchronizedList(new ArrayList());
    private ToolTipManager m_tipMgr = null;
    private ChartRotator m_rotator = null;
    private MultiLineLabelLayouter m_layouter = null;
    private PlaneMapper2D m_planeMapper = null;
    private Float m_fDefaultElevationAngle = new Float(0.0);
    private Float m_fDefaultRotationAngle = new Float(0.0);
    private BarChart3D m_chartBar = null;

    public MetricsBarChart(Collection colMetrics) {
        super((Chart)new BarChart3D());
        this.m_colSeries = colMetrics;
    }

    @Override
    public void init() {
        if (!this.m_bInitialized) {
            this.m_chart = (BarChart3D)super.getViewChart();
            this.createLayout();
            Collection colIncoming = this.m_colSeries;
            this.m_colSeries = Collections.synchronizedList(new ArrayList());
            Iterator iter = colIncoming.iterator();
            while (iter.hasNext()) {
                this.createSeries((MetricValue)iter.next());
            }
            this.setupChart();
            this.m_bInitialized = true;
        }
        super.init();
    }

    public void setElevatedAndRotated(boolean bElevatedAndRotated) {
        Float fElevationAngle = this.m_fDefaultElevationAngle;
        Float fRotationAngle = this.m_fDefaultRotationAngle;
        if (!bElevatedAndRotated) {
            fElevationAngle = new Float(0.0);
            fRotationAngle = new Float(0.0);
        }
        this.m_chart.setElevationAngle(fElevationAngle.floatValue());
        this.m_chart.setRotationAngle(fRotationAngle.floatValue());
    }

    public void add(MetricValue value) {
        MetricsBarSeries series = this.createSeries(value);
        if (!value.getCurrency().equals(new Long(0L))) {
            this.update();
        }
    }

    public void remove(MetricValue value) {
        MetricsBarSeries series = this.getSeries(value);
        this.m_chart.removeObject((ChartObject)series.getSeries());
        ((LabelAxisMapper)this.m_xMapper).unregisterKey((Object)value.getMetric());
        this.m_colSeries.remove(series);
        series.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        Collection collection = this.m_colSeries;
        synchronized (collection) {
            if (this.m_colSeries != null) {
                for (MetricsBarSeries series : this.m_colSeries) {
                    series.update();
                    this.chart.invalidate();
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.m_chart != null) {
            this.m_chart.removePlugin((ChartPlugin)this.m_tipMgr);
            this.m_chart.removePlugin((ChartPlugin)this.m_rotator);
            this.m_tipMgr = null;
            this.m_rotator = null;
            this.m_chart.cleanup();
            this.m_chart = null;
        }
        if (this.m_colSeries != null) {
            for (MetricsBarSeries series : this.m_colSeries) {
                series.close();
            }
            this.m_colSeries.clear();
            this.m_colSeries = null;
        }
        this.removeAll();
        this.m_grid.cleanup();
        this.m_grid = null;
        this.m_fDefaultElevationAngle = null;
        this.m_fDefaultRotationAngle = null;
        this.m_layouter = null;
        this.m_axisX.cleanup();
        this.m_axisX = null;
        this.m_axisY.cleanup();
        this.m_axisY = null;
        this.m_planeMapper = null;
        super.close();
    }

    private MetricsBarSeries createSeries(MetricValue value) {
        MetricsBarSeries series = new MetricsBarSeries(value, (Axis2D)this.m_axisX, (Axis2D)this.m_axisY, this.m_yMapper, value.getColorId());
        this.m_colSeries.add(series);
        this.m_chart.addObject((ChartObject)series.getSeries());
        ((LabelAxisMapper)this.m_xMapper).registerKey((Object)value.getMetric());
        return series;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetricsBarSeries getSeries(MetricValue value) {
        MetricsBarSeries series = null;
        Collection collection = this.m_colSeries;
        synchronized (collection) {
            for (MetricsBarSeries seriesTemp : this.m_colSeries) {
                if (!seriesTemp.getMetric().equals(value)) continue;
                series = seriesTemp;
                break;
            }
        }
        return series;
    }

    private void setupChart() {
        this.m_fDefaultElevationAngle = new Float(this.m_chart.getElevationAngle());
        this.m_fDefaultRotationAngle = new Float(this.m_chart.getRotationAngle());
        this.m_chart.setObjects(this.createChartObjects());
        this.m_chart.setYAxis(this.m_axisY);
        this.m_chart.setXAxis(this.m_axisX);
        this.m_rotator = new ChartRotator();
        this.m_chart.addPlugin((ChartPlugin)this.m_rotator);
        this.m_tipMgr = new ToolTipManager();
        this.m_chart.addPlugin((ChartPlugin)this.m_tipMgr);
        this.setElevatedAndRotated(false);
    }

    private void createLayout() {
        this.m_xMapper = new LabelAxisMapper();
        this.m_axisX = new Axis2DX(this.m_xMapper);
        this.m_layouter = new MultiLineLabelLayouter();
        this.m_axisX.setLabelLayout((LinearLabelLayouter)this.m_layouter);
        this.m_axisX.setMinRowCount(2);
        this.m_axisX.setMaxRowCount(2);
        this.m_yMapper = new MathAxisMapper(0.0, 1.0);
        this.m_axisY = new Axis2DY(this.m_yMapper);
        this.m_axisY.setTitle("Value");
        this.m_planeMapper = new PlaneMapper2D();
        this.m_grid = new Grid((PlaneMapper)this.m_planeMapper, this.m_xMapper, this.m_yMapper);
    }

    private ChartObject[] createChartObjects() {
        ChartObject[] chartObjects = new ChartObject[3];
        int nIdx = 0;
        chartObjects[nIdx++] = this.m_grid;
        chartObjects[nIdx++] = this.m_axisX;
        chartObjects[nIdx++] = this.m_axisY;
        return chartObjects;
    }
}

