/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.metrics;

import com.sonicsw.ma.gui.runtime.metrics.MetricValue;
import com.sonicsw.ma.gui.util.Helper;
import java.awt.Color;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lt.monarch.chart.AbstractChartDataModel;
import lt.monarch.chart.AxisMapper;
import lt.monarch.chart.ChartDataModel2D;
import lt.monarch.chart.ChartDataModelAnnotations;
import lt.monarch.chart.chart2D.Axis2D;
import lt.monarch.chart.chart3D.BarSeries3D;
import lt.monarch.chart.mapper.MathAxisMapper;

public class MetricsBarSeries {
    private BarSeries3D m_series = null;
    private AxisMapper m_yMapper = null;
    private MetricsSeriesModel m_model = null;
    private MetricValue m_value = null;

    public MetricsBarSeries(MetricValue value, Axis2D xAxis, Axis2D yAxis, AxisMapper yMapper, Color color) {
        this.m_value = value;
        this.m_yMapper = yMapper;
        this.m_model = new MetricsSeriesModel();
        this.m_series = new BarSeries3D((ChartDataModel2D)this.m_model, xAxis, yAxis);
        this.m_series.setFillColor(color);
        this.m_series.setName(this.getName());
    }

    public final BarSeries3D getSeries() {
        return this.m_series;
    }

    public final String getName() {
        return this.m_value.getMetric();
    }

    public MetricValue getMetric() {
        return this.m_value;
    }

    public void update() {
        this.m_model.refresh();
    }

    public void close() {
        this.m_model.close();
        this.m_model = null;
        this.m_series.cleanup();
        this.m_series = null;
    }

    private class MetricsSeriesModel
    extends AbstractChartDataModel
    implements ChartDataModel2D,
    ChartDataModelAnnotations {
        private SimpleDateFormat m_dateFormatter = new SimpleDateFormat("h:mm:ss a");
        private NumberFormat m_formatter = NumberFormat.getInstance();
        private List m_dataY = Collections.synchronizedList(new ArrayList());

        public MetricsSeriesModel() {
            this.m_dataY.add(0, new Integer(0));
        }

        public void close() {
            this.m_dateFormatter = null;
            this.m_dataY.clear();
            this.m_dataY = null;
        }

        public int getValueCount() {
            return 1;
        }

        public Object getYValueAt(int pos) {
            Object objValue = null;
            if (this.m_dataY != null) {
                objValue = this.m_dataY.get(pos);
            }
            return objValue;
        }

        public Object getXValueAt(int pos) {
            return MetricsBarSeries.this.m_value.getMetric();
        }

        public String getDescriptionAt(int pos) {
            StringBuffer sb = new StringBuffer();
            sb.append("Metric: " + MetricsBarSeries.this.m_value.getMetricDescription() + "\r\n");
            sb.append("Time: " + this.m_dateFormatter.format(MetricsBarSeries.this.m_value.getCurrency()) + "\r\n");
            sb.append("Value: " + this.m_formatter.format(this.getYValueAt(pos)));
            return sb.toString();
        }

        public String getLabelAt(int pos) {
            return null;
        }

        public void refresh() {
            Helper.invoke(new Runnable(){

                @Override
                public void run() {
                    MetricsSeriesModel.this.m_dataY.add(0, MetricsBarSeries.this.m_value.getValue());
                    MetricsSeriesModel.this.updateRanges();
                    MetricsSeriesModel.this.fireModelChanged();
                }
            });
        }

        public void updateRanges() {
            Long obj = MetricsBarSeries.this.m_value.getValue();
            if (obj instanceof Number) {
                double dMin = ((Number)obj).doubleValue();
                double dMax = ((Number)obj).doubleValue();
                Number numValue = obj;
                if (numValue != null) {
                    double dValue = numValue.doubleValue();
                    if (dMin > dValue) {
                        dMin = dValue;
                    }
                    if (dMax < dValue) {
                        dMax = dValue;
                    }
                }
                ((MathAxisMapper)MetricsBarSeries.this.m_yMapper).updateRange(dMax);
                ((MathAxisMapper)MetricsBarSeries.this.m_yMapper).updateRange(dMin);
            }
        }
    }
}

