/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.metrics;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.PreferenceManager;
import com.sonicsw.ma.gui.runtime.metrics.MetricValue;
import com.sonicsw.ma.gui.util.Helper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Vector;
import lt.monarch.chart.AbstractChartDataModel;
import lt.monarch.chart.AxisMapper;
import lt.monarch.chart.ChartDataModel2D;
import lt.monarch.chart.ChartDataModelAnnotations;
import lt.monarch.chart.Marker;
import lt.monarch.chart.chart2D.Axis2D;
import lt.monarch.chart.chart2D.Axis2DX;
import lt.monarch.chart.chart2D.ConnectedSeries;
import lt.monarch.chart.mapper.ScrollableMathAxisMapper;
import lt.monarch.chart.marker.DiamondMarker;

public class MetricsChartSeries {
    private static final float METRIC_LINE_STROKE = 0.75f;
    private MetricValue m_value = null;
    private ConnectedSeries m_series = null;
    private MetricsSeriesModel m_model = null;
    private DiamondMarker m_marker = null;
    private BasicStroke m_stroke = null;
    private Number m_objHighValue = null;
    private Number m_objLowValue = null;
    protected long m_lChartStartTime = 0L;

    public MetricsChartSeries(MetricValue value, Axis2DX xAxis, Axis2D yAxis, AxisMapper xMapper, Color color) {
        this.m_value = value;
        this.m_model = new MetricsSeriesModel(xMapper);
        this.m_series = new ConnectedSeries((ChartDataModel2D)this.m_model, (Axis2D)xAxis, yAxis);
        this.m_stroke = new BasicStroke(0.75f);
        this.m_series.style.setStroke((Stroke)this.m_stroke);
        this.m_marker = new DiamondMarker();
        this.m_series.showMarkers((Marker)this.m_marker);
        this.m_series.setLineColor(color);
        this.m_series.setName(this.getName());
    }

    public void close() {
        this.m_model.close();
        this.m_model = null;
        this.m_series.cleanup();
        this.m_series = null;
        this.m_stroke = null;
        this.m_marker = null;
    }

    public void fireUpdateEvents() {
        this.m_model.fireUpdateEvents();
    }

    public final ConnectedSeries getSeries() {
        return this.m_series;
    }

    public final AbstractChartDataModel getModel() {
        return this.m_model;
    }

    public final MetricValue getMetric() {
        return this.m_value;
    }

    public void setChartStartTime(long lChartStartTime) {
        this.m_lChartStartTime = lChartStartTime;
    }

    public void update() {
        Long numValue = this.m_value.getValue();
        if (numValue != null) {
            this.checkHighYValue(numValue);
            this.checkLowYValue(numValue);
            this.m_model.update();
        }
    }

    public final String getName() {
        return this.m_value.getMetric();
    }

    public Number getHighYValue() {
        return this.m_objHighValue;
    }

    public Number getLowYValue() {
        return this.m_objLowValue;
    }

    protected void checkHighYValue(Number objValue) {
        if (this.m_objHighValue == null || objValue.doubleValue() > this.m_objHighValue.doubleValue()) {
            this.m_objHighValue = objValue;
        }
    }

    protected void checkLowYValue(Number objValue) {
        if (this.m_objLowValue == null || objValue.doubleValue() < this.m_objLowValue.doubleValue()) {
            this.m_objLowValue = objValue;
        }
    }

    private class MetricsSeriesModel
    extends AbstractChartDataModel
    implements ChartDataModel2D,
    ChartDataModelAnnotations {
        private SimpleDateFormat m_dateFormatter = new SimpleDateFormat("h:mm:ss a");
        private AxisMapper m_xMapper = null;
        private Vector m_dataX = new Vector();
        private Vector m_dataY = new Vector();
        private NumberFormat m_formatter = NumberFormat.getInstance();
        private int m_nMaxPoints = -1;
        private int m_nPollInterval = -1;

        private MetricsSeriesModel(AxisMapper xMapper) {
            this.m_xMapper = xMapper;
            this.m_nMaxPoints = PreferenceManager.getInstance().getInt("preferences.metrics", "defaultMaxPlotPoints", 500);
            this.m_nPollInterval = PreferenceManager.getInstance().getInt("preferences.metrics", "pollFrequencySecs", 30);
        }

        public void close() {
            this.m_dataX.clear();
            this.m_dataX = null;
            this.m_dataY.clear();
            this.m_dataY = null;
            this.m_dateFormatter = null;
        }

        public void fireUpdateEvents() {
            this.fireModelChanged();
        }

        public int getValueCount() {
            return this.m_dataX.size();
        }

        public Object getXValueAt(int pos) {
            return new Integer(pos);
        }

        public Object getYValueAt(int pos) {
            if (this.m_dataY == null || this.m_dataY.isEmpty()) {
                return null;
            }
            return this.m_dataY.get(pos);
        }

        public void update() {
            int nPollLocation = this.getPollLocation();
            if (nPollLocation != -1) {
                this.addToVector(this.m_dataX, MetricsChartSeries.this.m_value.getCurrency(), nPollLocation);
                this.addToVector(this.m_dataY, MetricsChartSeries.this.m_value.getValue(), nPollLocation);
                this.updateRange();
                this.fireModelChanged();
            }
        }

        public String getDescriptionAt(int pos) {
            StringBuffer sb = new StringBuffer();
            sb.append("Metric: " + MetricsChartSeries.this.m_value.getMetricDescription() + "\r\n");
            sb.append("Value: " + this.m_formatter.format(this.getYValueAt(pos)) + "\r\n");
            sb.append("Time: " + this.m_dateFormatter.format(this.m_dataX.get(pos)) + "\r\n");
            sb.append("Poll Interval: " + pos);
            return sb.toString();
        }

        public String getLabelAt(int pos) {
            return null;
        }

        protected void addToVector(Vector v, Object objValue, int nIndex) {
            if (nIndex > v.size()) {
                v.setSize(nIndex);
            }
            Object objExistingValue = null;
            try {
                objExistingValue = v.get(nIndex);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            }
            if (objExistingValue == null) {
                v.add(nIndex, objValue);
            }
        }

        protected void updateRange() {
            if (!this.m_dataX.isEmpty()) {
                double dxMin = ((ScrollableMathAxisMapper)this.m_xMapper).getRange().getMinimum();
                double dxMax = ((ScrollableMathAxisMapper)this.m_xMapper).getRange().getMaximum();
                int nCount = this.m_dataX.size();
                if ((double)nCount >= dxMax) {
                    ((ScrollableMathAxisMapper)this.m_xMapper).setRange(dxMin, (double)nCount);
                    dxMax = nCount;
                }
                if (this.m_nMaxPoints != -1 && this.m_dataX.size() > this.m_nMaxPoints) {
                    double dNewTail = this.m_dataX.size() - this.m_nMaxPoints;
                    ((ScrollableMathAxisMapper)this.m_xMapper).setRange(dNewTail, dxMax);
                    this.m_dataX.setElementAt(null, new Double(dNewTail).intValue());
                }
            }
        }

        private int getPollLocation() {
            int nPollLocation = 0;
            Long lTimeZero = new Long(MetricsChartSeries.this.m_lChartStartTime);
            Long lTimeCurrentValue = MetricsChartSeries.this.m_value.getCurrency();
            Long lTimeDelta = new Long(lTimeCurrentValue - lTimeZero);
            if (lTimeDelta > 0L) {
                Long lPollInterval = new Long(1000 * this.m_nPollInterval);
                double dInterval = lTimeDelta.doubleValue() / lPollInterval.doubleValue();
                Helper.logDebugMessage("Poll Increment =" + dInterval);
                nPollLocation = new Double(Math.round(dInterval)).intValue();
            }
            return nPollLocation;
        }
    }
}

