/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.metrics;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.runtime.metrics.MarkerSelector;
import com.sonicsw.ma.gui.runtime.metrics.MetricValue;
import com.sonicsw.ma.gui.runtime.metrics.MetricsChart;
import com.sonicsw.ma.gui.runtime.metrics.MetricsChartSeries;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import lt.monarch.chart.AxisMapper;
import lt.monarch.chart.Chart;
import lt.monarch.chart.ChartObject;
import lt.monarch.chart.ChartPlugin;
import lt.monarch.chart.Grid;
import lt.monarch.chart.PlaneMapper;
import lt.monarch.chart.ScrollableAxisMapper;
import lt.monarch.chart.chart2D.Axis2D;
import lt.monarch.chart.chart2D.Axis2DX;
import lt.monarch.chart.chart2D.Axis2DY;
import lt.monarch.chart.chart2D.BoxZoomer;
import lt.monarch.chart.chart2D.Chart2D;
import lt.monarch.chart.chart2D.PlaneMapper2D;
import lt.monarch.chart.chart2D.ScrollableAxis2DX;
import lt.monarch.chart.chart2D.ScrollableAxis2DY;
import lt.monarch.chart.mapper.ScrollableMathAxisMapper;
import lt.monarch.chart.view.ToolTipManager;

public class MetricsLineChart
extends MetricsChart {
    public static final int MIN_VALUE = -1;
    public static final int MAX_VALUE = 1;
    private Chart2D m_chart = null;
    private ScrollableAxis2DX m_axisX = null;
    private ScrollableAxis2DY m_axisYL = null;
    private ScrollableAxis2DY m_axisYR = null;
    private ScrollableMathAxisMapper m_yMapper = null;
    private ScrollableMathAxisMapper m_xMapper = null;
    private Grid m_grid = null;
    private boolean m_bInitialized = false;
    private Collection m_colSeries = Collections.synchronizedList(new ArrayList());
    private MarkerSelector m_selector = null;
    private ToolTipManager m_tipMgr = null;
    private BoxZoomer m_zoomer = null;
    private PlaneMapper2D m_planeMapper = null;
    private long m_lChartStartTime = 0L;
    private RangeManagerInterface m_yRangeManager = null;
    private RangeManagerInterface m_xRangeManager = null;

    public MetricsLineChart(Collection colMetrics) {
        super((Chart)new Chart2D());
        this.m_colSeries = colMetrics;
    }

    @Override
    public void init() {
        try {
            if (!this.m_bInitialized) {
                this.m_chart = (Chart2D)super.getViewChart();
                this.createLayout();
                Collection colIncoming = this.m_colSeries;
                this.m_colSeries = Collections.synchronizedList(new ArrayList());
                Iterator iter = colIncoming.iterator();
                while (iter.hasNext()) {
                    this.createSeries((MetricValue)iter.next());
                }
                this.setupChart();
                this.m_bInitialized = true;
            }
            super.init();
        }
        catch (Exception e) {
            e.printStackTrace();
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.m_chart != null) {
            this.m_chart.removePlugin((ChartPlugin)this.m_tipMgr);
            this.m_chart.removePlugin((ChartPlugin)this.m_selector);
            this.m_chart.removePlugin((ChartPlugin)this.m_zoomer);
            this.m_chart.cleanup();
            this.m_selector = null;
            this.m_tipMgr = null;
            this.m_zoomer = null;
            this.m_chart = null;
        }
        if (this.m_colSeries != null) {
            Collection collection = this.m_colSeries;
            synchronized (collection) {
                for (MetricsChartSeries series : this.m_colSeries) {
                    series.close();
                }
                this.m_colSeries.clear();
            }
            this.m_colSeries = null;
        }
        this.removeAll();
        this.m_grid.cleanup();
        this.m_grid = null;
        this.m_yMapper = null;
        this.m_xMapper = null;
        this.m_axisX.cleanup();
        this.m_axisX = null;
        this.m_axisYL.cleanup();
        this.m_axisYL = null;
        this.m_axisYR.cleanup();
        this.m_axisYR = null;
        this.m_xRangeManager = null;
        this.m_yRangeManager = null;
        this.m_planeMapper = null;
        super.close();
    }

    public void add(MetricValue value) {
        MetricsChartSeries series = this.createSeries(value);
        if (value != null && value.getCurrency() != 0L && value.getCurrency() != -1L) {
            this.update(value);
        }
    }

    public void remove(MetricValue value) {
        MetricsChartSeries seriesToRemove = this.getSeries(value);
        this.m_chart.removeObject((ChartObject)seriesToRemove.getSeries());
        this.m_colSeries.remove(seriesToRemove);
        seriesToRemove.close();
        this.m_yMapper.setRange(-1.0, 0.0);
        this.m_yRangeManager.update();
    }

    public void update(MetricValue value) {
        MetricsChartSeries series;
        if (value != null && value.getCurrency() != 0L && value.getCurrency() != -1L && (series = this.getSeries(value)) != null) {
            if (this.m_lChartStartTime == 0L || this.m_lChartStartTime > value.getCurrency()) {
                this.m_lChartStartTime = value.getCurrency();
            }
            series.setChartStartTime(this.m_lChartStartTime);
            series.update();
            this.m_xRangeManager.update();
            this.m_yRangeManager.update();
            this.m_chart.invalidate();
        }
    }

    private MetricsChartSeries createSeries(MetricValue value) {
        MetricsChartSeries series = new MetricsChartSeries(value, (Axis2DX)this.m_axisX, (Axis2D)this.m_axisYL, (AxisMapper)this.m_xMapper, value.getColorId());
        this.m_colSeries.add(series);
        this.m_chart.addObject((ChartObject)series.getSeries());
        return series;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetricsChartSeries getSeries(MetricValue value) {
        MetricsChartSeries series = null;
        Collection collection = this.m_colSeries;
        synchronized (collection) {
            for (MetricsChartSeries seriesTemp : this.m_colSeries) {
                if (!seriesTemp.getMetric().equals(value)) continue;
                series = seriesTemp;
                break;
            }
        }
        return series;
    }

    private void setupChart() {
        this.m_chart.setObjects(this.createChartObjects());
        this.m_chart.setLeftYAxis((Axis2DY)this.m_axisYL);
        this.m_chart.setRightYAxis((Axis2DY)this.m_axisYR);
        this.m_chart.setXAxis((Axis2DX)this.m_axisX);
        this.m_tipMgr = new ToolTipManager();
        this.m_chart.addPlugin((ChartPlugin)this.m_tipMgr);
        this.m_selector = new MarkerSelector();
        this.m_chart.addPlugin((ChartPlugin)this.m_selector);
        this.m_zoomer = new BoxZoomer((ScrollableAxisMapper)this.m_xMapper, (ScrollableAxisMapper)this.m_yMapper);
        this.m_zoomer.enableDigitization((Axis2DX)this.m_axisX, null);
        this.m_chart.addPlugin((ChartPlugin)this.m_zoomer);
    }

    private void createLayout() {
        this.m_yMapper = new ScrollableMathAxisMapper(-1.0, 1.0);
        this.m_xMapper = new ScrollableMathAxisMapper(0.0, 1.0);
        this.m_xMapper.setVisibleRange(0.0, 1.0);
        this.m_axisX = new ScrollableAxis2DX((ScrollableAxisMapper)this.m_xMapper);
        this.m_axisX.setTitle("Poll Interval");
        this.m_axisYL = new ScrollableAxis2DY((ScrollableAxisMapper)this.m_yMapper);
        this.m_axisYL.setTitle("Value");
        this.m_axisYR = new ScrollableAxis2DY((ScrollableAxisMapper)this.m_yMapper);
        this.m_axisYR.setTitle("Value");
        this.m_planeMapper = new PlaneMapper2D();
        this.m_grid = new Grid((PlaneMapper)this.m_planeMapper, (AxisMapper)this.m_xMapper, (AxisMapper)this.m_yMapper);
        this.m_xRangeManager = new XRangeManager(this.m_xMapper);
        this.m_yRangeManager = new YRangeManager(this.m_yMapper);
    }

    private ChartObject[] createChartObjects() {
        ChartObject[] chartObjects = new ChartObject[4];
        int nIdx = 0;
        chartObjects[nIdx++] = this.m_grid;
        chartObjects[nIdx++] = this.m_axisX;
        chartObjects[nIdx++] = this.m_axisYL;
        chartObjects[nIdx++] = this.m_axisYR;
        return chartObjects;
    }

    private class YRangeManager
    extends AbstractRangeManager {
        private ScrollableMathAxisMapper m_yMapper;

        private YRangeManager(ScrollableMathAxisMapper yMapper) {
            this.m_yMapper = yMapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Number getHighValue() {
            Number nHighValue = null;
            Collection collection = MetricsLineChart.this.m_colSeries;
            synchronized (collection) {
                if (MetricsLineChart.this.m_colSeries != null) {
                    for (MetricsChartSeries series : MetricsLineChart.this.m_colSeries) {
                        Number nSeriesHighValue = series.getHighYValue();
                        if (nSeriesHighValue == null || nHighValue != null && !(nSeriesHighValue.doubleValue() > nHighValue.doubleValue())) continue;
                        nHighValue = nSeriesHighValue;
                    }
                }
            }
            return nHighValue != null ? (Number)nHighValue : (Number)new Double(1.0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Number getLowValue() {
            Number nLowValue = null;
            Collection collection = MetricsLineChart.this.m_colSeries;
            synchronized (collection) {
                if (MetricsLineChart.this.m_colSeries != null) {
                    for (MetricsChartSeries series : MetricsLineChart.this.m_colSeries) {
                        Number nSeriesLowValue = series.getLowYValue();
                        if (nSeriesLowValue == null || nLowValue != null && !(nSeriesLowValue.doubleValue() < nLowValue.doubleValue())) continue;
                        nLowValue = nSeriesLowValue;
                    }
                }
            }
            return nLowValue != null ? (Number)nLowValue : (Number)new Double(-1.0);
        }

        @Override
        public void update() {
            this.updateYRange(this.getLowValue(), this.getHighValue());
            super.update();
        }

        private void updateYRange(Number nLow, Number nHigh) {
            double dyMax = this.m_yMapper.getRange().getMaximum();
            double dyMin = this.m_yMapper.getRange().getMinimum();
            double dAdjustedHighValue = this.addBuffer(nHigh.doubleValue());
            double dAdjustedLowValue = this.subBuffer(nLow.doubleValue());
            if (dAdjustedHighValue > dyMax) {
                this.m_yMapper.setRange(dyMin, dAdjustedHighValue);
                dyMax = dAdjustedHighValue;
            }
            if (dAdjustedLowValue < dyMin || dyMin == -1.0) {
                this.m_yMapper.setRange(dAdjustedLowValue, dyMax);
                dyMin = dAdjustedLowValue;
            }
        }
    }

    private class XRangeManager
    extends AbstractRangeManager {
        private ScrollableMathAxisMapper m_xMapper;

        private XRangeManager(ScrollableMathAxisMapper xMapper) {
            this.m_xMapper = xMapper;
        }

        @Override
        public Number getHighValue() {
            return new Double(this.m_xMapper.getRange().getMaximum());
        }

        @Override
        public Number getLowValue() {
            return new Double(this.m_xMapper.getRange().getMinimum());
        }

        @Override
        public void update() {
            this.m_xMapper.setRange(this.getLowValue().doubleValue(), this.getHighValue().doubleValue());
            super.update();
        }
    }

    private abstract class AbstractRangeManager
    implements RangeManagerInterface {
        public static final float BUFFER = 0.05f;

        private AbstractRangeManager() {
        }

        @Override
        public abstract Number getHighValue();

        @Override
        public abstract Number getLowValue();

        @Override
        public void update() {
            this.fireUpdateEvents();
        }

        protected double addBuffer(double dValue) {
            return dValue + dValue * (double)0.05f;
        }

        protected double subBuffer(double dValue) {
            return dValue - dValue * (double)0.05f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireUpdateEvents() {
            if (MetricsLineChart.this.m_colSeries != null) {
                Collection collection = MetricsLineChart.this.m_colSeries;
                synchronized (collection) {
                    for (MetricsChartSeries series : MetricsLineChart.this.m_colSeries) {
                        series.fireUpdateEvents();
                    }
                }
            }
        }
    }

    private static interface RangeManagerInterface {
        public Number getHighValue();

        public Number getLowValue();

        public void update();
    }
}

