/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.metrics;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.runtime.metrics.JMetricsWatchOptionsDialog;
import com.sonicsw.ma.gui.runtime.metrics.MetricValue;
import com.sonicsw.ma.gui.runtime.metrics.MetricsWatchPanel;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.ModelListTableModel;
import com.sonicsw.ma.gui.table.RowTableColumn;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ColorIcon;
import com.sonicsw.ma.gui.util.EditableTablePanel;
import com.sonicsw.ma.gui.util.ExtendedJTable;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JRowTable;
import com.sonicsw.ma.gui.util.ResourceManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class MetricsTable
extends EditableTablePanel {
    protected MetricsWatchPanel m_panelParent = null;
    protected JRowTable m_table = null;
    protected JButton m_btnOptions = null;
    protected JButton m_btnRefresh = null;
    protected short m_nScope = (short)-1;
    private NumberFormat m_formatter = NumberFormat.getInstance();

    public MetricsTable(MetricsWatchPanel panelParent, short nScope) {
        super(false, false, true);
        this.prepareMetricsTable(panelParent, nScope);
    }

    private void prepareMetricsTable(MetricsWatchPanel panelParent, short nScope) {
        this.m_panelParent = panelParent;
        this.m_nScope = nScope;
        this.createGUI(this.m_nScope);
        this.setComponent(this.m_table);
        this.m_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MetricsTable.this.setUIState();
            }
        });
        this.setObjectIcon(ResourceManager.getIcon(this.getClass(), "Metric"));
        this.init();
        this.m_btnOptions = this.addButton(new OptionsAction(), "East", 1);
        this.m_btnOptions.setToolTipText("Options");
        if (MgmtConsole.DEVELOPER_MODE) {
            this.m_btnRefresh = this.addButton(new RefreshWatchAction(), "East", 1);
            this.m_btnRefresh.setToolTipText("Refresh");
        }
        this.getRemoveButton().setToolTipText("Remove");
        this.setBorder(new EmptyBorder(5, 5, 5, 0));
        this.setUIState();
    }

    public void init() {
        super.init("East", 1);
        this.setUIState();
    }

    @Override
    public void setUIState() {
        super.setUIState();
        if (this.m_btnOptions != null) {
            this.m_btnOptions.setEnabled(((BasicAction)this.m_btnOptions.getAction()).isEnabled());
        }
        if (this.m_btnRefresh != null) {
            this.m_btnRefresh.setEnabled(((BasicAction)this.m_btnRefresh.getAction()).isEnabled());
        }
    }

    @Override
    protected void onRemove() {
        Collection colValues = this.getSelectedRowValues();
        MetricValue[] values = colValues.toArray(new MetricValue[colValues.size()]);
        this.m_panelParent.removeWatch(values);
    }

    protected void onRefresh() {
        Collection colValues = this.getSelectedRowValues();
        MetricValue[] values = colValues.toArray(new MetricValue[colValues.size()]);
        this.m_panelParent.refreshWatch(values);
    }

    protected void onOptions() {
        try {
            JMetricsWatchOptionsDialog dialog;
            JMAFrame parent = (JMAFrame)SwingUtilities.getAncestorOfClass(JMAFrame.class, this.m_panelParent);
            JMetricsWatchOptionsDialog jMetricsWatchOptionsDialog = dialog = new JMetricsWatchOptionsDialog(parent);
            jMetricsWatchOptionsDialog.getClass();
            dialog.editInstance(null, jMetricsWatchOptionsDialog.new JMetricsWatchOptionsDialog.Model(this.m_panelParent), false);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to edit metrics watch properties", e, true);
        }
    }

    public JRowTable getTable() {
        return this.m_table;
    }

    public int getMetricCount() {
        return this.m_table.getRowCount();
    }

    public TableModel getModel() {
        return this.m_table.getModel();
    }

    public void maCleanup() {
        if (this.m_table != null) {
            this.m_table.cleanup();
        }
    }

    protected void createGUI(short nScope) {
        TableColumn[] tableColumns = null;
        tableColumns = nScope == 2 ? new TableColumn[]{new MetricColumn(0, "Metric", 40), new ValueColumn(1, "Value", 30), new CurrencyColumn(2, "Date & Time", 30)} : new TableColumn[]{new SourceColumn(0, "Source", 30), new MetricColumn(1, "Metric", 30), new ValueColumn(2, "Value", 20), new CurrencyColumn(3, "Date & Time", 20)};
        this.m_table = new JRowTable(tableColumns, this.getClass().getName());
        this.m_table.setSelectionMode(2);
        this.m_table.setDefaultRenderer(Object.class, new MetricsTableCellRenderer());
    }

    public Collection getSelectedRowValues() {
        ArrayList<Object> list = new ArrayList<Object>();
        int[] sel = this.m_table.getSelectedRows();
        for (int i = 0; sel != null && i < sel.length; ++i) {
            list.add(((IModelTableModel)this.m_table.getModel()).getRowModel(sel[i]));
        }
        return list;
    }

    public class MetricsTableCellRenderer
    extends ExtendedJTable.ExtendedTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel result = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (MetricsTable.this.m_nScope == 2 && column == 0 || MetricsTable.this.m_nScope != 2 && column == 1) {
                ModelListTableModel model = (ModelListTableModel)((JRowTable)table).getModel();
                MetricValue metricValue = (MetricValue)model.getRowModel(row);
                result.setIcon(new ColorIcon(metricValue.getColorId(), 14));
            } else {
                result.setIcon(null);
            }
            return result;
        }
    }

    public class OptionsAction
    extends BasicGuiAction {
        public OptionsAction() {
            super("MetricsWatchWindow.options");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            MetricsTable.this.onOptions();
        }
    }

    public class RefreshWatchAction
    extends BasicGuiAction {
        public RefreshWatchAction() {
            super("MetricsWatchWindow.refresh");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            MetricsTable.this.onRefresh();
        }
    }

    protected class CurrencyColumn
    extends RowTableColumn {
        CurrencyColumn(int modelIndex, String name, int width) {
            super(modelIndex, name, width);
            this.setColumnClass(Long.class);
            this.setColumnCellRenderer();
        }

        private void setColumnCellRenderer() {
            this.setCellRenderer(Helper.getDateTimeTableCellRenderer());
        }

        @Override
        public Object getColumnValue(Object rowModel) {
            return ((MetricValue)rowModel).getCurrency();
        }
    }

    protected class ValueColumn
    extends RowTableColumn {
        ValueColumn(int modelIndex, String name, int width) {
            super(modelIndex, name, width);
            this.setColumnClass(Long.class);
        }

        @Override
        public Object getColumnValue(Object rowModel) {
            Object objValue = ((MetricValue)rowModel).getValue();
            if (objValue instanceof Number) {
                objValue = MetricsTable.this.m_formatter.format(objValue);
            }
            return objValue;
        }
    }

    protected class MetricColumn
    extends RowTableColumn {
        MetricColumn(int modelIndex, String name, int width) {
            super(modelIndex, name, width);
        }

        @Override
        public Object getColumnValue(Object rowModel) {
            return ((MetricValue)rowModel).getMetric();
        }
    }

    protected class SourceColumn
    extends RowTableColumn {
        SourceColumn(int modelIndex, String name, int width) {
            super(modelIndex, name, width);
        }

        @Override
        public Object getColumnValue(Object rowModel) {
            return ((MetricValue)rowModel).getSource();
        }
    }
}

