/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.metrics;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.PreferenceManager;
import com.sonicsw.ma.gui.runtime.metrics.JMetricsWatchOptionsDialog;
import com.sonicsw.ma.gui.runtime.metrics.MetricValue;
import com.sonicsw.ma.gui.runtime.metrics.MetricsBarChart;
import com.sonicsw.ma.gui.runtime.metrics.MetricsLineChart;
import com.sonicsw.ma.gui.runtime.metrics.MetricsTable;
import com.sonicsw.ma.gui.runtime.metrics.model.AbstractMetricsModel;
import com.sonicsw.ma.gui.runtime.metrics.model.IMetricWatcher;
import com.sonicsw.ma.gui.runtime.metrics.model.IValueUpdatedEvent;
import com.sonicsw.ma.gui.runtime.metrics.model.MetricsModel;
import com.sonicsw.ma.gui.runtime.metrics.model.ValueUpdatedEvent;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.ModelListTableModel;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ColorSeries;
import com.sonicsw.ma.gui.util.ExtendedImageIcon;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.PopupMenuShower;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.ObjectName;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MetricsWatchPanel
extends JSplitPane
implements IMetricWatcher {
    protected static Color[] sm_listColors = new Color[]{Color.red, Color.green, Color.blue, Color.orange, Color.darkGray, Color.cyan, Color.pink, Color.yellow, Color.magenta, Color.black};
    protected short m_scope;
    protected MetricsTable m_table;
    protected MetricsLineChart m_chartLine;
    protected MetricsBarChart m_chartBar;
    protected HashMap m_subscriptions = new HashMap();
    protected HashMap m_modelMap = new HashMap();
    protected RemoveWatchAction m_removeAction = new RemoveWatchAction();
    protected RefreshWatchAction m_refreshAction = new RefreshWatchAction();
    protected int m_pollFrequency;
    protected int m_nMaxPoints;
    protected ColorSeries m_colors = new ColorSeries(sm_listColors);
    private JTabbedPane m_paneTabs;

    public MetricsWatchPanel(short scope) {
        super(0);
        this.m_scope = scope;
        this.prepareMetricsWatchPanel(scope);
    }

    private void prepareMetricsWatchPanel(short scope) {
        this.createGui(scope);
    }

    protected void createGui(short scope) {
        this.setOneTouchExpandable(true);
        this.m_table = this.createTable(scope);
        this.m_chartLine = new MetricsLineChart(new ArrayList());
        this.m_chartLine.init();
        this.m_chartLine.setBackground(this.getBackground());
        this.m_chartBar = new MetricsBarChart(new ArrayList());
        this.m_chartBar.init();
        this.m_chartBar.setBackground(this.getBackground());
        this.m_paneTabs = new JTabbedPane();
        this.m_paneTabs.addTab("Latest", ResourceManager.getIcon(this.getClass(), "viewbarchart"), (Component)((Object)this.m_chartBar));
        this.m_paneTabs.addTab("History", ResourceManager.getIcon(this.getClass(), "viewlinechart"), (Component)((Object)this.m_chartLine));
        this.m_paneTabs.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.add((Component)this.m_paneTabs, "top");
        this.add((Component)this.m_table, "bottom");
        JPopupMenu popup = new JPopupMenu();
        JComponent[] popupItem = this.getSelectedMenuItems(2);
        for (int i = 0; i < popupItem.length; ++i) {
            popup.add(popupItem[i]);
        }
        this.m_table.getTable().addMouseListener(new PopupMenuShower(this.m_table.getTable(), popup));
        this.m_table.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (evt.getValueIsAdjusting()) {
                    return;
                }
                MetricsWatchPanel.this.m_refreshAction.setEnabled(MetricsWatchPanel.this.m_table.getTable().getSelectedRowCount() > 0);
                MetricsWatchPanel.this.m_removeAction.setEnabled(MetricsWatchPanel.this.m_table.getTable().getSelectedRowCount() > 0);
            }
        });
    }

    protected MetricsTable createTable(short scope) {
        return new MetricsTable(this, scope);
    }

    @Override
    public void addNotify() {
        this.setDividerLocation(0.7);
        super.addNotify();
    }

    protected void maInitialize() {
        PreferenceManager pManager = PreferenceManager.getInstance();
        this.m_pollFrequency = pManager.getInt("preferences.metrics", "pollFrequencySecs", 30);
        this.m_nMaxPoints = pManager.getInt("preferences.metrics", "defaultMaxPlotPoints", 500);
    }

    protected void maCleanup() {
        for (Map.Entry entry : this.m_subscriptions.entrySet()) {
            ObjectName component = (ObjectName)entry.getKey();
            HashMap map = (HashMap)entry.getValue();
            MetricsModel model = (MetricsModel)((Object[])this.m_modelMap.get(component))[0];
            Iterator metricIds = map.keySet().iterator();
            while (metricIds.hasNext()) {
                model.removeValueListener((IMetricIdentity)metricIds.next(), this);
            }
            map.clear();
        }
        this.m_subscriptions.clear();
        this.m_subscriptions = null;
        this.m_modelMap.clear();
        this.m_modelMap = null;
        this.m_chartLine.close();
        this.m_chartLine = null;
        this.m_chartBar.close();
        this.m_chartBar = null;
        this.m_paneTabs.removeAll();
        this.m_paneTabs = null;
        this.m_removeAction = null;
        this.m_refreshAction = null;
        if (this.m_table != null) {
            this.m_table.maCleanup();
            this.m_table = null;
        }
    }

    public int getMetricCount() {
        return this.m_table.getMetricCount();
    }

    public JComponent[] getSelectedMenuItems(int type) {
        JComponent[] menuItems = null;
        if (type == 2) {
            menuItems = new JComponent[]{new JBasicMenuItem(new OptionsAction()), new JSeparator(), new JBasicMenuItem(this.m_removeAction)};
        }
        return menuItems;
    }

    private MetricValue[] getSelectedRowValues() {
        Collection colValues = this.m_table.getSelectedRowValues();
        return colValues.toArray(new MetricValue[colValues.size()]);
    }

    @Override
    public void addWatch(IMetricIdentity metricId, AbstractMetricsModel metricsModel) {
        MetricValue metricValue;
        ObjectName componentName = metricsModel.getComponentName();
        HashMap<IMetricIdentity, MetricValue> metricValues = (HashMap<IMetricIdentity, MetricValue>)this.m_subscriptions.get(componentName);
        if (metricValues == null) {
            metricValues = new HashMap<IMetricIdentity, MetricValue>();
            this.m_subscriptions.put(componentName, metricValues);
        }
        if ((metricValue = (MetricValue)metricValues.get(metricId)) == null) {
            Object[] modelUsage = (Object[])this.m_modelMap.get(componentName);
            if (modelUsage == null) {
                modelUsage = new Object[]{metricsModel, new int[]{0}};
                this.m_modelMap.put(componentName, modelUsage);
            }
            int[] nArray = (int[])modelUsage[1];
            nArray[0] = nArray[0] + 1;
            metricValue = new MetricValue(componentName, metricId);
            metricValue.setColorId(this.m_colors.getNextColor());
            metricValues.put(metricId, metricValue);
            ((IModelTableModel)this.m_table.getModel()).addRow(metricValue);
            this.m_chartLine.add(metricValue);
            this.m_chartBar.add(metricValue);
            metricsModel.addValueListener(metricId, this);
        }
    }

    @Override
    public void valueUpdated(IValueUpdatedEvent event) {
        MetricValue metricValue;
        ValueUpdatedEvent vue = (ValueUpdatedEvent)event;
        HashMap metricValues = (HashMap)this.m_subscriptions.get(vue.getSource());
        if (metricValues != null && (metricValue = (MetricValue)metricValues.get(vue.getMetricId())) != null) {
            int rowIndex = ((IModelTableModel)this.m_table.getModel()).getIndexOf(metricValue);
            metricValue.setValue(vue.getValue());
            metricValue.setCurrency(vue.getCurrencyTimestamp());
            Helper.logDebugMessage(metricValue.toDebug());
            if (rowIndex >= 0) {
                ((ModelListTableModel)this.m_table.getModel()).rowChanged(rowIndex);
            }
            this.m_chartLine.update(metricValue);
            this.m_chartBar.update();
        }
    }

    @Override
    public int getPollFrequency() {
        return this.m_pollFrequency;
    }

    @Override
    public void setPollFrequency(int pollFrequency) {
        this.m_pollFrequency = pollFrequency;
    }

    public int getMaxPoints() {
        return this.m_pollFrequency;
    }

    public void setMaxPoints(int nMaxPoints) {
        this.m_nMaxPoints = nMaxPoints;
    }

    public void removeWatch(MetricValue[] metricValue) {
        for (int i = 0; i < metricValue.length; ++i) {
            if (metricValue[i] == null) continue;
            ObjectName componentName = metricValue[i].getSourceName();
            IMetricIdentity metricId = metricValue[i].getMetricIdentity();
            HashMap metricValues = (HashMap)this.m_subscriptions.get(componentName);
            metricValues.remove(metricId);
            if (metricValues.isEmpty()) {
                this.m_subscriptions.remove(componentName);
            }
            Object[] modelUsage = (Object[])this.m_modelMap.get(componentName);
            MetricsModel metricsModel = (MetricsModel)modelUsage[0];
            int[] nArray = (int[])modelUsage[1];
            nArray[0] = nArray[0] - 1;
            if (((int[])modelUsage[1])[0] == 0) {
                this.m_modelMap.remove(componentName);
            }
            metricsModel.removeValueListener(metricId, this);
            this.m_chartLine.remove(metricValue[i]);
            this.m_chartBar.remove(metricValue[i]);
            ((IModelTableModel)this.m_table.getModel()).delete(metricValue[i]);
        }
    }

    public void refreshWatch(MetricValue[] metricValue) {
        for (int i = 0; i < metricValue.length; ++i) {
            if (metricValue[i] == null) continue;
            ObjectName componentName = metricValue[i].getSourceName();
            IMetricIdentity metricId = metricValue[i].getMetricIdentity();
            Object[] modelUsage = (Object[])this.m_modelMap.get(componentName);
            MetricsModel metricsModel = (MetricsModel)modelUsage[0];
            metricsModel.refreshMetricValues(new IMetricIdentity[]{metricId});
        }
    }

    @Override
    public short getWatchScope() {
        return this.m_scope;
    }

    public class OptionsAction
    extends BasicGuiAction {
        public OptionsAction() {
            super("MetricsWatchWindow.options");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                JMetricsWatchOptionsDialog dialog;
                JMAFrame parent = (JMAFrame)SwingUtilities.getAncestorOfClass(JMAFrame.class, MetricsWatchPanel.this);
                JMetricsWatchOptionsDialog jMetricsWatchOptionsDialog = dialog = new JMetricsWatchOptionsDialog(parent);
                jMetricsWatchOptionsDialog.getClass();
                dialog.editInstance(null, jMetricsWatchOptionsDialog.new JMetricsWatchOptionsDialog.Model(MetricsWatchPanel.this), false);
                dialog.setVisible(true);
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to edit metrics watch properties", e, true);
            }
        }
    }

    public class RefreshWatchAction
    extends BasicGuiAction {
        public RefreshWatchAction() {
            super("MetricsWatchWindow.refresh");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            MetricsWatchPanel.this.refreshWatch(MetricsWatchPanel.this.getSelectedRowValues());
        }
    }

    public class RemoveWatchAction
    extends BasicGuiAction {
        public RemoveWatchAction() {
            super("MetricsWatchWindow.remove");
            this.putSmallIconValue();
        }

        private void putSmallIconValue() {
            this.putValue("SmallIcon", new ExtendedImageIcon(ResourceManager.getIcon(this.getClass(), "metric"), ResourceManager.getIcon(this.getClass(), "deleteoverlay")));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            MetricsWatchPanel.this.removeWatch(MetricsWatchPanel.this.getSelectedRowValues());
        }
    }
}

