/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.metrics;

import com.sonicsw.ma.gui.IWorkspaceWindow;
import com.sonicsw.ma.gui.WorkspaceWindow;
import com.sonicsw.ma.gui.runtime.metrics.MetricsWatchPanel;
import com.sonicsw.ma.gui.runtime.metrics.model.AbstractMetricsModel;
import com.sonicsw.ma.gui.runtime.metrics.model.IMetricWatcher;
import com.sonicsw.ma.gui.runtime.metrics.model.IValueUpdatedEvent;
import com.sonicsw.ma.gui.util.JMAInternalFrame;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import java.util.HashMap;
import javax.management.ObjectName;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

class MetricsWatchWindow
extends JMAInternalFrame
implements IMetricWatcher,
IWorkspaceWindow {
    protected String m_scopeID = "";
    protected MetricsWatchPanel m_panelMetrics = null;
    protected WorkspaceWindow m_domainParent = null;
    protected static final HashMap m_watchWindows = new HashMap();

    static MetricsWatchWindow getWatchWindow(short scope, ObjectName scopeName) {
        String name = null;
        CanonicalName cName = new CanonicalName(scopeName.toString());
        switch (scope) {
            case 0: {
                name = cName.getDomainName();
                break;
            }
            case 1: {
                name = cName.getDomainName() + "." + cName.getContainerName();
                break;
            }
            default: {
                name = cName.getCanonicalName();
            }
        }
        MetricsWatchWindow window = (MetricsWatchWindow)m_watchWindows.get(scope + name);
        if (window == null) {
            window = new MetricsWatchWindow(scope, name);
            m_watchWindows.put(scope + name, window);
        }
        return window;
    }

    public void setDomainParent(WorkspaceWindow domainParent) {
        this.m_domainParent = domainParent;
    }

    protected MetricsWatchWindow(short scope, String scopeID) {
        super("metrics.watcher");
        this.prepareMetricsWatchWindow(scope, scopeID);
    }

    private void prepareMetricsWatchWindow(short scope, String scopeID) {
        this.setTitle(this.getTitle() + " - " + scopeID);
        this.setFrameIcon(ResourceManager.getIcon(this.getClass(), "linechart"));
        this.m_scopeID = scopeID;
        this.m_panelMetrics = new MetricsWatchPanel(scope);
        this.getContentPane().add(this.m_panelMetrics);
    }

    @Override
    protected void maInitialize() {
        this.m_panelMetrics.maInitialize();
    }

    @Override
    protected void maCleanup() {
        if (this.m_domainParent != null) {
            this.m_domainParent.removeDependantFrame(this);
        }
        if (this.m_panelMetrics != null) {
            m_watchWindows.remove(this.getWatchScope() + this.m_scopeID);
            this.m_panelMetrics.maCleanup();
            this.m_panelMetrics = null;
        }
    }

    @Override
    public boolean canClose() {
        boolean res = true;
        if (this.m_panelMetrics.getMetricCount() > 0) {
            res = JOptionPane.showConfirmDialog(this, "Are you sure you want to close watcher:\n" + this.m_scopeID, "Close Metrics Watcher", 0) == 0;
        }
        return res;
    }

    @Override
    public JComponent[] getSelectedMenuItems(int type) {
        return this.m_panelMetrics.getSelectedMenuItems(type);
    }

    @Override
    public void addWatch(IMetricIdentity metricId, AbstractMetricsModel metricsModel) {
        this.m_panelMetrics.addWatch(metricId, metricsModel);
    }

    @Override
    public void valueUpdated(IValueUpdatedEvent event) {
        this.m_panelMetrics.valueUpdated(event);
    }

    @Override
    public int getPollFrequency() {
        return this.m_panelMetrics.getPollFrequency();
    }

    @Override
    public void setPollFrequency(int pollFrequency) {
        this.m_panelMetrics.setPollFrequency(pollFrequency);
    }

    @Override
    public short getWatchScope() {
        return this.m_panelMetrics.getWatchScope();
    }
}

