/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.metrics.model;

import com.sonicsw.ma.gui.runtime.metrics.model.IValueListener;
import com.sonicsw.ma.gui.runtime.metrics.model.InstanceNode;
import com.sonicsw.ma.gui.runtime.metrics.model.InstanceParentNode;
import com.sonicsw.ma.gui.runtime.metrics.model.Node;
import com.sonicsw.ma.gui.runtime.metrics.model.ParentNode;
import com.sonicsw.ma.gui.runtime.util.AbstractNode;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mx.util.ICollationKeyProvider;
import com.sonicsw.mx.util.Sorter;
import java.text.CollationKey;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import javax.management.ObjectName;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public abstract class AbstractMetricsModel
extends DefaultTreeModel
implements ICollationKeyProvider {
    IRemoteMBeanServer m_connector;
    ObjectName m_componentName;
    String m_canonicalName;
    protected ParentNode m_treeRootNode;
    static final String[] METRIC_ID_SIGNATURE = new String[]{IMetricIdentity.class.getName()};
    static final String[] METRIC_IDS_SIGNATURE = new String[]{IMetricIdentity[].class.getName()};
    static final Object[] SINGLE_NULL_ARG = new Object[]{null};
    Hashtable m_valueListeners = new Hashtable();

    public AbstractMetricsModel(IRemoteMBeanServer connector, ObjectName componentName, IMetricInfo[] infos) throws Exception {
        super(new ParentNode(MetricsFactory.createMetricIdentity((String)""), ""));
        this.m_connector = connector;
        this.m_componentName = componentName;
        this.m_canonicalName = this.m_componentName.getCanonicalName();
        this.m_treeRootNode = this.getTreeRootNode();
    }

    private ParentNode getTreeRootNode() {
        return (ParentNode)super.getRoot();
    }

    public CollationKey getCollationKey(Object object) {
        if (object instanceof IMetricInfo) {
            return Sorter.COLLATOR.getCollationKey(((IMetricInfo)object).getMetricIdentity().getName());
        }
        if (object instanceof InstanceNode) {
            return Sorter.COLLATOR.getCollationKey(object.toString());
        }
        throw new IllegalArgumentException("Expected instance of IMetricInfo");
    }

    public ObjectName getComponentName() {
        return this.m_componentName;
    }

    public List getInstances(InstanceParentNode node) throws Exception {
        IMetricIdentity metricId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
        String[] instances = (String[])this.m_connector.invoke(this.m_componentName, "getInstanceMetricNames", new Object[]{metricId}, METRIC_ID_SIGNATURE);
        ArrayList<String> instancesList = new ArrayList<String>(instances.length);
        for (int i = 0; i < instances.length; ++i) {
            instancesList.add(instances[i]);
        }
        return instancesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasValueListeners(IMetricIdentity metricId) {
        Hashtable hashtable = this.m_valueListeners;
        synchronized (hashtable) {
            HashSet listeners = (HashSet)this.m_valueListeners.get(metricId);
            if (listeners == null) {
                return false;
            }
            return !listeners.isEmpty();
        }
    }

    protected void updateNode(IMetricIdentity id) {
        Enumeration<TreeNode> en = this.m_treeRootNode.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            AbstractNode node = (AbstractNode)en.nextElement();
            IMetricIdentity identity = null;
            if (node instanceof Node || node instanceof InstanceParentNode) {
                identity = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
            } else if (node instanceof InstanceNode) {
                identity = (IMetricIdentity)node.getUserObject();
            }
            if (identity == null || !identity.equals(id)) continue;
            final AbstractNode updatedNode = node;
            Helper.invoke(new Runnable(){

                @Override
                public void run() {
                    AbstractMetricsModel.this.nodeChanged(updatedNode);
                }
            });
            break;
        }
    }

    public abstract void update(IMetricInfo[] var1);

    public abstract void refreshTree() throws Exception;

    public abstract void refreshMetricValues(IMetricIdentity[] var1);

    public abstract void addValueListener(IMetricIdentity var1, IValueListener var2);

    public abstract void removeValueListener(IMetricIdentity var1, IValueListener var2);
}

